/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.ui.internal.items;

import java.lang.invoke.LambdaMetafactory;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.measure.Unit;
import javax.script.ScriptException;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.common.registry.Identifiable;
import org.openhab.core.common.registry.RegistryChangeListener;
import org.openhab.core.config.core.ConfigurableService;
import org.openhab.core.i18n.TimeZoneProvider;
import org.openhab.core.items.GroupItem;
import org.openhab.core.items.Item;
import org.openhab.core.items.ItemNotFoundException;
import org.openhab.core.items.ItemNotUniqueException;
import org.openhab.core.items.ItemRegistry;
import org.openhab.core.library.items.CallItem;
import org.openhab.core.library.items.ColorItem;
import org.openhab.core.library.items.ContactItem;
import org.openhab.core.library.items.DateTimeItem;
import org.openhab.core.library.items.DimmerItem;
import org.openhab.core.library.items.ImageItem;
import org.openhab.core.library.items.LocationItem;
import org.openhab.core.library.items.NumberItem;
import org.openhab.core.library.items.PlayerItem;
import org.openhab.core.library.items.RollershutterItem;
import org.openhab.core.library.items.StringItem;
import org.openhab.core.library.items.SwitchItem;
import org.openhab.core.library.types.DateTimeType;
import org.openhab.core.library.types.DecimalType;
import org.openhab.core.library.types.NextPreviousType;
import org.openhab.core.library.types.OnOffType;
import org.openhab.core.library.types.PercentType;
import org.openhab.core.library.types.PlayPauseType;
import org.openhab.core.library.types.QuantityType;
import org.openhab.core.model.sitemap.sitemap.ColorArray;
import org.openhab.core.model.sitemap.sitemap.Default;
import org.openhab.core.model.sitemap.sitemap.Group;
import org.openhab.core.model.sitemap.sitemap.IconRule;
import org.openhab.core.model.sitemap.sitemap.LinkableWidget;
import org.openhab.core.model.sitemap.sitemap.Mapping;
import org.openhab.core.model.sitemap.sitemap.Sitemap;
import org.openhab.core.model.sitemap.sitemap.SitemapFactory;
import org.openhab.core.model.sitemap.sitemap.Slider;
import org.openhab.core.model.sitemap.sitemap.Switch;
import org.openhab.core.model.sitemap.sitemap.VisibilityRule;
import org.openhab.core.model.sitemap.sitemap.Widget;
import org.openhab.core.transform.TransformationException;
import org.openhab.core.transform.TransformationHelper;
import org.openhab.core.transform.TransformationService;
import org.openhab.core.types.CommandDescription;
import org.openhab.core.types.State;
import org.openhab.core.types.StateDescription;
import org.openhab.core.types.StateOption;
import org.openhab.core.types.UnDefType;
import org.openhab.core.types.util.UnitUtils;
import org.openhab.core.ui.items.ItemUIProvider;
import org.openhab.core.ui.items.ItemUIRegistry;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(immediate=true, configurationPid={"org.openhab.sitemap"}, property={"service.pid=org.openhab.sitemap"})
@ConfigurableService(category="system", label="Sitemap", description_uri="system:sitemap")
public class ItemUIRegistryImpl
implements ItemUIRegistry {
    protected static final String CONFIG_URI = "system:sitemap";
    protected static final Pattern EXTRACT_TRANSFORM_FUNCTION_PATTERN = Pattern.compile("(.*?)\\((.*)\\):(.*)");
    protected static final String IDENTIFY_FORMAT_PATTERN_PATTERN = "%(?:(unit%)|(?:(?:\\d+\\$)?(?:[-#+ 0,(<]*)?(?:\\d+)?(?:\\.\\d+)?(?:[tT])?(?:[a-zA-Z])))";
    private static final Pattern FORMAT_PATTERN = Pattern.compile("(?:^|[^%])%(?:(unit%)|(?:(?:\\d+\\$)?(?:[-#+ 0,(<]*)?(?:\\d+)?(?:\\.\\d+)?(?:[tT])?(?:[a-zA-Z])))");
    private static final int MAX_BUTTONS = 4;
    private static final String DEFAULT_SORTING = "NONE";
    private final Logger logger = LoggerFactory.getLogger(ItemUIRegistryImpl.class);
    protected final Set<ItemUIProvider> itemUIProviders = new HashSet<ItemUIProvider>();
    private final ItemRegistry itemRegistry;
    private final TimeZoneProvider timeZoneProvider;
    private final Map<Widget, Widget> defaultWidgets = Collections.synchronizedMap(new WeakHashMap());
    private String groupMembersSorting = "NONE";

    @Activate
    public ItemUIRegistryImpl(@Reference ItemRegistry itemRegistry, @Reference TimeZoneProvider timeZoneProvider) {
        this.itemRegistry = itemRegistry;
        this.timeZoneProvider = timeZoneProvider;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void addItemUIProvider(ItemUIProvider itemUIProvider) {
        this.itemUIProviders.add(itemUIProvider);
    }

    public void removeItemUIProvider(ItemUIProvider itemUIProvider) {
        this.itemUIProviders.remove(itemUIProvider);
    }

    @Activate
    protected void activate(Map<String, Object> config) {
        this.applyConfig(config);
    }

    @Modified
    protected void modified(@Nullable Map<String, Object> config) {
        this.applyConfig(config);
    }

    private void applyConfig(@Nullable Map<String, Object> config) {
        String groupMembersSortingString;
        if (config != null && (groupMembersSortingString = Objects.toString(config.get("groupMembersSorting"), null)) != null) {
            this.groupMembersSorting = groupMembersSortingString;
        }
    }

    @Override
    public @Nullable String getCategory(String itemName) {
        for (ItemUIProvider provider : this.itemUIProviders) {
            String currentCategory = provider.getCategory(itemName);
            if (currentCategory == null) continue;
            return currentCategory;
        }
        String category = this.getItemCategory(itemName);
        if (category != null) {
            return category.toLowerCase();
        }
        Class<? extends Item> itemType = this.getItemType(itemName);
        if (itemType == null) {
            return null;
        }
        if (NumberItem.class.equals(itemType) || ContactItem.class.equals(itemType) || RollershutterItem.class.equals(itemType)) {
            return itemType.getSimpleName().replace("Item", "").toLowerCase();
        }
        return null;
    }

    @Override
    public @Nullable String getLabel(String itemName) {
        for (ItemUIProvider provider : this.itemUIProviders) {
            String currentLabel = provider.getLabel(itemName);
            if (currentLabel == null) continue;
            return currentLabel;
        }
        try {
            Item item = this.getItem(itemName);
            if (item.getLabel() != null) {
                return item.getLabel();
            }
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public @Nullable Widget getWidget(String itemName) {
        for (ItemUIProvider provider : this.itemUIProviders) {
            Widget currentWidget = provider.getWidget(itemName);
            if (currentWidget == null) continue;
            return this.resolveDefault(currentWidget);
        }
        return null;
    }

    @Override
    public @Nullable Widget getDefaultWidget(@Nullable Class<? extends Item> targetItemType, String itemName) {
        for (ItemUIProvider provider : this.itemUIProviders) {
            Widget widget = provider.getDefaultWidget(targetItemType, itemName);
            if (widget == null) continue;
            return widget;
        }
        Class<? extends Item> itemType = targetItemType;
        if (itemType == null) {
            itemType = this.getItemType(itemName);
        }
        if (itemType == null) {
            return null;
        }
        if (GroupItem.class.equals(itemType)) {
            return SitemapFactory.eINSTANCE.createGroup();
        }
        if (CallItem.class.equals(itemType) || ContactItem.class.equals(itemType) || DateTimeItem.class.equals(itemType)) {
            return SitemapFactory.eINSTANCE.createText();
        }
        if (ColorItem.class.equals(itemType)) {
            return SitemapFactory.eINSTANCE.createColorpicker();
        }
        if (DimmerItem.class.equals(itemType)) {
            Slider slider = SitemapFactory.eINSTANCE.createSlider();
            slider.setSwitchEnabled(true);
            slider.setReleaseOnly(true);
            return slider;
        }
        if (ImageItem.class.equals(itemType)) {
            return SitemapFactory.eINSTANCE.createImage();
        }
        if (LocationItem.class.equals(itemType)) {
            return SitemapFactory.eINSTANCE.createMapview();
        }
        if (NumberItem.class.isAssignableFrom(itemType) || StringItem.class.equals(itemType)) {
            boolean isReadOnly = this.isReadOnly(itemName);
            int commandOptionsSize = this.getCommandOptionsSize(itemName);
            if (!isReadOnly && commandOptionsSize > 0) {
                return commandOptionsSize <= 4 ? SitemapFactory.eINSTANCE.createSwitch() : SitemapFactory.eINSTANCE.createSelection();
            }
            if (!isReadOnly && this.hasStateOptions(itemName)) {
                return SitemapFactory.eINSTANCE.createSelection();
            }
            if (!isReadOnly && NumberItem.class.isAssignableFrom(itemType) && this.hasItemTag(itemName, "Setpoint")) {
                return SitemapFactory.eINSTANCE.createSetpoint();
            }
            if (!isReadOnly && NumberItem.class.isAssignableFrom(itemType) && this.hasItemTag(itemName, "ColorTemperature")) {
                return SitemapFactory.eINSTANCE.createColortemperaturepicker();
            }
            return SitemapFactory.eINSTANCE.createText();
        }
        if (PlayerItem.class.equals(itemType)) {
            return this.createPlayerButtons();
        }
        if (RollershutterItem.class.equals(itemType) || SwitchItem.class.equals(itemType)) {
            return SitemapFactory.eINSTANCE.createSwitch();
        }
        return null;
    }

    private Switch createPlayerButtons() {
        Switch playerItemSwitch = SitemapFactory.eINSTANCE.createSwitch();
        EList mappings = playerItemSwitch.getMappings();
        Mapping commandMapping = SitemapFactory.eINSTANCE.createMapping();
        mappings.add(commandMapping);
        commandMapping.setCmd(NextPreviousType.PREVIOUS.name());
        commandMapping.setLabel("<<");
        commandMapping = SitemapFactory.eINSTANCE.createMapping();
        mappings.add(commandMapping);
        commandMapping.setCmd(PlayPauseType.PAUSE.name());
        commandMapping.setLabel("||");
        commandMapping = SitemapFactory.eINSTANCE.createMapping();
        mappings.add(commandMapping);
        commandMapping.setCmd(PlayPauseType.PLAY.name());
        commandMapping.setLabel(">");
        commandMapping = SitemapFactory.eINSTANCE.createMapping();
        mappings.add(commandMapping);
        commandMapping.setCmd(NextPreviousType.NEXT.name());
        commandMapping.setLabel(">>");
        return playerItemSwitch;
    }

    @Override
    public @Nullable String getLabel(Widget w) {
        Object label = this.getLabelFromWidget((Widget)w).label;
        String itemName = w.getItem();
        if (itemName == null || itemName.isBlank()) {
            return this.transform((String)label, true, null, null);
        }
        Object labelMappedOption = null;
        State state = null;
        StateDescription stateDescription = null;
        Object formatPattern = this.getFormatPattern(w);
        if (formatPattern != null && ((String)label).indexOf("[") < 0) {
            label = (String)label + " [" + (String)formatPattern + "]";
        }
        try {
            Item item = this.getItem(itemName);
            stateDescription = item.getStateDescription();
            if (formatPattern != null) {
                state = item.getState();
                if (((String)formatPattern).contains("%d")) {
                    if (!(state instanceof UnDefType) && !(state instanceof Number)) {
                        state = item.getStateAs(DecimalType.class);
                    }
                    formatPattern = ((String)formatPattern).replace("%d", "%.0f");
                }
            }
        }
        catch (ItemNotFoundException e) {
            this.logger.warn("Cannot retrieve item '{}' for widget {}", (Object)itemName, (Object)w.eClass().getInstanceTypeName());
        }
        boolean considerTransform = false;
        String transformFailbackValue = null;
        if (formatPattern != null) {
            if (((String)formatPattern).isEmpty()) {
                label = ((String)label).substring(0, ((String)label).indexOf("[")).trim();
            } else {
                if (state == null) {
                    formatPattern = this.formatUndefined((String)formatPattern);
                    considerTransform = true;
                } else if (state instanceof UnDefType) {
                    Matcher matcher = EXTRACT_TRANSFORM_FUNCTION_PATTERN.matcher((CharSequence)formatPattern);
                    if (matcher.find()) {
                        considerTransform = true;
                        String type = matcher.group(1);
                        String function = matcher.group(2);
                        formatPattern = type + "(" + function + "):" + state.toString();
                        transformFailbackValue = "-";
                    } else {
                        formatPattern = this.formatUndefined((String)formatPattern);
                    }
                } else {
                    if (stateDescription != null) {
                        for (StateOption option : stateDescription.getOptions()) {
                            String formatPatternOption;
                            String optionLabel = option.getLabel();
                            if (!option.getValue().equals(state.toString()) || optionLabel == null) continue;
                            try {
                                formatPatternOption = String.format((String)formatPattern, optionLabel);
                            }
                            catch (IllegalFormatException e) {
                                this.logger.debug("Mapping option value '{}' for item {} using format '{}' failed ({}); format is ignored and option label is used", new Object[]{optionLabel, itemName, formatPattern, e.getMessage()});
                                formatPatternOption = optionLabel;
                            }
                            labelMappedOption = ((String)label).trim();
                            labelMappedOption = ((String)labelMappedOption).substring(0, ((String)labelMappedOption).indexOf("[") + 1) + formatPatternOption + "]";
                            break;
                        }
                    }
                    if (state instanceof DecimalType) {
                        if (((String)formatPattern).contains("%unit%")) {
                            formatPattern = ((String)formatPattern).replaceAll("%unit%", "").stripTrailing();
                        }
                    } else if (state instanceof QuantityType) {
                        QuantityType quantityState = (QuantityType)state;
                        Unit patternUnit = UnitUtils.parseUnit((String)formatPattern);
                        if (patternUnit != null && !quantityState.getUnit().equals(patternUnit)) {
                            quantityState = quantityState.toInvertibleUnit(patternUnit);
                        }
                        if (quantityState != null) {
                            quantityState = this.convertStateToWidgetUnit(quantityState, w);
                            state = quantityState;
                        }
                    }
                    try {
                        Matcher matcher = EXTRACT_TRANSFORM_FUNCTION_PATTERN.matcher((CharSequence)formatPattern);
                        if (matcher.find()) {
                            considerTransform = true;
                            String type = matcher.group(1);
                            String function = matcher.group(2);
                            String value = matcher.group(3);
                            formatPattern = type + "(" + function + "):";
                            if (state instanceof DateTimeType) {
                                DateTimeType dateTimeState = (DateTimeType)state;
                                formatPattern = (String)formatPattern + dateTimeState.format(value, this.timeZoneProvider.getTimeZone());
                                transformFailbackValue = dateTimeState.toFullString(this.timeZoneProvider.getTimeZone());
                            } else {
                                formatPattern = (String)formatPattern + state.format(value);
                                transformFailbackValue = state.toString();
                            }
                        } else if (state instanceof DateTimeType) {
                            DateTimeType dateTimeState = (DateTimeType)state;
                            formatPattern = dateTimeState.format((String)formatPattern, this.timeZoneProvider.getTimeZone());
                        } else {
                            formatPattern = state.format((String)formatPattern);
                        }
                    }
                    catch (IllegalArgumentException e) {
                        this.logger.warn("Exception while formatting value '{}' of item {} with format '{}': {}", new Object[]{state, itemName, formatPattern, e.getMessage()});
                        formatPattern = "Err";
                    }
                }
                label = ((String)label).trim();
                int index = ((String)label).indexOf("[");
                if (index >= 0) {
                    label = ((String)label).substring(0, index + 1) + (String)formatPattern + "]";
                }
            }
        }
        return this.transform((String)label, considerTransform, transformFailbackValue, (String)labelMappedOption);
    }

    @Override
    public ItemUIRegistry.WidgetLabelSource getLabelSource(Widget w) {
        return this.getLabelFromWidget((Widget)w).source;
    }

    private QuantityType<?> convertStateToWidgetUnit(QuantityType<?> quantityState, Widget w) {
        Unit widgetUnit = UnitUtils.parseUnit((String)this.getFormatPattern(w));
        if (widgetUnit != null && !widgetUnit.equals(quantityState.getUnit())) {
            return Objects.requireNonNullElse(quantityState.toInvertibleUnit(widgetUnit), quantityState);
        }
        return quantityState;
    }

    @Override
    public @Nullable String getFormatPattern(Widget w) {
        Item item;
        String itemName;
        String pattern;
        block9: {
            StateDescription stateDescription;
            String label = this.getLabelFromWidget((Widget)w).label;
            pattern = this.getFormatPattern(label);
            itemName = w.getItem();
            item = null;
            if (itemName != null && !itemName.isBlank()) {
                item = this.getItem(itemName);
            }
            if (item != null && pattern == null && (stateDescription = item.getStateDescription()) != null) {
                pattern = stateDescription.getPattern();
            }
            if (pattern != null) break block9;
            return null;
        }
        try {
            NumberItem numberItem;
            if (item instanceof NumberItem && (numberItem = (NumberItem)item).getDimension() != null) {
                Matcher m = FORMAT_PATTERN.matcher(pattern);
                int matcherEnd = 0;
                if (m.find() && m.group(1) == null) {
                    matcherEnd = m.end();
                }
                String unit = pattern.substring(matcherEnd).trim();
                String postfix = "";
                int unitEnd = unit.indexOf(" ");
                if (unitEnd > -1) {
                    postfix = unit.substring(unitEnd + 1).trim();
                    unit = unit.substring(0, unitEnd);
                }
                if (!postfix.isBlank()) {
                    this.logger.warn("Item '{}' with unit, nothing allowed after unit in label pattern '{}', dropping postfix", (Object)itemName, (Object)pattern);
                }
                pattern = unit.isBlank() ? pattern.substring(0, matcherEnd) : pattern.substring(0, pattern.indexOf(unit, matcherEnd) + unit.length());
            }
        }
        catch (ItemNotFoundException e) {
            this.logger.warn("Cannot retrieve item '{}' for widget {}", (Object)itemName, (Object)w.eClass().getInstanceTypeName());
        }
        return pattern;
    }

    private @Nullable String getFormatPattern(@Nullable String label) {
        int indexCloseBracket;
        if (label == null) {
            return null;
        }
        String pattern = label.trim();
        int indexOpenBracket = pattern.indexOf("[");
        int n = indexCloseBracket = pattern.endsWith("]") ? pattern.length() - 1 : -1;
        if (indexOpenBracket >= 0 && indexCloseBracket > indexOpenBracket) {
            return pattern.substring(indexOpenBracket + 1, indexCloseBracket);
        }
        return null;
    }

    private WidgetLabelWithSource getLabelFromWidget(Widget w) {
        String label = null;
        ItemUIRegistry.WidgetLabelSource source = ItemUIRegistry.WidgetLabelSource.NONE;
        if (w.getLabel() != null) {
            label = w.getLabel();
            source = ItemUIRegistry.WidgetLabelSource.SITEMAP_WIDGET;
        } else {
            String itemName = w.getItem();
            if (itemName != null) {
                label = this.getLabel(itemName);
                if (label != null) {
                    source = ItemUIRegistry.WidgetLabelSource.ITEM_LABEL;
                } else {
                    label = itemName;
                    source = ItemUIRegistry.WidgetLabelSource.ITEM_NAME;
                }
            }
        }
        return new WidgetLabelWithSource(label != null ? label : "", source);
    }

    protected String formatUndefined(String formatPattern) {
        String undefinedFormatPattern = formatPattern.replaceAll(IDENTIFY_FORMAT_PATTERN_PATTERN, "%1\\$s");
        try {
            return String.format(undefinedFormatPattern, "-");
        }
        catch (Exception e) {
            this.logger.warn("Exception while formatting undefined value [sourcePattern={}, targetPattern={}, exceptionMessage={}]", new Object[]{formatPattern, undefinedFormatPattern, e.getMessage()});
            return "Err";
        }
    }

    private String insertInLabel(String label, Object o) {
        return label.substring(0, label.indexOf("[") + 1) + String.valueOf(o) + "]";
    }

    private String transform(String label, boolean matchTransform, @Nullable String transformFailbackValue, @Nullable String labelMappedOption) {
        String ret;
        block11: {
            ret = label;
            String formatPattern = this.getFormatPattern(label);
            if (formatPattern != null) {
                Matcher matcher = EXTRACT_TRANSFORM_FUNCTION_PATTERN.matcher(formatPattern);
                if (matchTransform && matcher.find()) {
                    String type = matcher.group(1);
                    String function = matcher.group(2);
                    String value = matcher.group(3);
                    String failbackValue = transformFailbackValue != null ? transformFailbackValue : value;
                    try {
                        TransformationService transformation = TransformationHelper.getTransformationService((String)type);
                        if (transformation != null) {
                            try {
                                String transformationResult = transformation.transform(function, value);
                                if (transformationResult != null) {
                                    ret = this.insertInLabel(label, transformationResult);
                                } else {
                                    this.logger.warn("Transformation of type {} did not return a valid result", (Object)type);
                                    ret = this.insertInLabel(label, failbackValue);
                                }
                                break block11;
                            }
                            catch (RuntimeException e) {
                                throw new TransformationException("Transformation service of type '" + type + "' threw an exception: " + e.getMessage(), (Throwable)e);
                            }
                        }
                        throw new TransformationException("Transformation service of type '" + type + "' is not available.");
                    }
                    catch (TransformationException e) {
                        Throwable cause = e.getCause();
                        this.logger.warn("Failed transforming the value '{}' with pattern '{}': {}", new Object[]{value, formatPattern, cause instanceof ScriptException ? cause.getMessage() : e.getMessage()});
                        ret = this.insertInLabel(label, failbackValue);
                    }
                } else if (labelMappedOption != null) {
                    ret = labelMappedOption;
                }
            }
        }
        return ret;
    }

    @Override
    public @Nullable String getCategory(Widget w) {
        String widgetTypeName = w.eClass().getInstanceTypeName().substring(w.eClass().getInstanceTypeName().lastIndexOf(".") + 1);
        String category = widgetTypeName.toLowerCase();
        String conditionalIcon = this.getConditionalIcon(w);
        if (w.getIcon() != null) {
            category = w.getIcon();
        } else if (w.getStaticIcon() != null) {
            category = w.getStaticIcon();
        } else if (conditionalIcon != null) {
            category = conditionalIcon;
        } else {
            String result;
            String itemName = w.getItem();
            if (itemName != null && (result = this.getCategory(itemName)) != null) {
                category = result;
            }
        }
        return category;
    }

    @Override
    public @Nullable State getState(Widget w) {
        String itemName = w.getItem();
        if (itemName != null) {
            try {
                Item item = this.getItem(itemName);
                return this.convertState(w, item, item.getState());
            }
            catch (ItemNotFoundException e) {
                this.logger.warn("Cannot retrieve item '{}' for widget {}", (Object)itemName, (Object)w.eClass().getInstanceTypeName());
            }
        }
        return UnDefType.UNDEF;
    }

    @Override
    public @Nullable State convertState(Widget w, Item i, State state) {
        State returnState = null;
        QuantityType<?> itemState = i.getState();
        if (itemState instanceof QuantityType) {
            QuantityType quantityTypeState = (QuantityType)itemState;
            itemState = this.convertStateToWidgetUnit(quantityTypeState, w);
        }
        if (w instanceof Switch && i instanceof RollershutterItem) {
            returnState = itemState.as(PercentType.class);
        } else if (w instanceof Slider) {
            if (i.getAcceptedDataTypes().contains(PercentType.class)) {
                returnState = itemState.as(PercentType.class);
            } else if (!(itemState instanceof QuantityType)) {
                returnState = itemState.as(DecimalType.class);
            }
        } else if (w instanceof Switch) {
            Switch sw = (Switch)w;
            StateDescription stateDescr = i.getStateDescription();
            if (sw.getMappings().isEmpty() && (stateDescr == null || stateDescr.getOptions().isEmpty())) {
                returnState = itemState.as(OnOffType.class);
            }
        }
        return (State)Objects.requireNonNullElse(returnState, itemState);
    }

    @Override
    public @Nullable Widget getWidget(Sitemap sitemap, String id) {
        if (!id.isEmpty()) {
            Widget w = this.getWidget(id);
            if (w == null) {
                w = this.getDefaultWidget(null, id);
            }
            if (w != null) {
                w.setItem(id);
            } else {
                try {
                    int widgetID = Integer.parseInt(id.substring(0, 2));
                    if (widgetID < sitemap.getChildren().size()) {
                        w = (Widget)sitemap.getChildren().get(widgetID);
                        int i = 2;
                        while (i < id.length()) {
                            int childWidgetID = Integer.parseInt(id.substring(i, i + 2));
                            if (childWidgetID < ((LinkableWidget)w).getChildren().size()) {
                                w = (Widget)((LinkableWidget)w).getChildren().get(childWidgetID);
                            }
                            i += 2;
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return this.resolveDefault(w);
        }
        this.logger.warn("Cannot find page for id '{}'.", (Object)id);
        return null;
    }

    @Override
    public EList<Widget> getChildren(Sitemap sitemap) {
        EList widgets = sitemap.getChildren();
        BasicEList result = new BasicEList();
        widgets.stream().map(this::resolveDefault).filter(Objects::nonNull).map(Objects::requireNonNull).forEach(arg_0 -> ((EList)result).add(arg_0));
        return result;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public EList<Widget> getChildren(LinkableWidget w) {
        if (!(w instanceof Group)) ** GOTO lbl-1000
        group = (Group)w;
        if (w.getChildren().isEmpty()) {
            widgets = this.getDynamicGroupChildren(group);
        } else lbl-1000:
        // 2 sources

        {
            widgets = w.getChildren();
        }
        result = new BasicEList();
        widgets.stream().map((Function<Widget, Widget>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, resolveDefault(org.openhab.core.model.sitemap.sitemap.Widget ), (Lorg/openhab/core/model/sitemap/sitemap/Widget;)Lorg/openhab/core/model/sitemap/sitemap/Widget;)((ItemUIRegistryImpl)this)).filter((Predicate<Widget>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, nonNull(java.lang.Object ), (Lorg/openhab/core/model/sitemap/sitemap/Widget;)Z)()).map((Function<Widget, Widget>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, requireNonNull(T ), (Lorg/openhab/core/model/sitemap/sitemap/Widget;)Lorg/openhab/core/model/sitemap/sitemap/Widget;)()).forEach((Consumer<Widget>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, add(E ), (Lorg/openhab/core/model/sitemap/sitemap/Widget;)V)((EList)result));
        return result;
    }

    @Override
    public @Nullable EObject getParent(Widget w) {
        Widget w2 = this.defaultWidgets.get(w);
        return w2 == null ? w.eContainer() : w2.eContainer();
    }

    private @Nullable Widget resolveDefault(@Nullable Widget widget) {
        Widget defaultWidget;
        Item item;
        if (!(widget instanceof Default)) {
            return widget;
        }
        String itemName = widget.getItem();
        if (itemName != null && (item = this.get(itemName)) != null && (defaultWidget = this.getDefaultWidget(item.getClass(), item.getName())) != null) {
            this.copyProperties(widget, defaultWidget);
            this.defaultWidgets.put(defaultWidget, widget);
            return defaultWidget;
        }
        return null;
    }

    private void copyProperties(Widget source, Widget target) {
        target.setItem(source.getItem());
        target.setIcon(source.getIcon());
        target.setStaticIcon(source.getStaticIcon());
        target.setLabel(source.getLabel());
        target.getVisibility().addAll(EcoreUtil.copyAll((Collection)source.getVisibility()));
        target.getLabelColor().addAll(EcoreUtil.copyAll((Collection)source.getLabelColor()));
        target.getValueColor().addAll(EcoreUtil.copyAll((Collection)source.getValueColor()));
        target.getIconColor().addAll(EcoreUtil.copyAll((Collection)source.getIconColor()));
        target.getIconRules().addAll(EcoreUtil.copyAll((Collection)source.getIconRules()));
    }

    private EList<Widget> getDynamicGroupChildren(Group group) {
        BasicEList children;
        block13: {
            children = new BasicEList();
            String itemName = group.getItem();
            try {
                block14: {
                    Item item;
                    block15: {
                        if (itemName == null) break block14;
                        item = this.getItem(itemName);
                        if (!(item instanceof GroupItem)) break block15;
                        GroupItem groupItem = (GroupItem)item;
                        ArrayList<Item> members = new ArrayList<Item>(groupItem.getMembers());
                        switch (this.groupMembersSorting) {
                            case "LABEL": {
                                members.sort((u1, u2) -> {
                                    String u1Label = u1.getLabel();
                                    String u2Label = u2.getLabel();
                                    if (u1Label != null && u2Label != null) {
                                        return u1Label.compareTo(u2Label);
                                    }
                                    return u1.getName().compareTo(u2.getName());
                                });
                                break;
                            }
                            case "NAME": {
                                members.sort(Comparator.comparing(Item::getName));
                                break;
                            }
                        }
                        for (Item member : members) {
                            Widget widget = this.getDefaultWidget(member.getClass(), member.getName());
                            if (widget == null) continue;
                            widget.setItem(member.getName());
                            children.add((Object)widget);
                        }
                        break block13;
                    }
                    this.logger.warn("Item '{}' is not a group.", (Object)item.getName());
                    break block13;
                }
                this.logger.warn("Dynamic group with label '{}' does not specify an associated item - ignoring it.", (Object)group.getLabel());
            }
            catch (ItemNotFoundException e) {
                this.logger.warn("Dynamic group with label '{}' will be ignored, because its item '{}' does not exist.", (Object)group.getLabel(), (Object)itemName);
            }
        }
        return children;
    }

    private boolean isReadOnly(String itemName) {
        try {
            Item item = this.getItem(itemName);
            StateDescription stateDescription = item.getStateDescription();
            return stateDescription != null && stateDescription.isReadOnly();
        }
        catch (ItemNotFoundException e) {
            return false;
        }
    }

    private boolean hasStateOptions(String itemName) {
        try {
            Item item = this.getItem(itemName);
            StateDescription stateDescription = item.getStateDescription();
            return stateDescription != null && !stateDescription.getOptions().isEmpty();
        }
        catch (ItemNotFoundException e) {
            return false;
        }
    }

    private int getCommandOptionsSize(String itemName) {
        try {
            Item item = this.getItem(itemName);
            CommandDescription commandDescription = item.getCommandDescription();
            return commandDescription != null ? commandDescription.getCommandOptions().size() : 0;
        }
        catch (ItemNotFoundException e) {
            return 0;
        }
    }

    private @Nullable Class<? extends Item> getItemType(String itemName) {
        try {
            Item item = this.getItem(itemName);
            return item.getClass();
        }
        catch (ItemNotFoundException e) {
            return null;
        }
    }

    @Override
    public @Nullable State getItemState(String itemName) {
        try {
            Item item = this.getItem(itemName);
            return item.getState();
        }
        catch (ItemNotFoundException e) {
            return null;
        }
    }

    public @Nullable String getItemCategory(String itemName) {
        try {
            Item item = this.getItem(itemName);
            return item.getCategory();
        }
        catch (ItemNotFoundException e) {
            return null;
        }
    }

    private boolean hasItemTag(String itemName, String tag) {
        try {
            Item item = this.getItem(itemName);
            return item.hasTag(tag);
        }
        catch (ItemNotFoundException e) {
            return false;
        }
    }

    public Item getItem(String name) throws ItemNotFoundException {
        return this.itemRegistry.getItem(name);
    }

    public Item getItemByPattern(String name) throws ItemNotFoundException, ItemNotUniqueException {
        return this.itemRegistry.getItemByPattern(name);
    }

    public Collection<Item> getItems() {
        return this.itemRegistry.getItems();
    }

    public Collection<Item> getItemsOfType(String type) {
        return this.itemRegistry.getItemsOfType(type);
    }

    public Collection<Item> getItems(String pattern) {
        return this.itemRegistry.getItems(pattern);
    }

    public void addRegistryChangeListener(RegistryChangeListener<Item> listener) {
        this.itemRegistry.addRegistryChangeListener(listener);
    }

    public void removeRegistryChangeListener(RegistryChangeListener<Item> listener) {
        this.itemRegistry.removeRegistryChangeListener(listener);
    }

    public Collection<Item> getAll() {
        return this.itemRegistry.getAll();
    }

    public Stream<Item> stream() {
        return this.itemRegistry.stream();
    }

    @Override
    public String getWidgetId(Widget widget) {
        Object index;
        Widget w2 = this.defaultWidgets.get(widget);
        if (w2 != null) {
            return this.getWidgetId(w2);
        }
        Object id = "";
        Widget w = widget;
        while (w.eContainer() instanceof Widget) {
            Widget parent = (Widget)w.eContainer();
            index = String.valueOf(((LinkableWidget)parent).getChildren().indexOf((Object)w));
            if (((String)index).length() == 1) {
                index = "0" + (String)index;
            }
            id = (String)index + (String)id;
            w = parent;
        }
        if (w.eContainer() instanceof Sitemap) {
            Sitemap sitemap = (Sitemap)w.eContainer();
            index = String.valueOf(sitemap.getChildren().indexOf((Object)w));
            if (((String)index).length() == 1) {
                index = "0" + (String)index;
            }
            id = (String)index + (String)id;
        }
        if (w.eContainer() == null) {
            id = w.getItem();
        }
        return id;
    }

    private boolean matchStateToValue(State state, String value, @Nullable String matchCondition) {
        boolean matched;
        block51: {
            Condition condition;
            String unquotedValue;
            block52: {
                unquotedValue = value;
                if (unquotedValue.startsWith("\"") && unquotedValue.endsWith("\"")) {
                    unquotedValue = unquotedValue.substring(1, unquotedValue.length() - 1);
                }
                condition = Condition.EQUAL;
                if (matchCondition != null && (condition = Condition.fromString(matchCondition)) == null) {
                    this.logger.warn("matchStateToValue: unknown match condition '{}'", (Object)matchCondition);
                    return false;
                }
                matched = false;
                if (!UnDefType.NULL.toString().equals(unquotedValue) && !UnDefType.UNDEF.toString().equals(unquotedValue)) break block52;
                switch (condition) {
                    case EQUAL: {
                        if (unquotedValue.equals(state.toString())) {
                            matched = true;
                            break;
                        }
                        break block51;
                    }
                    case NOTEQUAL: 
                    case NOT: {
                        if (!unquotedValue.equals(state.toString())) {
                            matched = true;
                            break;
                        }
                        break block51;
                    }
                }
                break block51;
            }
            if (state instanceof DecimalType || state instanceof QuantityType) {
                try {
                    double stateDoubleValue;
                    double compareDoubleValue = Double.parseDouble(unquotedValue);
                    if (state instanceof DecimalType) {
                        DecimalType type = (DecimalType)state;
                        stateDoubleValue = type.doubleValue();
                    } else {
                        stateDoubleValue = ((QuantityType)state).doubleValue();
                    }
                    switch (condition) {
                        case EQUAL: {
                            if (stateDoubleValue == compareDoubleValue) {
                                matched = true;
                            }
                            break;
                        }
                        case LTE: {
                            if (stateDoubleValue <= compareDoubleValue) {
                                matched = true;
                            }
                            break;
                        }
                        case GTE: {
                            if (stateDoubleValue >= compareDoubleValue) {
                                matched = true;
                            }
                            break;
                        }
                        case GREATER: {
                            if (stateDoubleValue > compareDoubleValue) {
                                matched = true;
                            }
                            break;
                        }
                        case LESS: {
                            if (stateDoubleValue < compareDoubleValue) {
                                matched = true;
                            }
                            break;
                        }
                        case NOTEQUAL: 
                        case NOT: {
                            if (stateDoubleValue == compareDoubleValue) break;
                            matched = true;
                        }
                        default: {
                            break;
                        }
                    }
                }
                catch (NumberFormatException e) {
                    this.logger.debug("matchStateToValue: Decimal format exception: ", (Throwable)e);
                }
            } else if (state instanceof DateTimeType) {
                DateTimeType dateTimeState = (DateTimeType)state;
                Instant val = dateTimeState.getInstant();
                Instant now = Instant.now();
                long secsDif = ChronoUnit.SECONDS.between(val, now);
                try {
                    switch (condition) {
                        case EQUAL: {
                            if (secsDif == (long)Integer.parseInt(unquotedValue)) {
                                matched = true;
                            }
                            break;
                        }
                        case LTE: {
                            if (secsDif <= (long)Integer.parseInt(unquotedValue)) {
                                matched = true;
                            }
                            break;
                        }
                        case GTE: {
                            if (secsDif >= (long)Integer.parseInt(unquotedValue)) {
                                matched = true;
                            }
                            break;
                        }
                        case GREATER: {
                            if (secsDif > (long)Integer.parseInt(unquotedValue)) {
                                matched = true;
                            }
                            break;
                        }
                        case LESS: {
                            if (secsDif < (long)Integer.parseInt(unquotedValue)) {
                                matched = true;
                            }
                            break;
                        }
                        case NOTEQUAL: 
                        case NOT: {
                            if (secsDif == (long)Integer.parseInt(unquotedValue)) break;
                            matched = true;
                        }
                        default: {
                            break;
                        }
                    }
                }
                catch (NumberFormatException e) {
                    this.logger.debug("matchStateToValue: Decimal format exception: ", (Throwable)e);
                }
            } else {
                switch (condition) {
                    case NOTEQUAL: 
                    case NOT: {
                        if (unquotedValue.equals(state.toString())) break;
                        matched = true;
                        break;
                    }
                    default: {
                        if (!unquotedValue.equals(state.toString())) break;
                        matched = true;
                    }
                }
            }
        }
        return matched;
    }

    private @Nullable String processColorDefinition(Widget w, @Nullable List<ColorArray> colorList, String colorType) {
        if (colorList == null || colorList.isEmpty()) {
            return null;
        }
        this.logger.debug("Checking {} color for widget '{}'.", (Object)colorType, (Object)w.getLabel());
        String colorString = null;
        for (ColorArray rule : colorList) {
            if (!this.allConditionsOk((List<org.openhab.core.model.sitemap.sitemap.Condition>)rule.getConditions(), w)) continue;
            colorString = rule.getArg();
            break;
        }
        if (colorString == null) {
            this.logger.debug("No {} color found for widget '{}'.", (Object)colorType, (Object)w.getLabel());
            return null;
        }
        if (colorString.startsWith("\"") && colorString.endsWith("\"")) {
            colorString = colorString.substring(1, colorString.length() - 1);
        }
        this.logger.debug("{} color for widget '{}' is '{}'.", new Object[]{colorType, w.getLabel(), colorString});
        return colorString;
    }

    @Override
    public @Nullable String getLabelColor(Widget w) {
        return this.processColorDefinition(w, (List<ColorArray>)w.getLabelColor(), "label");
    }

    @Override
    public @Nullable String getValueColor(Widget w) {
        return this.processColorDefinition(w, (List<ColorArray>)w.getValueColor(), "value");
    }

    @Override
    public @Nullable String getIconColor(Widget w) {
        return this.processColorDefinition(w, (List<ColorArray>)w.getIconColor(), "icon");
    }

    @Override
    public boolean getVisiblity(Widget w) {
        EList ruleList = w.getVisibility();
        if (ruleList == null || ruleList.isEmpty()) {
            return true;
        }
        this.logger.debug("Checking visiblity for widget '{}'.", (Object)w.getLabel());
        for (VisibilityRule rule : ruleList) {
            if (!this.allConditionsOk((List<org.openhab.core.model.sitemap.sitemap.Condition>)rule.getConditions(), w)) continue;
            return true;
        }
        this.logger.debug("Widget {} is not visible.", (Object)w.getLabel());
        return false;
    }

    @Override
    public @Nullable String getConditionalIcon(Widget w) {
        EList ruleList = w.getIconRules();
        if (ruleList == null || ruleList.isEmpty()) {
            return null;
        }
        this.logger.debug("Checking icon for widget '{}'.", (Object)w.getLabel());
        String icon = null;
        for (IconRule rule : ruleList) {
            if (!this.allConditionsOk((List<org.openhab.core.model.sitemap.sitemap.Condition>)rule.getConditions(), w)) continue;
            icon = rule.getArg();
            break;
        }
        if (icon == null) {
            this.logger.debug("No icon found for widget '{}'.", (Object)w.getLabel());
            return null;
        }
        if (icon.startsWith("\"") && icon.endsWith("\"")) {
            icon = icon.substring(1, icon.length() - 1);
        }
        this.logger.debug("icon for widget '{}' is '{}'.", (Object)w.getLabel(), (Object)icon);
        return icon;
    }

    private boolean allConditionsOk(@Nullable List<org.openhab.core.model.sitemap.sitemap.Condition> conditions, Widget w) {
        boolean allConditionsOk = true;
        if (conditions != null) {
            State defaultState = this.getState(w);
            for (org.openhab.core.model.sitemap.sitemap.Condition condition : conditions) {
                State state = defaultState;
                String itemName = condition.getItem();
                if (itemName != null) {
                    try {
                        Item item = this.itemRegistry.getItem(itemName);
                        state = item.getState();
                    }
                    catch (ItemNotFoundException e) {
                        this.logger.warn("Cannot retrieve item {} for widget {}", (Object)itemName, (Object)w.eClass().getInstanceTypeName());
                    }
                }
                Object value = condition.getSign() != null ? condition.getSign() + condition.getState() : condition.getState();
                if (state != null && this.matchStateToValue(state, (String)value, condition.getCondition())) continue;
                allConditionsOk = false;
                break;
            }
        }
        return allConditionsOk;
    }

    public Collection<Item> getItemsByTag(String ... tags) {
        return this.itemRegistry.getItemsByTag(tags);
    }

    public Collection<Item> getItemsByTagAndType(String type, String ... tags) {
        return this.itemRegistry.getItemsByTagAndType(type, tags);
    }

    public <T extends Item> Collection<T> getItemsByTag(Class<T> typeFilter, String ... tags) {
        return this.itemRegistry.getItemsByTag(typeFilter, tags);
    }

    public Item add(Item element) {
        return (Item)this.itemRegistry.add((Identifiable)element);
    }

    public @Nullable Item update(Item element) {
        return (Item)this.itemRegistry.update((Identifiable)element);
    }

    public @Nullable Item remove(String key) {
        return (Item)this.itemRegistry.remove((Object)key);
    }

    public @Nullable Item get(String key) {
        return (Item)this.itemRegistry.get((Object)key);
    }

    public @Nullable Item remove(String itemName, boolean recursive) {
        return this.itemRegistry.remove(itemName, recursive);
    }

    @Override
    public @Nullable String getUnitForWidget(Widget w) {
        String itemName = w.getItem();
        if (itemName != null) {
            try {
                NumberItem numberItem;
                Item item = this.getItem(itemName);
                if (item instanceof NumberItem && (numberItem = (NumberItem)item).getDimension() != null) {
                    String pattern = this.getFormatPattern(w);
                    if (pattern == null || pattern.isBlank()) {
                        return numberItem.getUnitSymbol();
                    }
                    String unit = this.getUnitFromPattern(pattern);
                    if (!"%unit%".equals(unit)) {
                        return unit;
                    }
                    return numberItem.getUnitSymbol();
                }
            }
            catch (ItemNotFoundException e) {
                this.logger.warn("Failed to retrieve item during widget rendering, item does not exist: {}", (Object)e.getMessage());
            }
        }
        return "";
    }

    @Override
    public @Nullable State convertStateToLabelUnit(QuantityType<?> state, String label) {
        String labelUnit;
        int index = label.lastIndexOf(" ");
        String string = labelUnit = index > 0 ? label.substring(index) : null;
        if (labelUnit != null && !state.getUnit().toString().equals(labelUnit)) {
            return state.toInvertibleUnit(labelUnit);
        }
        return state;
    }

    private @Nullable String getUnitFromPattern(@Nullable String format) {
        if (format == null || format.isBlank()) {
            return null;
        }
        int index = format.lastIndexOf(" ");
        String unit = index > 0 ? format.substring(index + 1) : null;
        unit = "%%".equals(unit) ? "%" : unit;
        return unit;
    }

    static enum Condition {
        EQUAL("=="),
        GTE(">="),
        LTE("<="),
        NOTEQUAL("!="),
        GREATER(">"),
        LESS("<"),
        NOT("!");

        private final String value;

        private Condition(String value) {
            this.value = value;
        }

        public static @Nullable Condition fromString(String text) {
            Condition[] conditionArray = Condition.values();
            int n = conditionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Condition c = conditionArray[n2];
                if (text.equalsIgnoreCase(c.value)) {
                    return c;
                }
                ++n2;
            }
            return null;
        }

        public String toString() {
            return this.value;
        }
    }

    private static class WidgetLabelWithSource {
        public final String label;
        public final ItemUIRegistry.WidgetLabelSource source;

        public WidgetLabelWithSource(String l, ItemUIRegistry.WidgetLabelSource s) {
            this.label = l;
            this.source = s;
        }
    }
}

