/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.openxr.XrSpace;
import org.lwjgl.openxr.XrVector3f;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrGeometryInstanceTransformFB
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int BASESPACE;
    public static final int TIME;
    public static final int POSE;
    public static final int SCALE;

    public XrGeometryInstanceTransformFB(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrGeometryInstanceTransformFB.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrGeometryInstanceTransformFB.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrGeometryInstanceTransformFB.nnext(this.address());
    }

    @NativeType(value="XrSpace")
    public long baseSpace() {
        return XrGeometryInstanceTransformFB.nbaseSpace(this.address());
    }

    @NativeType(value="XrTime")
    public long time() {
        return XrGeometryInstanceTransformFB.ntime(this.address());
    }

    public XrPosef pose() {
        return XrGeometryInstanceTransformFB.npose(this.address());
    }

    public XrVector3f scale() {
        return XrGeometryInstanceTransformFB.nscale(this.address());
    }

    public XrGeometryInstanceTransformFB type(@NativeType(value="XrStructureType") int value) {
        XrGeometryInstanceTransformFB.ntype(this.address(), value);
        return this;
    }

    public XrGeometryInstanceTransformFB type$Default() {
        return this.type(1000118005);
    }

    public XrGeometryInstanceTransformFB next(@NativeType(value="void const *") long value) {
        XrGeometryInstanceTransformFB.nnext(this.address(), value);
        return this;
    }

    public XrGeometryInstanceTransformFB baseSpace(XrSpace value) {
        XrGeometryInstanceTransformFB.nbaseSpace(this.address(), value);
        return this;
    }

    public XrGeometryInstanceTransformFB time(@NativeType(value="XrTime") long value) {
        XrGeometryInstanceTransformFB.ntime(this.address(), value);
        return this;
    }

    public XrGeometryInstanceTransformFB pose(XrPosef value) {
        XrGeometryInstanceTransformFB.npose(this.address(), value);
        return this;
    }

    public XrGeometryInstanceTransformFB pose(Consumer<XrPosef> consumer) {
        consumer.accept(this.pose());
        return this;
    }

    public XrGeometryInstanceTransformFB scale(XrVector3f value) {
        XrGeometryInstanceTransformFB.nscale(this.address(), value);
        return this;
    }

    public XrGeometryInstanceTransformFB scale(Consumer<XrVector3f> consumer) {
        consumer.accept(this.scale());
        return this;
    }

    public XrGeometryInstanceTransformFB set(int type, long next, XrSpace baseSpace, long time, XrPosef pose, XrVector3f scale) {
        this.type(type);
        this.next(next);
        this.baseSpace(baseSpace);
        this.time(time);
        this.pose(pose);
        this.scale(scale);
        return this;
    }

    public XrGeometryInstanceTransformFB set(XrGeometryInstanceTransformFB src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrGeometryInstanceTransformFB malloc() {
        return (XrGeometryInstanceTransformFB)XrGeometryInstanceTransformFB.wrap(XrGeometryInstanceTransformFB.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrGeometryInstanceTransformFB calloc() {
        return (XrGeometryInstanceTransformFB)XrGeometryInstanceTransformFB.wrap(XrGeometryInstanceTransformFB.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrGeometryInstanceTransformFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrGeometryInstanceTransformFB)XrGeometryInstanceTransformFB.wrap(XrGeometryInstanceTransformFB.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrGeometryInstanceTransformFB create(long address) {
        return (XrGeometryInstanceTransformFB)XrGeometryInstanceTransformFB.wrap(XrGeometryInstanceTransformFB.class, (long)address);
    }

    @Nullable
    public static XrGeometryInstanceTransformFB createSafe(long address) {
        return address == 0L ? null : (XrGeometryInstanceTransformFB)XrGeometryInstanceTransformFB.wrap(XrGeometryInstanceTransformFB.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrGeometryInstanceTransformFB.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrGeometryInstanceTransformFB.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrGeometryInstanceTransformFB.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrGeometryInstanceTransformFB.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrGeometryInstanceTransformFB.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrGeometryInstanceTransformFB.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrGeometryInstanceTransformFB.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrGeometryInstanceTransformFB malloc(MemoryStack stack) {
        return (XrGeometryInstanceTransformFB)XrGeometryInstanceTransformFB.wrap(XrGeometryInstanceTransformFB.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrGeometryInstanceTransformFB calloc(MemoryStack stack) {
        return (XrGeometryInstanceTransformFB)XrGeometryInstanceTransformFB.wrap(XrGeometryInstanceTransformFB.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrGeometryInstanceTransformFB.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrGeometryInstanceTransformFB.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static long nbaseSpace(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)BASESPACE));
    }

    public static long ntime(long struct) {
        return UNSAFE.getLong(null, struct + (long)TIME);
    }

    public static XrPosef npose(long struct) {
        return XrPosef.create(struct + (long)POSE);
    }

    public static XrVector3f nscale(long struct) {
        return XrVector3f.create(struct + (long)SCALE);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nbaseSpace(long struct, XrSpace value) {
        MemoryUtil.memPutAddress((long)(struct + (long)BASESPACE), (long)value.address());
    }

    public static void ntime(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)TIME, value);
    }

    public static void npose(long struct, XrPosef value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)POSE), (long)XrPosef.SIZEOF);
    }

    public static void nscale(long struct, XrVector3f value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)SCALE), (long)XrVector3f.SIZEOF);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)BASESPACE)));
    }

    static {
        Struct.Layout layout = XrGeometryInstanceTransformFB.__struct((Struct.Member[])new Struct.Member[]{XrGeometryInstanceTransformFB.__member((int)4), XrGeometryInstanceTransformFB.__member((int)POINTER_SIZE), XrGeometryInstanceTransformFB.__member((int)POINTER_SIZE), XrGeometryInstanceTransformFB.__member((int)8), XrGeometryInstanceTransformFB.__member((int)XrPosef.SIZEOF, (int)XrPosef.ALIGNOF), XrGeometryInstanceTransformFB.__member((int)XrVector3f.SIZEOF, (int)XrVector3f.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        BASESPACE = layout.offsetof(2);
        TIME = layout.offsetof(3);
        POSE = layout.offsetof(4);
        SCALE = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<XrGeometryInstanceTransformFB, Buffer>
    implements NativeResource {
        private static final XrGeometryInstanceTransformFB ELEMENT_FACTORY = XrGeometryInstanceTransformFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrGeometryInstanceTransformFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrGeometryInstanceTransformFB.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrGeometryInstanceTransformFB.nnext(this.address());
        }

        @NativeType(value="XrSpace")
        public long baseSpace() {
            return XrGeometryInstanceTransformFB.nbaseSpace(this.address());
        }

        @NativeType(value="XrTime")
        public long time() {
            return XrGeometryInstanceTransformFB.ntime(this.address());
        }

        public XrPosef pose() {
            return XrGeometryInstanceTransformFB.npose(this.address());
        }

        public XrVector3f scale() {
            return XrGeometryInstanceTransformFB.nscale(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrGeometryInstanceTransformFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000118005);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrGeometryInstanceTransformFB.nnext(this.address(), value);
            return this;
        }

        public Buffer baseSpace(XrSpace value) {
            XrGeometryInstanceTransformFB.nbaseSpace(this.address(), value);
            return this;
        }

        public Buffer time(@NativeType(value="XrTime") long value) {
            XrGeometryInstanceTransformFB.ntime(this.address(), value);
            return this;
        }

        public Buffer pose(XrPosef value) {
            XrGeometryInstanceTransformFB.npose(this.address(), value);
            return this;
        }

        public Buffer pose(Consumer<XrPosef> consumer) {
            consumer.accept(this.pose());
            return this;
        }

        public Buffer scale(XrVector3f value) {
            XrGeometryInstanceTransformFB.nscale(this.address(), value);
            return this;
        }

        public Buffer scale(Consumer<XrVector3f> consumer) {
            consumer.accept(this.scale());
            return this;
        }
    }
}

