/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.namednumber;

import java.util.HashMap;
import java.util.Map;
import org.pcap4j.packet.namednumber.NamedNumber;

public final class LlcNumber
extends NamedNumber<Byte, LlcNumber> {
    private static final long serialVersionUID = -8810011448282399402L;
    public static final LlcNumber NULL_LSAP = new LlcNumber((byte)0, "NULL LSAP");
    public static final LlcNumber LLC_SUBLAYER_MGT_INDIVIDUAL = new LlcNumber((byte)2, "LLC Sublayer Mgt (individual)");
    public static final LlcNumber LLC_SUBLAYER_MGT_GROUP = new LlcNumber((byte)3, "LLC Sublayer Mgt (group)");
    public static final LlcNumber SNA_PATH_CONTROL_INDIVIDUAL = new LlcNumber((byte)4, "SNA Path Control (individual)");
    public static final LlcNumber SNA_PATH_CONTROL_GROUP = new LlcNumber((byte)5, "SNA Path Control (group)");
    public static final LlcNumber DOD_IP = new LlcNumber((byte)6, "DOD IP");
    public static final LlcNumber PROWAY_LAN = new LlcNumber((byte)14, "ProWay-LAN");
    public static final LlcNumber EIA_RS_511 = new LlcNumber((byte)78, "EIA-RS 511");
    public static final LlcNumber ISI_IP = new LlcNumber((byte)94, "ISI IP");
    public static final LlcNumber PROWAY_LAN_IEC_955 = new LlcNumber((byte)-114, "ProWay-LAN (IEC 955)");
    public static final LlcNumber ARP = new LlcNumber((byte)-104, "ARP");
    public static final LlcNumber SNAP = new LlcNumber((byte)-86, "SNAP");
    public static final LlcNumber NETBIOS = new LlcNumber((byte)-16, "NetBIOS");
    public static final LlcNumber ISO_CLNS_IS_8473 = new LlcNumber((byte)-2, "ISO CLNS IS 8473");
    public static final LlcNumber GLOBAL_DSAP = new LlcNumber((byte)-1, "Global DSAP");
    private static final Map<Byte, LlcNumber> registry = new HashMap<Byte, LlcNumber>();

    public LlcNumber(Byte value2, String name) {
        super(value2, name);
    }

    public static LlcNumber getInstance(Byte value2) {
        if (registry.containsKey(value2)) {
            return registry.get(value2);
        }
        return new LlcNumber(value2, "unknown");
    }

    public static LlcNumber register(LlcNumber number) {
        return registry.put((Byte)number.value(), number);
    }

    @Override
    public int compareTo(LlcNumber o) {
        return ((Byte)this.value()).compareTo((Byte)o.value());
    }

    @Override
    public String valueAsString() {
        return String.valueOf((Byte)this.value() & 0xFF);
    }

    static {
        registry.put((Byte)NULL_LSAP.value(), NULL_LSAP);
        registry.put((Byte)LLC_SUBLAYER_MGT_INDIVIDUAL.value(), LLC_SUBLAYER_MGT_INDIVIDUAL);
        registry.put((Byte)LLC_SUBLAYER_MGT_GROUP.value(), LLC_SUBLAYER_MGT_GROUP);
        registry.put((Byte)SNA_PATH_CONTROL_INDIVIDUAL.value(), SNA_PATH_CONTROL_INDIVIDUAL);
        registry.put((Byte)SNA_PATH_CONTROL_GROUP.value(), SNA_PATH_CONTROL_GROUP);
        registry.put((Byte)DOD_IP.value(), DOD_IP);
        registry.put((Byte)PROWAY_LAN.value(), PROWAY_LAN);
        registry.put((Byte)EIA_RS_511.value(), EIA_RS_511);
        registry.put((Byte)ISI_IP.value(), ISI_IP);
        registry.put((Byte)PROWAY_LAN_IEC_955.value(), PROWAY_LAN_IEC_955);
        registry.put((Byte)ARP.value(), ARP);
        registry.put((Byte)SNAP.value(), SNAP);
        registry.put((Byte)NETBIOS.value(), NETBIOS);
        registry.put((Byte)ISO_CLNS_IS_8473.value(), ISO_CLNS_IS_8473);
        registry.put((Byte)GLOBAL_DSAP.value(), GLOBAL_DSAP);
    }
}

