/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.powerassert.diagram;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.constant.EvaluatedConstTracker;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.symbols.IrVariableSymbol;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitor;
import org.jetbrains.kotlin.powerassert.IrUtilsKt;
import org.jetbrains.kotlin.powerassert.diagram.ChainNode;
import org.jetbrains.kotlin.powerassert.diagram.ConstantNode;
import org.jetbrains.kotlin.powerassert.diagram.ElvisNode;
import org.jetbrains.kotlin.powerassert.diagram.ExpressionNode;
import org.jetbrains.kotlin.powerassert.diagram.ExpressionTreeKt;
import org.jetbrains.kotlin.powerassert.diagram.HiddenNode;
import org.jetbrains.kotlin.powerassert.diagram.Node;
import org.jetbrains.kotlin.powerassert.diagram.RootNode;
import org.jetbrains.kotlin.powerassert.diagram.SourceFile;
import org.jetbrains.kotlin.powerassert.diagram.WhenNode;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"buildTree", "Lorg/jetbrains/kotlin/powerassert/diagram/Node;", "constTracker", "Lorg/jetbrains/kotlin/constant/EvaluatedConstTracker;", "sourceFile", "Lorg/jetbrains/kotlin/powerassert/diagram/SourceFile;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "kotlin-power-assert-compiler-plugin.backend"})
@SourceDebugExtension(value={"SMAP\nExpressionTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExpressionTree.kt\norg/jetbrains/kotlin/powerassert/diagram/ExpressionTreeKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,309:1\n1#2:310\n*E\n"})
public final class ExpressionTreeKt {
    @Nullable
    public static final Node buildTree(@Nullable EvaluatedConstTracker constTracker, @NotNull SourceFile sourceFile, @NotNull IrExpression expression) {
        Node node;
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        RootNode tree = new RootNode();
        expression.accept((IrVisitor)new IrVisitor<Unit, Node>(constTracker, sourceFile){
            private final List<IrVariableSymbol> whenSubjects;
            final /* synthetic */ EvaluatedConstTracker $constTracker;
            final /* synthetic */ SourceFile $sourceFile;
            {
                this.$constTracker = $constTracker;
                this.$sourceFile = $sourceFile;
                this.whenSubjects = new ArrayList<E>();
            }

            private final boolean isWhenSubjectAccess(IrExpression $this$isWhenSubjectAccess) {
                return $this$isWhenSubjectAccess instanceof IrGetValue && CollectionsKt.contains((Iterable)this.whenSubjects, (Object)((IrGetValue)$this$isWhenSubjectAccess).getSymbol());
            }

            public void visitElement(IrElement element, Node data) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                element.acceptChildren((IrVisitor)this, (Object)data);
            }

            public void visitExpression(IrExpression expression, Node data) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                if (expression instanceof IrGetObjectValue) {
                    data.addChild(new HiddenNode(expression));
                } else if (expression instanceof IrFunctionExpression) {
                    data.addChild(new HiddenNode(expression));
                } else if (IrUtilsKt.isImplicitArgument(expression)) {
                    data.addChild(new HiddenNode(expression));
                } else if (this.isWhenSubjectAccess(expression)) {
                    data.addChild(new HiddenNode(expression));
                } else {
                    ChainNode chainNode = data instanceof ChainNode ? (ChainNode)data : null;
                    if (chainNode == null) {
                        ChainNode chainNode2;
                        ChainNode it = chainNode2 = new ChainNode();
                        boolean bl = false;
                        data.addChild(it);
                        chainNode = chainNode2;
                    }
                    ChainNode chainNode3 = chainNode;
                    expression.acceptChildren((IrVisitor)this, (Object)chainNode3);
                    chainNode3.addChild(new ExpressionNode(expression));
                }
            }

            public void visitContainerExpression(IrContainerExpression expression, Node data) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                IrStatementOrigin irStatementOrigin = expression.getOrigin();
                if (Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.Companion.getSAFE_CALL())) {
                    List statements = expression.getStatements();
                    if (!(statements.size() == 2)) {
                        boolean $i$a$-check-ExpressionTreeKt$buildTree$1$visitContainerExpression$62 = false;
                        String $i$a$-check-ExpressionTreeKt$buildTree$1$visitContainerExpression$62 = "Expected the safe call expression to consist of exactly two statements.\n" + DumpIrTreeKt.dump$default((IrElement)((IrElement)expression), null, (int)1, null);
                        throw new IllegalStateException($i$a$-check-ExpressionTreeKt$buildTree$1$visitContainerExpression$62.toString());
                    }
                    E e = statements.get(0);
                    IrVariable irVariable = e instanceof IrVariable ? (IrVariable)e : null;
                    if (irVariable == null) {
                        throw new IllegalStateException(("Expected the first statement of the safe call expression to be a variable.\n" + DumpIrTreeKt.dump$default((IrElement)((IrElement)expression), null, (int)1, null)).toString());
                    }
                    IrVariable variable = irVariable;
                    ChainNode chainNode = data instanceof ChainNode ? (ChainNode)data : null;
                    if (chainNode == null) {
                        ChainNode chainNode2;
                        ChainNode it = chainNode2 = new ChainNode();
                        boolean bl = false;
                        data.addChild(it);
                        chainNode = chainNode2;
                    }
                    ChainNode chainNode3 = chainNode;
                    variable.acceptChildren((IrVisitor)this, (Object)chainNode3);
                    chainNode3.addChild(new ExpressionNode((IrExpression)expression));
                } else if (Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.Companion.getELVIS())) {
                    WhenNode whenNode;
                    List statements = expression.getStatements();
                    if (!(statements.size() == 2)) {
                        boolean $i$a$-check-ExpressionTreeKt$buildTree$1$visitContainerExpression$72 = false;
                        String $i$a$-check-ExpressionTreeKt$buildTree$1$visitContainerExpression$72 = "Expected the elvis expression to consist of exactly two statements.\n" + DumpIrTreeKt.dump$default((IrElement)((IrElement)expression), null, (int)1, null);
                        throw new IllegalStateException($i$a$-check-ExpressionTreeKt$buildTree$1$visitContainerExpression$72.toString());
                    }
                    E e = statements.get(0);
                    IrVariable irVariable = e instanceof IrVariable ? (IrVariable)e : null;
                    if (irVariable == null) {
                        throw new IllegalStateException(("Expected the first statement of the elvis expression to be a variable.\n" + DumpIrTreeKt.dump$default((IrElement)((IrElement)expression), null, (int)1, null)).toString());
                    }
                    IrVariable variable = irVariable;
                    E e2 = statements.get(1);
                    IrWhen irWhen = e2 instanceof IrWhen ? (IrWhen)e2 : null;
                    if (irWhen == null) {
                        throw new IllegalStateException(("Expected the second statement of the elvis expression to be a when.\n" + DumpIrTreeKt.dump$default((IrElement)((IrElement)expression), null, (int)1, null)).toString());
                    }
                    IrWhen conditional = irWhen;
                    ChainNode chainNode = data instanceof ChainNode ? (ChainNode)data : null;
                    if (chainNode == null) {
                        ChainNode it;
                        ChainNode it2 = it = new ChainNode();
                        boolean bl = false;
                        data.addChild(it2);
                        chainNode = it;
                    }
                    ChainNode chainNode4 = chainNode;
                    variable.acceptChildren((IrVisitor)this, (Object)chainNode4);
                    ElvisNode elvisNode = new ElvisNode((IrExpression)expression, variable);
                    chainNode4.addChild(elvisNode);
                    List branches = conditional.getBranches();
                    if (!(branches.size() == 2)) {
                        boolean $i$a$-check-ExpressionTreeKt$buildTree$1$visitContainerExpression$82 = false;
                        String $i$a$-check-ExpressionTreeKt$buildTree$1$visitContainerExpression$82 = "Expected the when of the elvis expression to consist of exactly two branches.\n" + DumpIrTreeKt.dump$default((IrElement)((IrElement)expression), null, (int)1, null);
                        throw new IllegalStateException($i$a$-check-ExpressionTreeKt$buildTree$1$visitContainerExpression$82.toString());
                    }
                    IrBranch nullBranch = (IrBranch)branches.get(0);
                    IrBranch notNullBranch = (IrBranch)branches.get(1);
                    WhenNode it = whenNode = new WhenNode(conditional, null);
                    boolean bl = false;
                    elvisNode.addChild(it);
                    WhenNode whenNode2 = whenNode;
                    whenNode2.addChild(new ConstantNode(nullBranch.getCondition()));
                    nullBranch.getResult().accept((IrVisitor)this, (Object)whenNode2);
                    whenNode2.addChild(new ConstantNode(notNullBranch.getCondition()));
                    whenNode2.addChild(new ConstantNode(notNullBranch.getResult()));
                    if (!(whenNode2.getChildren().size() == 4)) {
                        boolean bl2 = false;
                        String string = "Expected the when of the elvis expression to consist of exactly two branches.\n" + DumpIrTreeKt.dump$default((IrElement)((IrElement)expression), null, (int)1, null);
                        throw new IllegalStateException(string.toString());
                    }
                } else if (Intrinsics.areEqual((Object)irStatementOrigin, (Object)IrStatementOrigin.Companion.getWHEN())) {
                    List statements = expression.getStatements();
                    if (!(statements.size() == 2)) {
                        boolean $i$a$-check-ExpressionTreeKt$buildTree$1$visitContainerExpression$92 = false;
                        String $i$a$-check-ExpressionTreeKt$buildTree$1$visitContainerExpression$92 = "Expected the when-with-subject expression to consist of exactly two statements.\n" + DumpIrTreeKt.dump$default((IrElement)((IrElement)expression), null, (int)1, null);
                        throw new IllegalStateException($i$a$-check-ExpressionTreeKt$buildTree$1$visitContainerExpression$92.toString());
                    }
                    Object chainNode4 = statements.get(0);
                    IrVariable irVariable = chainNode4 instanceof IrVariable ? (IrVariable)chainNode4 : null;
                    if (irVariable == null) {
                        throw new IllegalStateException(("Expected the first statement of the when-with-subject expression to be a variable.\n" + DumpIrTreeKt.dump$default((IrElement)((IrElement)expression), null, (int)1, null)).toString());
                    }
                    IrVariable variable = irVariable;
                    E e = statements.get(1);
                    IrWhen irWhen = e instanceof IrWhen ? (IrWhen)e : null;
                    if (irWhen == null) {
                        throw new IllegalStateException(("Expected the second statement of the when-with-subject expression to be a when.\n" + DumpIrTreeKt.dump$default((IrElement)((IrElement)expression), null, (int)1, null)).toString());
                    }
                    IrWhen conditional = irWhen;
                    ChainNode chainNode = data instanceof ChainNode ? (ChainNode)data : null;
                    if (chainNode == null) {
                        ChainNode chainNode5;
                        ChainNode it = chainNode5 = new ChainNode();
                        boolean bl = false;
                        data.addChild(it);
                        chainNode = chainNode5;
                    }
                    chainNode4 = chainNode;
                    variable.acceptChildren((IrVisitor)this, chainNode4);
                    this.processWhen(conditional, (Node)chainNode4, variable);
                } else {
                    data.addChild(new ExpressionNode((IrExpression)expression));
                }
            }

            public void visitTypeOperator(IrTypeOperatorCall expression, Node data) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                ChainNode chainNode = data instanceof ChainNode ? (ChainNode)data : null;
                if (chainNode == null) {
                    ChainNode chainNode2;
                    ChainNode it = chainNode2 = new ChainNode();
                    boolean bl = false;
                    data.addChild(it);
                    chainNode = chainNode2;
                }
                ChainNode chainNode3 = chainNode;
                expression.acceptChildren((IrVisitor)this, (Object)chainNode3);
                switch (buildTree.WhenMappings.$EnumSwitchMapping$0[expression.getOperator().ordinal()]) {
                    case 1: 
                    case 2: 
                    case 3: {
                        chainNode3.addChild(new ExpressionNode((IrExpression)expression));
                        break;
                    }
                    default: {
                        chainNode3.addChild(new HiddenNode((IrExpression)expression));
                    }
                }
            }

            /*
             * Enabled aggressive block sorting
             */
            public void visitCall(IrCall expression, Node data) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                if (IrUtilsKt.isInnerOfNotEqualOperator(expression)) {
                    expression.acceptChildren((IrVisitor)this, (Object)data);
                    return;
                }
                if (IrUtilsKt.isInnerOfComparisonOperator(expression)) {
                    expression.acceptChildren((IrVisitor)this, (Object)data);
                    return;
                }
                if (Intrinsics.areEqual((Object)expression.getOrigin(), (Object)IrStatementOrigin.Companion.getNOT_IN())) {
                    ChainNode chainNode = data instanceof ChainNode ? (ChainNode)data : null;
                    if (chainNode == null) {
                        ChainNode chainNode2;
                        ChainNode it = chainNode2 = new ChainNode();
                        boolean bl = false;
                        data.addChild(it);
                        chainNode = chainNode2;
                    }
                    ChainNode chainNode3 = chainNode;
                    IrExpression irExpression = expression.getDispatchReceiver();
                    Intrinsics.checkNotNull((Object)irExpression);
                    irExpression.acceptChildren((IrVisitor)this, (Object)chainNode3);
                    chainNode3.addChild(new ExpressionNode((IrExpression)expression));
                    return;
                }
                if (Intrinsics.areEqual((Object)expression.getOrigin(), (Object)IrStatementOrigin.Companion.getEXCLEXCL())) {
                    expression.acceptChildren((IrVisitor)this, (Object)data);
                    return;
                }
                if (IrUtilsKt.isEqualOperator(expression)) {
                    IrExpression irExpression = (IrExpression)CollectionsKt.getOrNull((List)((List)expression.getArguments()), (int)0);
                    boolean bl = irExpression != null ? this.isWhenSubjectAccess(irExpression) : false;
                    if (bl) {
                        ChainNode chainNode = data instanceof ChainNode ? (ChainNode)data : null;
                        if (chainNode == null) {
                            ChainNode chainNode4;
                            ChainNode it = chainNode4 = new ChainNode();
                            boolean bl2 = false;
                            data.addChild(it);
                            chainNode = chainNode4;
                        }
                        ChainNode chainNode5 = chainNode;
                        expression.acceptChildren((IrVisitor)this, (Object)chainNode5);
                        chainNode5.addChild(new HiddenNode((IrExpression)expression));
                        return;
                    }
                }
                super.visitCall(expression, (Object)data);
            }

            public void visitVararg(IrVararg expression, Node data) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                expression.acceptChildren((IrVisitor)this, (Object)data);
            }

            public void visitConst(IrConst expression, Node data) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                if (ExpressionTreeKt.access$buildTree$isEvaluatedConst(expression, this.$constTracker, this.$sourceFile)) {
                    ChainNode chainNode = data instanceof ChainNode ? (ChainNode)data : null;
                    if (chainNode == null) {
                        ChainNode chainNode2;
                        ChainNode it = chainNode2 = new ChainNode();
                        boolean bl = false;
                        data.addChild(it);
                        chainNode = chainNode2;
                    }
                    ChainNode chainNode3 = chainNode;
                    chainNode3.addChild(new ExpressionNode((IrExpression)expression));
                } else {
                    data.addChild(new ConstantNode((IrExpression)expression));
                }
            }

            public void visitTry(IrTry aTry, Node data) {
                Intrinsics.checkNotNullParameter((Object)aTry, (String)"aTry");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                ChainNode chainNode = data instanceof ChainNode ? (ChainNode)data : null;
                if (chainNode == null) {
                    ChainNode chainNode2;
                    ChainNode it = chainNode2 = new ChainNode();
                    boolean bl = false;
                    data.addChild(it);
                    chainNode = chainNode2;
                }
                ChainNode chainNode3 = chainNode;
                chainNode3.addChild(new ExpressionNode((IrExpression)aTry));
            }

            public void visitWhen(IrWhen expression, Node data) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                buildTree.1.processWhen$default(this, expression, data, null, 4, null);
            }

            private final void processWhen(IrWhen expression, Node data, IrVariable subject) {
                WhenNode whenNode = new WhenNode(expression, subject);
                WhenNode it = whenNode;
                boolean bl = false;
                data.addChild(it);
                WhenNode whenNode2 = whenNode;
                if (subject != null) {
                    this.whenSubjects.add(subject.getSymbol());
                }
                for (IrBranch branch : expression.getBranches()) {
                    branch.getCondition().accept((IrVisitor)this, (Object)whenNode2);
                    branch.getResult().accept((IrVisitor)this, (Object)whenNode2);
                }
                if (subject != null) {
                    CollectionsKt.removeLast(this.whenSubjects);
                }
                if (!(whenNode2.getChildren().size() == 2 * expression.getBranches().size())) {
                    boolean bl2 = false;
                    String string = "Expected the when of the elvis expression to consist of exactly two branches.\n" + DumpIrTreeKt.dump$default((IrElement)((IrElement)expression), null, (int)1, null);
                    throw new IllegalStateException(string.toString());
                }
            }

            static /* synthetic */ void processWhen$default(buildTree.1 var0, IrWhen irWhen, Node node, IrVariable irVariable, int n, Object object) {
                if ((n & 4) != 0) {
                    irVariable = null;
                }
                var0.processWhen(irWhen, node, irVariable);
            }
        }, (Object)tree);
        Node node2 = (Node)CollectionsKt.singleOrNull(tree.getChildren());
        if (node2 != null) {
            Node node3;
            Node it = node3 = node2;
            boolean bl = false;
            node = !(it instanceof ConstantNode) ? node3 : null;
        } else {
            node = null;
        }
        return node;
    }

    private static final boolean buildTree$isEvaluatedConst(IrConst $this$buildTree_u24isEvaluatedConst, EvaluatedConstTracker $constTracker, SourceFile $sourceFile) {
        EvaluatedConstTracker evaluatedConstTracker = $constTracker;
        return (evaluatedConstTracker != null ? evaluatedConstTracker.load($this$buildTree_u24isEvaluatedConst.getStartOffset(), $this$buildTree_u24isEvaluatedConst.getEndOffset(), IrDeclarationsKt.getNameWithPackage((IrFile)$sourceFile.getIrFile())) : null) != null;
    }

    public static final /* synthetic */ boolean access$buildTree$isEvaluatedConst(IrConst $receiver, EvaluatedConstTracker $constTracker, SourceFile $sourceFile) {
        return ExpressionTreeKt.buildTree$isEvaluatedConst($receiver, $constTracker, $sourceFile);
    }
}

