/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.measure.UnitConverter;
import tech.units.indriya.function.Calculus;
import tech.units.indriya.function.PowersOfIntConverter;
import tech.units.indriya.function.UnitComparator;
import tech.units.indriya.internal.simplify.Simplifier;
import tech.units.indriya.unit.Prefix;

public abstract class AbstractConverter
implements UnitConverter,
Serializable,
Comparable<UnitConverter> {
    private static final long serialVersionUID = 5790242858468427131L;
    public static final AbstractConverter IDENTITY = new Identity();
    protected List<? extends UnitConverter> conversionSteps;

    protected AbstractConverter() {
    }

    public static UnitConverter of(Prefix prefix) {
        return PowersOfIntConverter.of(prefix);
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    protected abstract String transformationLiteral();

    public final String toString() {
        String converterName = this.getClass().getSimpleName();
        if (converterName.endsWith("Converter")) {
            converterName = converterName.substring(0, converterName.length() - "Converter".length());
        }
        if (this.isIdentity()) {
            return String.format("%s(IDENTITY)", converterName);
        }
        String transformationLiteral = this.transformationLiteral();
        if (transformationLiteral == null || transformationLiteral.length() == 0) {
            return String.format("%s", converterName);
        }
        return String.format("%s(%s)", converterName, transformationLiteral);
    }

    protected abstract AbstractConverter inverseWhenNotIdentity();

    public final AbstractConverter inverse() {
        if (this.isIdentity()) {
            return this;
        }
        return this.inverseWhenNotIdentity();
    }

    protected abstract boolean isSimpleCompositionWith(AbstractConverter var1);

    protected AbstractConverter simpleCompose(AbstractConverter that) {
        throw new IllegalStateException(String.format("Concrete UnitConverter '%s' does not implement simpleCompose(...).", this));
    }

    public final UnitConverter concatenate(UnitConverter converter) {
        Objects.requireNonNull(converter, "Can not concatenate null.");
        if (converter instanceof AbstractConverter) {
            AbstractConverter other = (AbstractConverter)converter;
            return Simplifier.compose(this, other, AbstractConverter::isSimpleCompositionWith, AbstractConverter::simpleCompose);
        }
        if (converter.isIdentity()) {
            return this;
        }
        if (this.isIdentity()) {
            return converter;
        }
        throw new IllegalArgumentException("Concatenate is currently only supported for sub-classes of AbstractConverter");
    }

    public final List<? extends UnitConverter> getConversionSteps() {
        if (this.conversionSteps != null) {
            return this.conversionSteps;
        }
        if (this instanceof Pair) {
            this.conversionSteps = ((Pair)this).createConversionSteps();
            return this.conversionSteps;
        }
        this.conversionSteps = Collections.singletonList(this);
        return this.conversionSteps;
    }

    protected abstract double convertWhenNotIdentity(double var1);

    protected Number convertWhenNotIdentity(BigInteger value, MathContext ctx) {
        return this.convertWhenNotIdentity(new BigDecimal(value), ctx);
    }

    protected abstract BigDecimal convertWhenNotIdentity(BigDecimal var1, MathContext var2);

    public final double convert(double value) {
        if (this.isIdentity()) {
            return value;
        }
        return this.convertWhenNotIdentity(value);
    }

    public final Number convert(Number value) {
        if (this.isIdentity()) {
            return value;
        }
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null");
        }
        if (value instanceof BigDecimal) {
            return this.convertWhenNotIdentity((BigDecimal)value, Calculus.MATH_CONTEXT);
        }
        if (value instanceof BigInteger) {
            return this.convertWhenNotIdentity((BigInteger)value, Calculus.MATH_CONTEXT);
        }
        return this.convertWhenNotIdentity(value.doubleValue());
    }

    public static final class Pair
    extends AbstractConverter
    implements Serializable {
        private static final long serialVersionUID = -123063827821728331L;
        private final UnitConverter left;
        private final UnitConverter right;

        public Pair(UnitConverter left, UnitConverter right) {
            if (left == null || right == null) {
                throw new IllegalArgumentException("Converters cannot be null");
            }
            this.left = left;
            this.right = right;
        }

        public boolean isLinear() {
            return this.left.isLinear() && this.right.isLinear();
        }

        public boolean isIdentity() {
            return false;
        }

        protected List<? extends UnitConverter> createConversionSteps() {
            List leftCompound = this.left.getConversionSteps();
            List rightCompound = this.right.getConversionSteps();
            ArrayList steps = new ArrayList(leftCompound.size() + rightCompound.size());
            steps.addAll(leftCompound);
            steps.addAll(rightCompound);
            return steps;
        }

        @Override
        public Pair inverseWhenNotIdentity() {
            return new Pair(this.right.inverse(), this.left.inverse());
        }

        @Override
        public double convertWhenNotIdentity(double value) {
            return this.left.convert(this.right.convert(value));
        }

        @Override
        public Number convertWhenNotIdentity(BigInteger value, MathContext ctx) {
            if (this.right instanceof AbstractConverter) {
                AbstractConverter _left = (AbstractConverter)this.left;
                AbstractConverter _right = (AbstractConverter)this.right;
                Number rightValue = _right.convertWhenNotIdentity(value, ctx);
                if (rightValue instanceof BigDecimal) {
                    return _left.convertWhenNotIdentity((BigDecimal)rightValue, ctx);
                }
                if (rightValue instanceof BigInteger) {
                    return _left.convertWhenNotIdentity((BigInteger)rightValue, ctx);
                }
                return _left.convertWhenNotIdentity(Calculus.toBigDecimal(rightValue), ctx);
            }
            return this.convertWhenNotIdentity(new BigDecimal(value), ctx);
        }

        @Override
        public BigDecimal convertWhenNotIdentity(BigDecimal value, MathContext ctx) {
            if (this.right instanceof AbstractConverter) {
                AbstractConverter _left = (AbstractConverter)this.left;
                AbstractConverter _right = (AbstractConverter)this.right;
                return _left.convertWhenNotIdentity(_right.convertWhenNotIdentity(value, ctx), ctx);
            }
            return Calculus.toBigDecimal(this.left.convert(this.right.convert((Number)value)));
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Pair) {
                Pair that = (Pair)obj;
                return Objects.equals(this.left, that.left) && Objects.equals(this.right, that.right);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.left, this.right);
        }

        public UnitConverter getLeft() {
            return this.left;
        }

        public UnitConverter getRight() {
            return this.right;
        }

        @Override
        public int compareTo(UnitConverter obj) {
            if (this == obj) {
                return 0;
            }
            if (obj instanceof Pair) {
                Pair that = (Pair)obj;
                UnitComparator c = new UnitComparator();
                return Objects.compare(this.left, that.left, c) + Objects.compare(this.right, that.right, c);
            }
            return -1;
        }

        @Override
        protected String transformationLiteral() {
            return String.format("%s", this.getConversionSteps().stream().map(Object::toString).collect(Collectors.joining(" \u25cb ")));
        }

        @Override
        protected boolean isSimpleCompositionWith(AbstractConverter that) {
            return false;
        }
    }

    private static final class Identity
    extends AbstractConverter {
        private static final long serialVersionUID = -4460463244427587361L;

        private Identity() {
        }

        public boolean isIdentity() {
            return true;
        }

        @Override
        public double convertWhenNotIdentity(double value) {
            throw new IllegalStateException("code was reached, that is expected unreachable");
        }

        @Override
        public Number convertWhenNotIdentity(BigInteger value, MathContext ctx) {
            throw new IllegalStateException("code was reached, that is expected unreachable");
        }

        @Override
        public BigDecimal convertWhenNotIdentity(BigDecimal value, MathContext ctx) {
            throw new IllegalStateException("code was reached, that is expected unreachable");
        }

        @Override
        public boolean equals(Object cvtr) {
            return cvtr instanceof Identity;
        }

        @Override
        public int hashCode() {
            return 0;
        }

        public boolean isLinear() {
            return true;
        }

        @Override
        public int compareTo(UnitConverter o) {
            if (o instanceof Identity) {
                return 0;
            }
            return -1;
        }

        @Override
        protected boolean isSimpleCompositionWith(AbstractConverter that) {
            throw new IllegalStateException("code was reached, that is expected unreachable");
        }

        @Override
        protected AbstractConverter simpleCompose(AbstractConverter that) {
            throw new IllegalStateException("code was reached, that is expected unreachable");
        }

        @Override
        protected AbstractConverter inverseWhenNotIdentity() {
            throw new IllegalStateException("code was reached, that is expected unreachable");
        }

        @Override
        protected String transformationLiteral() {
            return null;
        }
    }
}

