/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.welcome;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.UtilKt;
import java.time.Duration;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.IntPredicate;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\"\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u0001:\u0005\u0012\u0013\u0014\u0015\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\n\u0018\u00010\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\f2\u0006\u0010\r\u001a\u00020\u0007J'\u0010\u000e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/profiler/ultimate/welcome/CpuLoadHelper;", "", "<init>", "()V", "prev", "Lcom/intellij/profiler/ultimate/welcome/CpuLoadHelper$Output;", "availableProcessors", "", "run", "", "", "processIds", "", "timeoutInMilliseconds", "calculateCpuLoad", "pid", "next", "(ILcom/intellij/profiler/ultimate/welcome/CpuLoadHelper$Output;Lcom/intellij/profiler/ultimate/welcome/CpuLoadHelper$Output;)Ljava/lang/Double;", "Output", "IntLongPair", "OsDependentBatchCommand", "MacBatchCommand", "JavaBatchCommand", "intellij.profiler.ultimate"})
@SourceDebugExtension(value={"SMAP\nCpuLoadHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CpuLoadHelper.kt\ncom/intellij/profiler/ultimate/welcome/CpuLoadHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,105:1\n1285#2,2:106\n1299#2,4:108\n1#3:112\n*S KotlinDebug\n*F\n+ 1 CpuLoadHelper.kt\ncom/intellij/profiler/ultimate/welcome/CpuLoadHelper\n*L\n33#1:106,2\n33#1:108,4\n*E\n"})
public final class CpuLoadHelper {
    @NotNull
    private Output prev = new Output(CollectionsKt.emptyList(), -1L);
    private final int availableProcessors = Runtime.getRuntime().availableProcessors();

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Map<Integer, Double> run(@NotNull Set<Integer> processIds, int timeoutInMilliseconds) throws ExecutionException {
        Map map;
        Intrinsics.checkNotNullParameter(processIds, (String)"processIds");
        OsDependentBatchCommand command = SystemInfo.isMac ? (OsDependentBatchCommand)MacBatchCommand.INSTANCE : (OsDependentBatchCommand)JavaBatchCommand.INSTANCE;
        Output output = new Output(command.run(timeoutInMilliseconds, p0$element -> processIds.contains(p0$element)), System.currentTimeMillis());
        if (this.prev.getTimestamp() >= 0L) {
            Iterable $this$associateWith$iv = processIds;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                void it;
                int n = ((Number)element$iv$iv).intValue();
                Object t = element$iv$iv;
                Map map2 = result$iv;
                boolean bl = false;
                Double d = this.calculateCpuLoad((int)it, this.prev, output);
                Double d2 = d != null ? Double.valueOf(d / (double)this.availableProcessors) : null;
                map2.put(t, d2);
            }
            map = result$iv;
        } else {
            map = null;
        }
        Map result = map;
        this.prev = output;
        return result;
    }

    private final Double calculateCpuLoad(int pid, Output prev, Output next) {
        boolean bl;
        Long prevCpuTime = prev.getCpuTime(pid);
        Long nextCpuTime = next.getCpuTime(pid);
        if (nextCpuTime == null) {
            return null;
        }
        Long l = prevCpuTime;
        long cpuTime = nextCpuTime - (l != null ? l : 0L);
        long wallTime = next.getTimestamp() - prev.getTimestamp();
        boolean bl2 = bl = wallTime > 0L;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-CpuLoadHelper$calculateCpuLoad$32 = false;
            String $i$a$-assert-CpuLoadHelper$calculateCpuLoad$32 = "timestamp is negative or 0 (actual vals is " + wallTime + ")";
            throw new AssertionError((Object)$i$a$-assert-CpuLoadHelper$calculateCpuLoad$32);
        }
        boolean bl3 = bl = cpuTime >= 0L;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "cpu time is negative " + cpuTime;
            throw new AssertionError((Object)string);
        }
        return (double)cpuTime / (double)wallTime;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/profiler/ultimate/welcome/CpuLoadHelper$IntLongPair;", "", "pid", "", "cpuTime", "", "<init>", "(IJ)V", "getPid", "()I", "getCpuTime", "()J", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.profiler.ultimate"})
    private static final class IntLongPair {
        private final int pid;
        private final long cpuTime;

        public IntLongPair(int pid, long cpuTime) {
            this.pid = pid;
            this.cpuTime = cpuTime;
        }

        public final int getPid() {
            return this.pid;
        }

        public final long getCpuTime() {
            return this.cpuTime;
        }

        public final int component1() {
            return this.pid;
        }

        public final long component2() {
            return this.cpuTime;
        }

        @NotNull
        public final IntLongPair copy(int pid, long cpuTime) {
            return new IntLongPair(pid, cpuTime);
        }

        public static /* synthetic */ IntLongPair copy$default(IntLongPair intLongPair, int n, long l, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = intLongPair.pid;
            }
            if ((n2 & 2) != 0) {
                l = intLongPair.cpuTime;
            }
            return intLongPair.copy(n, l);
        }

        @NotNull
        public String toString() {
            return "IntLongPair(pid=" + this.pid + ", cpuTime=" + this.cpuTime + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.pid);
            result = result * 31 + Long.hashCode(this.cpuTime);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof IntLongPair)) {
                return false;
            }
            IntLongPair intLongPair = (IntLongPair)other;
            if (this.pid != intLongPair.pid) {
                return false;
            }
            return this.cpuTime == intLongPair.cpuTime;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/profiler/ultimate/welcome/CpuLoadHelper$JavaBatchCommand;", "Lcom/intellij/profiler/ultimate/welcome/CpuLoadHelper$OsDependentBatchCommand;", "<init>", "()V", "run", "", "Lcom/intellij/profiler/ultimate/welcome/CpuLoadHelper$IntLongPair;", "timeoutInMilliseconds", "", "filter", "Ljava/util/function/IntPredicate;", "intellij.profiler.ultimate"})
    private static final class JavaBatchCommand
    implements OsDependentBatchCommand {
        @NotNull
        public static final JavaBatchCommand INSTANCE = new JavaBatchCommand();

        private JavaBatchCommand() {
        }

        @Override
        @NotNull
        public List<IntLongPair> run(int timeoutInMilliseconds, @NotNull IntPredicate filter) {
            Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
            List<Object> list = ProcessHandle.allProcesses().filter(arg_0 -> JavaBatchCommand.run$lambda$1(arg_0 -> JavaBatchCommand.run$lambda$0(filter, arg_0), arg_0)).map(arg_0 -> JavaBatchCommand.run$lambda$3(JavaBatchCommand::run$lambda$2, arg_0)).filter(arg_0 -> JavaBatchCommand.run$lambda$5(JavaBatchCommand::run$lambda$4, arg_0)).toList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
            return list;
        }

        private static final boolean run$lambda$0(IntPredicate $filter, ProcessHandle it) {
            return $filter.test((int)it.pid());
        }

        private static final boolean run$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final IntLongPair run$lambda$2(ProcessHandle it) {
            Optional<Duration> optional = it.info().totalCpuDuration();
            Intrinsics.checkNotNullExpressionValue(optional, (String)"totalCpuDuration(...)");
            Duration duration = (Duration)UtilKt.orNull(optional);
            return duration != null ? new IntLongPair((int)it.pid(), duration.toMillis()) : null;
        }

        private static final IntLongPair run$lambda$3(Function1 $tmp0, Object p0) {
            return (IntLongPair)$tmp0.invoke(p0);
        }

        private static final boolean run$lambda$4(IntLongPair it) {
            return it != null;
        }

        private static final boolean run$lambda$5(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/profiler/ultimate/welcome/CpuLoadHelper$MacBatchCommand;", "Lcom/intellij/profiler/ultimate/welcome/CpuLoadHelper$OsDependentBatchCommand;", "<init>", "()V", "run", "", "Lcom/intellij/profiler/ultimate/welcome/CpuLoadHelper$IntLongPair;", "timeoutInMilliseconds", "", "filter", "Ljava/util/function/IntPredicate;", "intellij.profiler.ultimate"})
    private static final class MacBatchCommand
    implements OsDependentBatchCommand {
        @NotNull
        public static final MacBatchCommand INSTANCE = new MacBatchCommand();

        private MacBatchCommand() {
        }

        @Override
        @NotNull
        public List<IntLongPair> run(int timeoutInMilliseconds, @NotNull IntPredicate filter) {
            Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
            String[] stringArray = new String[]{"/bin/ps", "-a", "-x", "-o", "pid,cputime"};
            ProcessOutput output = ExecUtil.execAndGetOutput((GeneralCommandLine)new GeneralCommandLine(stringArray), (int)timeoutInMilliseconds);
            if (output.getExitCode() != 0) {
                return CollectionsKt.emptyList();
            }
            String string = output.getStdout();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStdout(...)");
            String stdout = string;
            String[] stringArray2 = StringUtil.splitByLinesDontTrim((String)stdout);
            Intrinsics.checkNotNullExpressionValue((Object)stringArray2, (String)"splitByLinesDontTrim(...)");
            String[] lines = stringArray2;
            String header = lines[0];
            Intrinsics.checkNotNull((Object)header);
            int pidEnd = StringsKt.indexOf$default((CharSequence)header, (String)"PID", (int)0, (boolean)false, (int)6, null) + 3;
            ArrayList<IntLongPair> data = new ArrayList<IntLongPair>(lines.length);
            Regex regex = new Regex("(\\d+):([0-5]\\d)\\.(\\d{2})");
            int n = lines.length;
            for (int i = 1; i < n; ++i) {
                String line = lines[i];
                Intrinsics.checkNotNull((Object)line);
                String string2 = line.substring(0, pidEnd);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                int pid = Integer.parseInt(((Object)StringsKt.trim((CharSequence)string2)).toString());
                if (!filter.test(pid)) continue;
                String string3 = line.substring(pidEnd);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                MatchResult result = regex.matchEntire((CharSequence)((Object)StringsKt.trim((CharSequence)string3)).toString());
                if (result == null || result.getGroupValues().size() != 4) continue;
                int minutesToSeconds = Integer.parseInt((String)result.getGroupValues().get(1)) * 60;
                int secondsToMilliseconds = (minutesToSeconds + Integer.parseInt((String)result.getGroupValues().get(2))) * 1000;
                data.add(new IntLongPair(pid, (long)secondsToMilliseconds + Long.parseLong((String)result.getGroupValues().get(3)) * (long)10));
            }
            return data;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\bb\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/intellij/profiler/ultimate/welcome/CpuLoadHelper$OsDependentBatchCommand;", "", "run", "", "Lcom/intellij/profiler/ultimate/welcome/CpuLoadHelper$IntLongPair;", "timeoutInMilliseconds", "", "filter", "Ljava/util/function/IntPredicate;", "intellij.profiler.ultimate"})
    private static interface OsDependentBatchCommand {
        @NotNull
        public List<IntLongPair> run(int var1, @NotNull IntPredicate var2);

        public static /* synthetic */ List run$default(OsDependentBatchCommand osDependentBatchCommand, int n, IntPredicate intPredicate, int n2, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: run");
            }
            if ((n2 & 2) != 0) {
                intPredicate = OsDependentBatchCommand::run$lambda$0;
            }
            return osDependentBatchCommand.run(n, intPredicate);
        }

        private static boolean run$lambda$0(int it) {
            return true;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u0013\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001a"}, d2={"Lcom/intellij/profiler/ultimate/welcome/CpuLoadHelper$Output;", "", "cpuTimeTable", "", "Lcom/intellij/profiler/ultimate/welcome/CpuLoadHelper$IntLongPair;", "timestamp", "", "<init>", "(Ljava/util/List;J)V", "getCpuTimeTable", "()Ljava/util/List;", "getTimestamp", "()J", "getCpuTime", "pid", "", "(I)Ljava/lang/Long;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.profiler.ultimate"})
    @SourceDebugExtension(value={"SMAP\nCpuLoadHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CpuLoadHelper.kt\ncom/intellij/profiler/ultimate/welcome/CpuLoadHelper$Output\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,105:1\n1#2:106\n*E\n"})
    private static final class Output {
        @NotNull
        private final List<IntLongPair> cpuTimeTable;
        private final long timestamp;

        public Output(@NotNull List<IntLongPair> cpuTimeTable, long timestamp) {
            Intrinsics.checkNotNullParameter(cpuTimeTable, (String)"cpuTimeTable");
            this.cpuTimeTable = cpuTimeTable;
            this.timestamp = timestamp;
        }

        @NotNull
        public final List<IntLongPair> getCpuTimeTable() {
            return this.cpuTimeTable;
        }

        public final long getTimestamp() {
            return this.timestamp;
        }

        @Nullable
        public final Long getCpuTime(int pid) {
            Object v0;
            block1: {
                Iterable iterable = this.cpuTimeTable;
                for (Object t : iterable) {
                    IntLongPair it = (IntLongPair)t;
                    boolean bl = false;
                    if (!(it.getPid() == pid)) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            IntLongPair intLongPair = v0;
            return intLongPair != null ? Long.valueOf(intLongPair.getCpuTime()) : null;
        }

        @NotNull
        public final List<IntLongPair> component1() {
            return this.cpuTimeTable;
        }

        public final long component2() {
            return this.timestamp;
        }

        @NotNull
        public final Output copy(@NotNull List<IntLongPair> cpuTimeTable, long timestamp) {
            Intrinsics.checkNotNullParameter(cpuTimeTable, (String)"cpuTimeTable");
            return new Output(cpuTimeTable, timestamp);
        }

        public static /* synthetic */ Output copy$default(Output output, List list, long l, int n, Object object) {
            if ((n & 1) != 0) {
                list = output.cpuTimeTable;
            }
            if ((n & 2) != 0) {
                l = output.timestamp;
            }
            return output.copy(list, l);
        }

        @NotNull
        public String toString() {
            return "Output(cpuTimeTable=" + this.cpuTimeTable + ", timestamp=" + this.timestamp + ")";
        }

        public int hashCode() {
            int result = ((Object)this.cpuTimeTable).hashCode();
            result = result * 31 + Long.hashCode(this.timestamp);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Output)) {
                return false;
            }
            Output output = (Output)other;
            if (!Intrinsics.areEqual(this.cpuTimeTable, output.cpuTimeTable)) {
                return false;
            }
            return this.timestamp == output.timestamp;
        }
    }
}

