/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.hprof.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.profiler.ui.ProfilerUIUtilsKt;
import com.intellij.profiler.ultimate.UltimateProfilerBundleKt;
import com.intellij.profiler.ultimate.hprof.api.MuiInstance;
import com.intellij.profiler.ultimate.hprof.api.MuiSnapshot;
import com.intellij.profiler.ultimate.hprof.api.MuiType;
import com.intellij.profiler.ultimate.hprof.api.visitors.MuiVisitor;
import com.intellij.profiler.ultimate.hprof.ui.RenderUtilsKt;
import com.intellij.profiler.ultimate.hprof.ui.TextFragment;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.panels.OpaquePanel;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.BaseTreeModel;
import com.intellij.ui.tree.ui.DefaultTreeUI;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.concurrency.InvokerSupplier;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import kotlin.collections.LongIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MergedPathPanel
extends OpaquePanel
implements Disposable {
    public MergedPathPanel(final MuiSnapshot<? extends MuiType, ? extends MuiInstance> snapshot, MuiType root, LongList objects) {
        super((LayoutManager)new BorderLayout());
        Tree tree2 = new Tree((TreeModel)new AsyncTreeModel((TreeModel)((Object)new MyTreeModel(snapshot, root, objects)), (Disposable)this));
        tree2.putClientProperty((Object)DefaultTreeUI.AUTO_EXPAND_ALLOWED, (Object)false);
        tree2.setCellRenderer((TreeCellRenderer)new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree2, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (tree2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (snapshot.isReady() && value instanceof MyNode) {
                    MyNode node = (MyNode)value;
                    RenderUtilsKt.createTextFragments(node.myType, snapshot).forEach(f -> this.append(f.getText(), f.getAttributes()));
                    TextFragment instances = MergedPathPanel.instancesText(node.getSize());
                    this.append(instances.getText(), instances.getAttributes());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/profiler/ultimate/hprof/ui/MergedPathPanel$1", "customizeCellRenderer"));
            }
        });
        JScrollPane pane = ScrollPaneFactory.createScrollPane((Component)tree2);
        pane.getViewport().setOpaque(false);
        pane.setBackground(ProfilerUIUtilsKt.BACKGROUND);
        pane.setBorder(BorderFactory.createEmptyBorder());
        this.add(pane);
    }

    public void dispose() {
        this.removeAll();
    }

    private static TextFragment instancesText(int number) {
        String text = UltimateProfilerBundleKt.profilerMessage("hprof.merged.instances", String.format("%,d", number), number);
        return new TextFragment(" " + text, SimpleTextAttributes.GRAYED_ATTRIBUTES);
    }

    private static class MyTreeModel
    extends BaseTreeModel<MyNode>
    implements InvokerSupplier,
    Disposable {
        private final MuiSnapshot<MuiType, MuiInstance> mySnapshot;
        private final MyNode myRoot;
        private final Invoker myInvoker;
        private final AtomicBoolean isDisposed = new AtomicBoolean();

        MyTreeModel(MuiSnapshot<? extends MuiType, ? extends MuiInstance> snapshot, MuiType root, LongList objects) {
            this.mySnapshot = snapshot;
            this.myRoot = new MyNode(root, objects);
            this.myInvoker = ApplicationManager.getApplication().isUnitTestMode() ? Invoker.forEventDispatchThread((Disposable)this) : Invoker.forBackgroundThreadWithoutReadAction((Disposable)this);
        }

        public List<MyNode> getChildren(Object parent) {
            MyNode node = (MyNode)parent;
            final HashMap histogram = new HashMap();
            this.mySnapshot.forEachInstanceDominator(new MyLongIterator(node.getObjects()), null, new MuiVisitor<MuiInstance>(){

                @Override
                public boolean accept(@Nullable MuiInstance dominator) {
                    if (isDisposed.get()) {
                        throw new ProcessCanceledException();
                    }
                    if (dominator != null) {
                        histogram.computeIfAbsent(dominator.getType(), type -> new MyNode((MuiType)type)).add(dominator.getId());
                    }
                    return true;
                }
            });
            node.setLoaded();
            ArrayList<MyNode> classes = new ArrayList<MyNode>();
            for (MuiType type2 : histogram.keySet()) {
                classes.add(new MyNode(type2, ((MyNode)histogram.get(type2)).getObjects()));
            }
            classes.sort(Comparator.comparingInt(type -> -1 * type.getSize()));
            return classes;
        }

        @NotNull
        public Invoker getInvoker() {
            Invoker invoker = this.myInvoker;
            if (invoker == null) {
                MyTreeModel.$$$reportNull$$$0(0);
            }
            return invoker;
        }

        public Object getRoot() {
            return this.myRoot;
        }

        public boolean isLeaf(Object object) {
            return false;
        }

        public void dispose() {
            this.isDisposed.set(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profiler/ultimate/hprof/ui/MergedPathPanel$MyTreeModel", "getInvoker"));
        }
    }

    private static final class MyLongIterator
    extends LongIterator {
        private final LongList elements;
        private int index = 0;

        private MyLongIterator(LongList instances) {
            this.elements = instances;
        }

        public long nextLong() {
            return this.elements.getLong(this.index++);
        }

        public boolean hasNext() {
            return this.index < this.elements.size();
        }
    }

    private static final class MyNode {
        private final MuiType myType;
        private final LongList myObjects;
        private int count;
        private boolean isLoaded;

        private MyNode(MuiType type) {
            this.myType = type;
            this.myObjects = new LongArrayList();
        }

        private MyNode(MuiType type, LongList instances) {
            this.myType = type;
            this.myObjects = instances;
            this.count = instances.size();
        }

        public MuiType getType() {
            return this.myType;
        }

        public LongList getObjects() {
            if (this.isLoaded) {
                throw new IllegalStateException("Node is already loaded and cleared");
            }
            return this.myObjects;
        }

        public int getSize() {
            return this.count;
        }

        public void setLoaded() {
            this.isLoaded = true;
            this.myObjects.clear();
        }

        public void add(long instance) {
            this.myObjects.add(instance);
            this.count = this.myObjects.size();
        }

        public String toString() {
            return this.myType.getName() + MergedPathPanel.instancesText(this.getSize()).getText();
        }
    }
}

