/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.extensions.jcef.mermaid;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.extensions.jcef.mermaid.MermaidPluginAdvertisementKt;
import org.intellij.plugins.markdown.injection.CodeFenceLanguageProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/intellij/plugins/markdown/extensions/jcef/mermaid/MermaidCodeFenceLanguageProvider;", "Lorg/intellij/plugins/markdown/injection/CodeFenceLanguageProvider;", "<init>", "()V", "getLanguageByInfoString", "Lcom/intellij/lang/Language;", "infoString", "", "getCompletionVariantsForInfoString", "", "Lcom/intellij/codeInsight/lookup/LookupElement;", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "Companion", "intellij.markdown"})
public final class MermaidCodeFenceLanguageProvider
implements CodeFenceLanguageProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String MERMAID = "mermaid";

    @Override
    @Nullable
    public Language getLanguageByInfoString(@NotNull String infoString) {
        Intrinsics.checkNotNullParameter((Object)infoString, (String)"infoString");
        if (MermaidPluginAdvertisementKt.isMermaidPluginInstalled()) {
            return null;
        }
        return Companion.isMermaidInfoString$intellij_markdown(infoString) ? Companion.obtainMermaidLanguage$intellij_markdown() : null;
    }

    @Override
    @NotNull
    public List<LookupElement> getCompletionVariantsForInfoString(@NotNull CompletionParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        if (MermaidPluginAdvertisementKt.isMermaidPluginInstalled()) {
            return CollectionsKt.emptyList();
        }
        Project project = parameters.getOriginalFile().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        Language language = Companion.obtainMermaidLanguage$intellij_markdown();
        LanguageFileType languageFileType = language.getAssociatedFileType();
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)MERMAID).withIcon(languageFileType != null ? languageFileType.getIcon() : null).withInsertHandler((arg_0, arg_1) -> MermaidCodeFenceLanguageProvider.getCompletionVariantsForInfoString$lambda$0(project2, arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder, (String)"withInsertHandler(...)");
        LookupElementBuilder lookupElement = lookupElementBuilder;
        return CollectionsKt.listOf((Object)lookupElement);
    }

    private static final void getCompletionVariantsForInfoString$lambda$0(Project $project, InsertionContext insertionContext, LookupElement lookupElement) {
        Intrinsics.checkNotNullParameter((Object)insertionContext, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)lookupElement, (String)"<unused var>");
        MermaidPluginAdvertisementKt.advertiseMermaidPlugin($project);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\tJ\r\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/intellij/plugins/markdown/extensions/jcef/mermaid/MermaidCodeFenceLanguageProvider$Companion;", "", "<init>", "()V", "MERMAID", "", "isMermaidInfoString", "", "infoString", "isMermaidInfoString$intellij_markdown", "obtainMermaidLanguage", "Lcom/intellij/lang/Language;", "obtainMermaidLanguage$intellij_markdown", "intellij.markdown"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isMermaidInfoString$intellij_markdown(@NotNull String infoString) {
            Intrinsics.checkNotNullParameter((Object)infoString, (String)"infoString");
            return Intrinsics.areEqual((Object)infoString, (Object)MermaidCodeFenceLanguageProvider.MERMAID);
        }

        @NotNull
        public final Language obtainMermaidLanguage$intellij_markdown() {
            Language existingLanguage = Language.findLanguageByID((String)"Mermaid");
            Language language = existingLanguage;
            if (language == null) {
                PlainTextLanguage plainTextLanguage = PlainTextLanguage.INSTANCE;
                Intrinsics.checkNotNullExpressionValue((Object)plainTextLanguage, (String)"INSTANCE");
                language = (Language)plainTextLanguage;
            }
            return language;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

