/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vcs.BranchRenameListener;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.util.containers.ContainerUtil;
import git4idea.branch.GitBranchOperation;
import git4idea.branch.GitBranchUiHandler;
import git4idea.branch.GitUpstreamBranches;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitCompoundResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitRenameBranchOperation
extends GitBranchOperation {
    @NonNls
    private static final String NO_UPSTREAM_PATTERN = "fatal:.*has no upstream information";
    @NotNull
    private final VcsNotifier myNotifier;
    @NotNull
    @NlsSafe
    private final String myCurrentName;
    @NotNull
    @NlsSafe
    private final String myNewName;
    @Nullable
    private final GitUpstreamBranches myUpstreamBranches;

    GitRenameBranchOperation(@NotNull Project project, @NotNull Git git, @NotNull GitBranchUiHandler uiHandler, @NotNull @NlsSafe String currentName, @NotNull @NlsSafe String newName, @NotNull List<? extends GitRepository> repositories, boolean unsetUpstream) {
        if (project == null) {
            GitRenameBranchOperation.$$$reportNull$$$0(0);
        }
        if (git == null) {
            GitRenameBranchOperation.$$$reportNull$$$0(1);
        }
        if (uiHandler == null) {
            GitRenameBranchOperation.$$$reportNull$$$0(2);
        }
        if (currentName == null) {
            GitRenameBranchOperation.$$$reportNull$$$0(3);
        }
        if (newName == null) {
            GitRenameBranchOperation.$$$reportNull$$$0(4);
        }
        if (repositories == null) {
            GitRenameBranchOperation.$$$reportNull$$$0(5);
        }
        super(project, git, uiHandler, repositories);
        this.myCurrentName = currentName;
        this.myNewName = newName;
        this.myNotifier = VcsNotifier.getInstance((Project)this.myProject);
        this.myUpstreamBranches = unsetUpstream ? new GitUpstreamBranches(repositories, this.myCurrentName, this.myGit) : null;
    }

    GitRenameBranchOperation(@NotNull Project project, @NotNull Git git, @NotNull GitBranchUiHandler uiHandler, @NotNull @NlsSafe String currentName, @NotNull @NlsSafe String newName, @NotNull List<? extends GitRepository> repositories) {
        if (project == null) {
            GitRenameBranchOperation.$$$reportNull$$$0(6);
        }
        if (git == null) {
            GitRenameBranchOperation.$$$reportNull$$$0(7);
        }
        if (uiHandler == null) {
            GitRenameBranchOperation.$$$reportNull$$$0(8);
        }
        if (currentName == null) {
            GitRenameBranchOperation.$$$reportNull$$$0(9);
        }
        if (newName == null) {
            GitRenameBranchOperation.$$$reportNull$$$0(10);
        }
        if (repositories == null) {
            GitRenameBranchOperation.$$$reportNull$$$0(11);
        }
        this(project, git, uiHandler, currentName, newName, repositories, false);
    }

    @Override
    protected void execute() {
        while (this.hasMoreRepositories()) {
            boolean canIgnoreError;
            GitCommandResult unsetUpstreamResult;
            GitRepository repository2 = this.next();
            GitCommandResult renameBranchResult = this.myGit.renameBranch(repository2, this.myCurrentName, this.myNewName, new GitLineHandlerListener[0]);
            if (!renameBranchResult.success()) {
                this.fatalError(GitBundle.message((String)"git.rename.branch.could.not.rename.from.to", (Object[])new Object[]{this.myCurrentName, this.myNewName}), renameBranchResult);
                return;
            }
            if (this.myUpstreamBranches != null && !(unsetUpstreamResult = this.myGit.unsetUpstream(repository2, this.myNewName)).success() && !(canIgnoreError = ContainerUtil.exists(unsetUpstreamResult.getErrorOutput(), line -> line.matches(NO_UPSTREAM_PATTERN)))) {
                this.fatalError(GitBundle.message((String)"git.rename.branch.could.not.unset.upstream", (Object[])new Object[]{this.myNewName}), unsetUpstreamResult);
                return;
            }
            repository2.update();
            this.notifyBranchNameChanged(repository2, this.myCurrentName, this.myNewName);
            this.markSuccessful(repository2);
        }
        this.notifySuccess();
    }

    @Override
    protected void rollback() {
        GitCompoundResult compoundResult = new GitCompoundResult(this.myProject);
        Collection<GitRepository> repositories = this.getSuccessfulRepositories();
        for (GitRepository repository2 : repositories) {
            GitCommandResult result2 = this.myGit.renameBranch(repository2, this.myNewName, this.myCurrentName, new GitLineHandlerListener[0]);
            if (result2.success()) {
                if (this.myUpstreamBranches != null) {
                    this.myUpstreamBranches.restoreUpstream(repository2);
                }
                repository2.update();
                this.notifyBranchNameChanged(repository2, this.myNewName, this.myCurrentName);
            }
            compoundResult.append(repository2, result2);
        }
        if (compoundResult.totalSuccess()) {
            this.myNotifier.notifySuccess("git.branch.rename.rollback.success", GitBundle.message((String)"git.rename.branch.rollback.successful", (Object[])new Object[0]), GitBundle.message((String)"git.rename.branch.renamed.back.to", (Object[])new Object[]{this.myCurrentName}));
        } else {
            this.myNotifier.notifyError("git.branch.rename.rollback.failed", GitBundle.message((String)"git.rename.branch.rollback.failed", (Object[])new Object[0]), compoundResult.getErrorOutputWithReposIndication(), true);
        }
    }

    protected final void notifyBranchNameChanged(@NotNull GitRepository repository2, @NotNull String oldName, @NotNull String newName) {
        if (repository2 == null) {
            GitRenameBranchOperation.$$$reportNull$$$0(12);
        }
        if (oldName == null) {
            GitRenameBranchOperation.$$$reportNull$$$0(13);
        }
        if (newName == null) {
            GitRenameBranchOperation.$$$reportNull$$$0(14);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            ((BranchRenameListener)this.myProject.getMessageBus().syncPublisher(BranchRenameListener.VCS_BRANCH_RENAMED)).branchNameChanged(repository2.getRoot(), oldName, newName);
        });
    }

    @Override
    @NotNull
    protected String getSuccessMessage() {
        String string = GitBundle.message((String)"git.rename.branch.was.renamed.to", (Object[])new Object[]{HtmlChunk.text((String)this.myCurrentName).code().bold(), HtmlChunk.text((String)this.myNewName).code().bold()});
        if (string == null) {
            GitRenameBranchOperation.$$$reportNull$$$0(15);
        }
        return string;
    }

    @Override
    @NotNull
    @Nls(capitalization=Nls.Capitalization.Sentence)
    protected String getRollbackProposal() {
        String string = new HtmlBuilder().append(GitBundle.message((String)"git.rename.branch.has.succeeded.for.the.following.repositories", (Object[])new Object[]{this.getSuccessfulRepositories().size()})).br().appendRaw(this.successfulRepositoriesJoined()).br().append(GitBundle.message((String)"git.rename.branch.you.may.rename.branch.back", (Object[])new Object[]{this.myCurrentName})).toString();
        if (string == null) {
            GitRenameBranchOperation.$$$reportNull$$$0(16);
        }
        return string;
    }

    @Override
    @NotNull
    @Nls
    protected String getOperationName() {
        String string = GitBundle.message((String)"rename.branch.operation.name", (Object[])new Object[0]);
        if (string == null) {
            GitRenameBranchOperation.$$$reportNull$$$0(17);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 15, 16, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiHandler";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentName";
                break;
            }
            case 4: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldName";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/branch/GitRenameBranchOperation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/branch/GitRenameBranchOperation";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuccessMessage";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getRollbackProposal";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperationName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "notifyBranchNameChanged";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 15, 16, 17 -> new IllegalStateException(string);
        };
    }
}

