/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.psi;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiManager;
import com.intellij.psi.compiled.ClassFileDecompilers;
import java.io.IOException;
import java.util.ArrayList;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiler.psi.KotlinDecompiledFileViewProvider;
import org.jetbrains.kotlin.analysis.decompiler.psi.KotlinMetadataDeserializerForDecompiler;
import org.jetbrains.kotlin.analysis.decompiler.psi.file.KtDecompiledFile;
import org.jetbrains.kotlin.analysis.decompiler.psi.text.BuildDecompiledTextKt;
import org.jetbrains.kotlin.analysis.decompiler.psi.text.DecompiledText;
import org.jetbrains.kotlin.analysis.decompiler.psi.text.IncompatibleAbiVersionKt;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.KotlinMetadataStubBuilder;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.renderer.DescriptorRendererOptions;
import org.jetbrains.kotlin.serialization.SerializerExtensionProtocol;
import org.jetbrains.kotlin.serialization.deserialization.FlexibleTypeDeserializer;
import org.jetbrains.kotlin.serialization.deserialization.NameResolverUtilKt;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0003BI\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H&J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010#\u001a\u00020\u0012H\u0016J \u0010$\u001a\u00020%2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\"H\u0016J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001f\u001a\u00020 J\u001e\u0010)\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001f\u001a\u00020 2\n\b\u0002\u0010*\u001a\u0004\u0018\u00010\u001eH\u0004J\u000e\u0010+\u001a\u00020,2\u0006\u0010\u001f\u001a\u00020\u001cR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u0012X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001b\u0010\u0015\u001a\u00020\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/psi/KotlinMetadataDecompiler;", "V", "Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "Lcom/intellij/psi/compiled/ClassFileDecompilers$Full;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "serializerProtocol", "Lkotlin/Function0;", "Lorg/jetbrains/kotlin/serialization/SerializerExtensionProtocol;", "flexibleTypeDeserializer", "Lorg/jetbrains/kotlin/serialization/deserialization/FlexibleTypeDeserializer;", "expectedBinaryVersion", "invalidBinaryVersion", "stubVersion", "", "<init>", "(Lcom/intellij/openapi/fileTypes/FileType;Lkotlin/jvm/functions/Function0;Lorg/jetbrains/kotlin/serialization/deserialization/FlexibleTypeDeserializer;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;I)V", "metadataStubBuilder", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder;", "getMetadataStubBuilder", "()Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder;", "renderer", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "getRenderer", "()Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "renderer$delegate", "Lkotlin/Lazy;", "readFile", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder$FileWithMetadata;", "bytes", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "accepts", "", "getStubBuilder", "createFileViewProvider", "Lcom/intellij/psi/FileViewProvider;", "manager", "Lcom/intellij/psi/PsiManager;", "physical", "readFileSafely", "content", "buildDecompiledText", "Lorg/jetbrains/kotlin/analysis/decompiler/psi/text/DecompiledText;", "decompiler-to-psi"})
public abstract class KotlinMetadataDecompiler<V extends BinaryVersion>
extends ClassFileDecompilers.Full {
    @NotNull
    private final FileType fileType;
    @NotNull
    private final Function0<SerializerExtensionProtocol> serializerProtocol;
    @NotNull
    private final FlexibleTypeDeserializer flexibleTypeDeserializer;
    @NotNull
    private final Function0<V> expectedBinaryVersion;
    @NotNull
    private final Function0<V> invalidBinaryVersion;
    @NotNull
    private final KotlinMetadataStubBuilder metadataStubBuilder;
    @NotNull
    private final Lazy renderer$delegate;

    public KotlinMetadataDecompiler(@NotNull FileType fileType, @NotNull Function0<? extends SerializerExtensionProtocol> serializerProtocol, @NotNull FlexibleTypeDeserializer flexibleTypeDeserializer, @NotNull Function0<? extends V> expectedBinaryVersion, @NotNull Function0<? extends V> invalidBinaryVersion, int stubVersion) {
        Intrinsics.checkNotNullParameter(fileType, "fileType");
        Intrinsics.checkNotNullParameter(serializerProtocol, "serializerProtocol");
        Intrinsics.checkNotNullParameter(flexibleTypeDeserializer, "flexibleTypeDeserializer");
        Intrinsics.checkNotNullParameter(expectedBinaryVersion, "expectedBinaryVersion");
        Intrinsics.checkNotNullParameter(invalidBinaryVersion, "invalidBinaryVersion");
        this.fileType = fileType;
        this.serializerProtocol = serializerProtocol;
        this.flexibleTypeDeserializer = flexibleTypeDeserializer;
        this.expectedBinaryVersion = expectedBinaryVersion;
        this.invalidBinaryVersion = invalidBinaryVersion;
        this.metadataStubBuilder = new KotlinMetadataStubBuilder(stubVersion, this.fileType, this.serializerProtocol, (Function2<? super VirtualFile, ? super byte[], ? extends KotlinMetadataStubBuilder.FileWithMetadata>)new Function2<VirtualFile, byte[], KotlinMetadataStubBuilder.FileWithMetadata>((Object)this){

            public final KotlinMetadataStubBuilder.FileWithMetadata invoke(VirtualFile p0, byte[] p1) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return ((KotlinMetadataDecompiler)this.receiver).readFileSafely(p0, p1);
            }
        });
        this.renderer$delegate = LazyKt.lazy(KotlinMetadataDecompiler::renderer_delegate$lambda$1);
    }

    @NotNull
    protected KotlinMetadataStubBuilder getMetadataStubBuilder() {
        return this.metadataStubBuilder;
    }

    private final DescriptorRenderer getRenderer() {
        Lazy lazy = this.renderer$delegate;
        return (DescriptorRenderer)lazy.getValue();
    }

    @Nullable
    public abstract KotlinMetadataStubBuilder.FileWithMetadata readFile(@NotNull byte[] var1, @NotNull VirtualFile var2);

    @Override
    public boolean accepts(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter(file2, "file");
        return Intrinsics.areEqual(file2.getExtension(), this.fileType.getDefaultExtension()) || Intrinsics.areEqual(file2.getFileType(), this.fileType);
    }

    @Override
    @NotNull
    public KotlinMetadataStubBuilder getStubBuilder() {
        return this.getMetadataStubBuilder();
    }

    @Override
    @NotNull
    public FileViewProvider createFileViewProvider(@NotNull VirtualFile file2, @NotNull PsiManager manager, boolean physical) {
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(manager, "manager");
        return new KotlinDecompiledFileViewProvider(manager, file2, physical, arg_0 -> KotlinMetadataDecompiler.createFileViewProvider$lambda$5(this, arg_0));
    }

    @Nullable
    public final KotlinMetadataStubBuilder.FileWithMetadata readFile(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter(file2, "file");
        return KotlinMetadataDecompiler.readFileSafely$default(this, file2, null, 2, null);
    }

    @Nullable
    protected final KotlinMetadataStubBuilder.FileWithMetadata readFileSafely(@NotNull VirtualFile file2, @Nullable byte[] content) {
        KotlinMetadataStubBuilder.FileWithMetadata fileWithMetadata;
        Intrinsics.checkNotNullParameter(file2, "file");
        if (!file2.isValid()) {
            return null;
        }
        try {
            byte[] byArray = content;
            if (content == null) {
                byte[] byArray2 = file2.contentsToByteArray(false);
                byArray = byArray2;
                Intrinsics.checkNotNullExpressionValue(byArray2, "contentsToByteArray(...)");
            }
            fileWithMetadata = this.readFile(byArray, file2);
        }
        catch (IOException e) {
            fileWithMetadata = null;
        }
        return fileWithMetadata;
    }

    public static /* synthetic */ KotlinMetadataStubBuilder.FileWithMetadata readFileSafely$default(KotlinMetadataDecompiler kotlinMetadataDecompiler, VirtualFile virtualFile, byte[] byArray, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: readFileSafely");
        }
        if ((n & 2) != 0) {
            byArray = null;
        }
        return kotlinMetadataDecompiler.readFileSafely(virtualFile, byArray);
    }

    @NotNull
    public final DecompiledText buildDecompiledText(@NotNull KotlinMetadataStubBuilder.FileWithMetadata file2) {
        DecompiledText decompiledText;
        Intrinsics.checkNotNullParameter(file2, "file");
        KotlinMetadataStubBuilder.FileWithMetadata fileWithMetadata = file2;
        if (fileWithMetadata instanceof KotlinMetadataStubBuilder.FileWithMetadata.Incompatible) {
            decompiledText = IncompatibleAbiVersionKt.createIncompatibleAbiVersionDecompiledText((BinaryVersion)this.expectedBinaryVersion.invoke(), ((KotlinMetadataStubBuilder.FileWithMetadata.Incompatible)file2).getVersion());
        } else if (fileWithMetadata instanceof KotlinMetadataStubBuilder.FileWithMetadata.Compatible) {
            FqName packageFqName = ((KotlinMetadataStubBuilder.FileWithMetadata.Compatible)file2).getPackageFqName();
            KotlinMetadataDeserializerForDecompiler resolver = new KotlinMetadataDeserializerForDecompiler(packageFqName, ((KotlinMetadataStubBuilder.FileWithMetadata.Compatible)file2).getProto(), ((KotlinMetadataStubBuilder.FileWithMetadata.Compatible)file2).getNameResolver(), ((KotlinMetadataStubBuilder.FileWithMetadata.Compatible)file2).getVersion(), this.serializerProtocol.invoke(), this.flexibleTypeDeserializer);
            ArrayList declarations2 = new ArrayList();
            declarations2.addAll(resolver.resolveDeclarationsInFacade(packageFqName));
            for (ProtoBuf.Class classProto2 : ((KotlinMetadataStubBuilder.FileWithMetadata.Compatible)file2).getClassesToDecompile()) {
                ClassId classId = NameResolverUtilKt.getClassId(((KotlinMetadataStubBuilder.FileWithMetadata.Compatible)file2).getNameResolver(), classProto2.getFqName());
                CollectionsKt.addIfNotNull(declarations2, resolver.resolveTopLevelClass(classId));
            }
            decompiledText = BuildDecompiledTextKt.buildDecompiledText(packageFqName, declarations2, this.getRenderer());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return decompiledText;
    }

    private static final Unit renderer_delegate$lambda$1$lambda$0(DescriptorRendererOptions $this$withOptions) {
        Intrinsics.checkNotNullParameter($this$withOptions, "$this$withOptions");
        BuildDecompiledTextKt.defaultDecompilerRendererOptions($this$withOptions);
        return Unit.INSTANCE;
    }

    private static final DescriptorRenderer renderer_delegate$lambda$1() {
        return DescriptorRenderer.Companion.withOptions(KotlinMetadataDecompiler::renderer_delegate$lambda$1$lambda$0);
    }

    private static final DecompiledText createFileViewProvider$lambda$5$lambda$4$lambda$3(VirtualFile $virtualFile, KotlinMetadataDecompiler this$0, KotlinMetadataStubBuilder.FileWithMetadata $fileWithMetadata, VirtualFile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        if (!Intrinsics.areEqual(it, $virtualFile)) {
            boolean bl = false;
            String string2 = "Unexpected file " + it + ", expected " + $virtualFile.getFileType();
            throw new IllegalStateException(string2.toString());
        }
        return this$0.buildDecompiledText($fileWithMetadata);
    }

    private static final KtDecompiledFile createFileViewProvider$lambda$5(KotlinMetadataDecompiler this$0, KotlinDecompiledFileViewProvider provider2) {
        KtDecompiledFile ktDecompiledFile;
        Intrinsics.checkNotNullParameter(provider2, "provider");
        VirtualFile virtualFile = provider2.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue(virtualFile, "getVirtualFile(...)");
        VirtualFile virtualFile2 = virtualFile;
        KotlinMetadataStubBuilder.FileWithMetadata fileWithMetadata = KotlinMetadataDecompiler.readFileSafely$default(this$0, virtualFile2, null, 2, null);
        if (fileWithMetadata != null) {
            KotlinMetadataStubBuilder.FileWithMetadata fileWithMetadata2 = fileWithMetadata;
            boolean bl = false;
            ktDecompiledFile = new KtDecompiledFile(provider2, arg_0 -> KotlinMetadataDecompiler.createFileViewProvider$lambda$5$lambda$4$lambda$3(virtualFile2, this$0, fileWithMetadata2, arg_0));
        } else {
            ktDecompiledFile = null;
        }
        return ktDecompiledFile;
    }
}

