/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.caches.resolve.ExtendedResolutionApiKt;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B?\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u001c\u0010\u0006\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0004H\u0004R \u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0006\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/AbstractResultUnusedChecker;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractKotlinInspection;", "expressionChecker", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "", "callChecker", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "<init>", "(Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function2;)V", "check", "expression", "kotlin.core"})
public abstract class AbstractResultUnusedChecker
extends AbstractKotlinInspection {
    @NotNull
    private final Function2<KtExpression, AbstractResultUnusedChecker, Boolean> expressionChecker;
    @NotNull
    private final Function2<ResolvedCall<?>, AbstractResultUnusedChecker, Boolean> callChecker;

    public AbstractResultUnusedChecker(@NotNull Function2<? super KtExpression, ? super AbstractResultUnusedChecker, Boolean> expressionChecker, @NotNull Function2<? super ResolvedCall<?>, ? super AbstractResultUnusedChecker, Boolean> callChecker) {
        Intrinsics.checkNotNullParameter(expressionChecker, (String)"expressionChecker");
        Intrinsics.checkNotNullParameter(callChecker, (String)"callChecker");
        this.expressionChecker = expressionChecker;
        this.callChecker = callChecker;
    }

    protected final boolean check(@NotNull KtExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        if (!((Boolean)this.expressionChecker.invoke((Object)expression, (Object)this)).booleanValue()) {
            return false;
        }
        PsiElement current = (PsiElement)expression;
        for (PsiElement parent2 = expression.getParent(); !(parent2 == null || parent2 instanceof KtBlockExpression || parent2 instanceof KtFunction || parent2 instanceof KtFile); parent2 = parent2.getParent()) {
            if (parent2 instanceof KtValueArgument || parent2 instanceof KtBinaryExpression || parent2 instanceof KtUnaryExpression) {
                return false;
            }
            if (parent2 instanceof KtQualifiedExpression && Intrinsics.areEqual((Object)((KtQualifiedExpression)parent2).getReceiverExpression(), (Object)current)) {
                return false;
            }
            current = parent2;
        }
        BindingContext context = ExtendedResolutionApiKt.safeAnalyzeNonSourceRootCode((KtElement)expression, BodyResolveMode.PARTIAL_WITH_CFA);
        if (Intrinsics.areEqual((Object)context, (Object)BindingContext.EMPTY) || BindingContextUtilsKt.isUsedAsExpression((KtElement)((KtElement)expression), (BindingContext)context)) {
            return false;
        }
        ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)expression), (BindingContext)context);
        if (resolvedCall == null) {
            return false;
        }
        ResolvedCall resolvedCall2 = resolvedCall;
        return (Boolean)this.callChecker.invoke((Object)resolvedCall2, (Object)this);
    }
}

