/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradleJava.configuration;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.projectStructure.ExternalCompilerVersionProvider;
import org.jetbrains.kotlin.idea.compiler.configuration.IdeKotlinVersion;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinJpsPluginSettings;
import org.jetbrains.kotlin.idea.facet.KotlinFacet;
import org.jetbrains.kotlin.idea.gradleJava.configuration.GradleProjectImportHandler;
import org.jetbrains.kotlin.idea.gradleJava.configuration.KotlinGradleSourceSetDataServiceKt;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001b\u0010\u0006\u001a\u0015\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00020\u00020\u0007\u00a2\u0006\u0002\b\tH\u0016J6\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000e0\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/gradleJava/configuration/KotlinGradleSourceSetDataService;", "Lcom/intellij/openapi/externalSystem/service/project/manage/AbstractProjectDataService;", "Lorg/jetbrains/plugins/gradle/model/data/GradleSourceSetData;", "Ljava/lang/Void;", "<init>", "()V", "getTargetDataKey", "Lcom/intellij/openapi/externalSystem/model/Key;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "postProcess", "", "toImport", "", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "projectData", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "project", "Lcom/intellij/openapi/project/Project;", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "kotlin.gradle.gradle-java"})
@SourceDebugExtension(value={"SMAP\nKotlinGradleSourceSetDataService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinGradleSourceSetDataService.kt\norg/jetbrains/kotlin/idea/gradleJava/configuration/KotlinGradleSourceSetDataService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,359:1\n1869#2,2:360\n*S KotlinDebug\n*F\n+ 1 KotlinGradleSourceSetDataService.kt\norg/jetbrains/kotlin/idea/gradleJava/configuration/KotlinGradleSourceSetDataService\n*L\n117#1:360,2\n*E\n"})
public final class KotlinGradleSourceSetDataService
extends AbstractProjectDataService<GradleSourceSetData, Void> {
    @NotNull
    public Key<GradleSourceSetData> getTargetDataKey() {
        Key key = GradleSourceSetData.KEY;
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"KEY");
        return key;
    }

    public void postProcess(@NotNull Collection<? extends DataNode<GradleSourceSetData>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        Intrinsics.checkNotNullParameter(toImport, (String)"toImport");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)modelsProvider, (String)"modelsProvider");
        IdeKotlinVersion maxCompilerVersion = null;
        for (DataNode<GradleSourceSetData> dataNode : toImport) {
            DataNode moduleNode;
            Module ideModule;
            Object object = dataNode.getData();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getData(...)");
            GradleSourceSetData sourceSetData = (GradleSourceSetData)object;
            if (modelsProvider.findIdeModule((ModuleData)sourceSetData) == null || ExternalSystemApiUtil.findParent(dataNode, (Key)ProjectKeys.MODULE) == null || KotlinGradleSourceSetDataServiceKt.configureFacetByGradleModule$default(ideModule, modelsProvider, moduleNode, dataNode, null, 16, null) == null) continue;
            IdeKotlinVersion currentModuleCompilerVersion = ExternalCompilerVersionProvider.INSTANCE.get(ideModule);
            if (currentModuleCompilerVersion != null) {
                IdeKotlinVersion ideKotlinVersion = maxCompilerVersion;
                if (ideKotlinVersion == null) {
                    ideKotlinVersion = currentModuleCompilerVersion;
                }
                maxCompilerVersion = (IdeKotlinVersion)ComparisonsKt.maxOf((Comparable)ideKotlinVersion, (Comparable)currentModuleCompilerVersion);
            }
            Iterable $this$forEach$iv = GradleProjectImportHandler.Companion.getInstances(project);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KotlinFacet kotlinFacet;
                GradleProjectImportHandler it = (GradleProjectImportHandler)element$iv;
                boolean bl = false;
                it.importBySourceSet(kotlinFacet, dataNode);
            }
        }
        if (maxCompilerVersion != null) {
            ProjectData projectData2 = projectData;
            KotlinJpsPluginSettings.Companion.importKotlinJpsVersionFromExternalBuildSystem(project, maxCompilerVersion.getRawVersion(), GradleProjectSettings.isDelegatedBuildEnabled((Project)project, (String)(projectData2 != null ? projectData2.getLinkedExternalProjectPath() : null)), "Gradle");
        }
    }
}

