/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.util.caching;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010'\n\u0002\b\b\b&\u0018\u0000 K*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u00020\u0004:\u0002JKB\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u001e\u001a\u00020\u001fH\u0004J\b\u0010 \u001a\u00020\u001fH\u0002J\b\u0010!\u001a\u00020\u001fH\u0004J3\u0010\"\u001a\u0002H#\"\u0004\b\u0002\u0010#2\u001e\u0010$\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0012\u0012\u0004\u0012\u0002H#0%H$\u00a2\u0006\u0002\u0010&J\b\u0010'\u001a\u00020\u001fH\u0016J\u0016\u0010(\u001a\u00028\u00012\u0006\u0010)\u001a\u00028\u0000H\u00a7\u0002\u00a2\u0006\u0002\u0010*J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00010,H\u0007J\u001c\u0010-\u001a\u00020\u001f2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0012H\u0004J\u0015\u0010.\u001a\u00020\u001f2\u0006\u0010)\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010/J)\u00100\u001a\u00020\u001f2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00122\u0006\u0010)\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u00101J\u001c\u00102\u001a\u00020\u001f2\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u000104H\u0004J\u0012\u00105\u001a\u00020\u001f2\b\b\u0002\u00106\u001a\u00020\bH\u0004J\u001c\u00107\u001a\u00020\u001f2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0012H\u0014J:\u00108\u001a\b\u0012\u0004\u0012\u00028\u00010,2\f\u00109\u001a\b\u0012\u0004\u0012\u00028\u00000,2\u001c\b\u0002\u0010:\u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\b\u0018\u00010;H\u0005J0\u0010<\u001a\b\u0012\u0004\u0012\u00028\u00010,2\f\u00109\u001a\b\u0012\u0004\u0012\u00028\u00000,2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0012H\u0014J4\u0010=\u001a\u00020\u001f2\f\u00109\u001a\b\u0012\u0004\u0012\u00028\u00000,2\u001c\b\u0002\u0010:\u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\b\u0018\u00010;H\u0005J@\u0010>\u001a\u00020\u001f2\u0018\u0010?\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\b0;2\u001c\b\u0002\u0010:\u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\b\u0018\u00010;H\u0005J8\u0010@\u001a\u00020\u001f2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00122\u001a\u0010:\u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\b\u0018\u00010;H\u0002J\u001c\u0010A\u001a\u00020\u001f2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0012H\u0014J0\u0010B\u001a\u00020\u001f2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00122\u0012\u0010C\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010DH\u0014J\b\u0010E\u001a\u00020\u001fH$J\u0015\u0010F\u001a\u00020\u001f2\u0006\u0010)\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010/J)\u0010G\u001a\u00020\u001f2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00122\u0006\u0010)\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u00101J\u0015\u0010H\u001a\u00020\u001f2\u0006\u0010I\u001a\u00028\u0001H\u0014\u00a2\u0006\u0002\u0010/R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0012X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0019\u0010\u0015\u001a\u00070\u0016\u00a2\u0006\u0002\b\u0017X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006L"}, d2={"Lorg/jetbrains/kotlin/idea/base/util/caching/FineGrainedEntityCache;", "Key", "", "Value", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "cleanOnLowMemory", "", "<init>", "(Lcom/intellij/openapi/project/Project;Z)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "invalidationStamp", "Lorg/jetbrains/kotlin/idea/base/util/caching/FineGrainedEntityCache$InvalidationStamp;", "lastInvalidatedTimestampMs", "Ljava/util/concurrent/atomic/AtomicLong;", "cache", "", "getCache", "()Ljava/util/Map;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "initialized", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getInitialized", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "initialize", "", "registerLowMemoryWatcher", "checkIsInitialized", "useCache", "T", "block", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "dispose", "get", "key", "(Ljava/lang/Object;)Ljava/lang/Object;", "values", "", "checkEntitiesIfRequired", "checkKeyAndDisposeIllegalEntry", "(Ljava/lang/Object;)V", "disposeIllegalEntry", "(Ljava/util/Map;Ljava/lang/Object;)V", "putAll", "map", "", "invalidate", "writeAccessRequired", "doInvalidate", "invalidateKeysAndGetOutdatedValues", "keys", "validityCondition", "Lkotlin/Function2;", "doInvalidateKeysAndGetOutdatedValues", "invalidateKeys", "invalidateEntries", "condition", "checkEntities", "additionalEntitiesCheck", "disposeEntry", "entry", "", "subscribe", "checkKeyValidity", "checkKeyConsistency", "checkValueValidity", "value", "InvalidationStamp", "Companion", "kotlin.base.util"})
@SourceDebugExtension(value={"SMAP\nFineGrainedEntityCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FineGrainedEntityCache.kt\norg/jetbrains/kotlin/idea/base/util/caching/FineGrainedEntityCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,404:1\n1#2:405\n*E\n"})
public abstract class FineGrainedEntityCache<Key, Value>
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    private final boolean cleanOnLowMemory;
    @NotNull
    private final InvalidationStamp invalidationStamp;
    @NotNull
    private final AtomicLong lastInvalidatedTimestampMs;
    @NotNull
    private final Logger logger;
    @NotNull
    private final AtomicBoolean initialized;
    @NotNull
    private static final Function2<Object, Object, Boolean> CHECK_ALL = FineGrainedEntityCache::CHECK_ALL$lambda$13;
    @NotNull
    private static final Lazy<Boolean> isValidityChecksEnabled$delegate = LazyKt.lazy(FineGrainedEntityCache::isValidityChecksEnabled_delegate$lambda$14);
    @NotNull
    private static final Lazy<Integer> invalidationThrottlingMs$delegate = LazyKt.lazy(FineGrainedEntityCache::invalidationThrottlingMs_delegate$lambda$15);

    public FineGrainedEntityCache(@NotNull Project project, boolean cleanOnLowMemory) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.cleanOnLowMemory = cleanOnLowMemory;
        this.invalidationStamp = new InvalidationStamp();
        this.lastInvalidatedTimestampMs = new AtomicLong(0L);
        Logger logger = Logger.getInstance(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.initialized = new AtomicBoolean(false);
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    protected abstract Map<Key, Value> getCache();

    @NotNull
    protected final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    protected final AtomicBoolean getInitialized() {
        return this.initialized;
    }

    protected final void initialize() {
        if (!(!this.initialized.getAndSet(true))) {
            boolean bl = false;
            String string = this.getClass().getName() + " has to be initialized once.";
            throw new IllegalStateException(string.toString());
        }
        if (this.cleanOnLowMemory) {
            this.registerLowMemoryWatcher();
        }
        this.subscribe();
    }

    private final void registerLowMemoryWatcher() {
        LowMemoryWatcher.register(() -> FineGrainedEntityCache.registerLowMemoryWatcher$lambda$2(this), (Disposable)this);
    }

    protected final void checkIsInitialized() {
        if (!this.initialized.get()) {
            boolean bl = false;
            String string = this.getClass().getName() + " has to be initialized.";
            throw new IllegalStateException(string.toString());
        }
    }

    protected abstract <T> T useCache(@NotNull Function1<? super Map<Key, Value>, ? extends T> var1);

    public void dispose() {
        FineGrainedEntityCache.invalidate$default(this, false, 1, null);
    }

    @RequiresReadLock
    @NotNull
    public abstract Value get(@NotNull Key var1);

    @RequiresReadLock
    @NotNull
    public final Collection<Value> values() {
        ThreadingAssertions.softAssertReadAccess();
        return (Collection)this.useCache(FineGrainedEntityCache::values$lambda$4);
    }

    protected final void checkEntitiesIfRequired(@NotNull Map<Key, Value> cache2) {
        Intrinsics.checkNotNullParameter(cache2, (String)"cache");
        if (Companion.isValidityChecksEnabled() && this.invalidationStamp.isCheckRequired()) {
            this.checkEntities(cache2, CHECK_ALL);
        }
    }

    protected final void checkKeyAndDisposeIllegalEntry(@NotNull Key key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        if (Companion.isValidityChecksEnabled()) {
            try {
                this.checkKeyValidity(key);
            }
            catch (Throwable e) {
                this.useCache(arg_0 -> FineGrainedEntityCache.checkKeyAndDisposeIllegalEntry$lambda$5(this, key, arg_0));
                this.logger.error(e);
            }
        }
    }

    protected void disposeIllegalEntry(@NotNull Map<Key, Value> cache2, @NotNull Key key) {
        Intrinsics.checkNotNullParameter(cache2, (String)"cache");
        Intrinsics.checkNotNullParameter(key, (String)"key");
        cache2.remove(key);
    }

    protected final void putAll(@NotNull Map<Key, ? extends Value> map2) {
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        if (Companion.isValidityChecksEnabled()) {
            for (Map.Entry<Key, Value> entry : map2.entrySet()) {
                Key key = entry.getKey();
                Value value = entry.getValue();
                this.checkKeyValidity(key);
                this.checkValueValidity(value);
            }
        }
        this.useCache(arg_0 -> FineGrainedEntityCache.putAll$lambda$6(map2, arg_0));
    }

    protected final void invalidate(boolean writeAccessRequired) {
        if (writeAccessRequired) {
            ThreadingAssertions.assertWriteAccess();
        } else {
            ThreadingAssertions.softAssertReadAccess();
        }
        this.useCache(arg_0 -> FineGrainedEntityCache.invalidate$lambda$7(this, arg_0));
    }

    public static /* synthetic */ void invalidate$default(FineGrainedEntityCache fineGrainedEntityCache, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: invalidate");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        fineGrainedEntityCache.invalidate(bl);
    }

    protected void doInvalidate(@NotNull Map<Key, Value> cache2) {
        Intrinsics.checkNotNullParameter(cache2, (String)"cache");
        cache2.clear();
    }

    @RequiresWriteLock
    @NotNull
    protected final Collection<Value> invalidateKeysAndGetOutdatedValues(@NotNull Collection<? extends Key> keys, @Nullable Function2<? super Key, ? super Value, Boolean> validityCondition) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        ThreadingAssertions.assertWriteAccess();
        return (Collection)this.useCache(arg_0 -> FineGrainedEntityCache.invalidateKeysAndGetOutdatedValues$lambda$9(this, keys, validityCondition, arg_0));
    }

    public static /* synthetic */ Collection invalidateKeysAndGetOutdatedValues$default(FineGrainedEntityCache fineGrainedEntityCache, Collection collection, Function2 function2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: invalidateKeysAndGetOutdatedValues");
        }
        if ((n & 2) != 0) {
            function2 = CHECK_ALL;
        }
        return fineGrainedEntityCache.invalidateKeysAndGetOutdatedValues(collection, function2);
    }

    @NotNull
    protected Collection<Value> doInvalidateKeysAndGetOutdatedValues(@NotNull Collection<? extends Key> keys, @NotNull Map<Key, Value> cache2) {
        List list2;
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        Intrinsics.checkNotNullParameter(cache2, (String)"cache");
        List $this$doInvalidateKeysAndGetOutdatedValues_u24lambda_u2410 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        for (Key key : keys) {
            Value p0;
            if (cache2.remove(key) == null) continue;
            boolean bl2 = false;
            $this$doInvalidateKeysAndGetOutdatedValues_u24lambda_u2410.add(p0);
        }
        return CollectionsKt.build((List)list2);
    }

    @RequiresWriteLock
    protected final void invalidateKeys(@NotNull Collection<? extends Key> keys, @Nullable Function2<? super Key, ? super Value, Boolean> validityCondition) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        ThreadingAssertions.assertWriteAccess();
        this.useCache(arg_0 -> FineGrainedEntityCache.invalidateKeys$lambda$11(keys, this, validityCondition, arg_0));
    }

    public static /* synthetic */ void invalidateKeys$default(FineGrainedEntityCache fineGrainedEntityCache, Collection collection, Function2 function2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: invalidateKeys");
        }
        if ((n & 2) != 0) {
            function2 = CHECK_ALL;
        }
        fineGrainedEntityCache.invalidateKeys(collection, function2);
    }

    @RequiresWriteLock
    protected final void invalidateEntries(@NotNull Function2<? super Key, ? super Value, Boolean> condition2, @Nullable Function2<? super Key, ? super Value, Boolean> validityCondition) {
        Intrinsics.checkNotNullParameter(condition2, (String)"condition");
        ThreadingAssertions.assertWriteAccess();
        this.useCache(arg_0 -> FineGrainedEntityCache.invalidateEntries$lambda$12(condition2, this, validityCondition, arg_0));
    }

    public static /* synthetic */ void invalidateEntries$default(FineGrainedEntityCache fineGrainedEntityCache, Function2 function2, Function2 function22, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: invalidateEntries");
        }
        if ((n & 2) != 0) {
            function22 = CHECK_ALL;
        }
        fineGrainedEntityCache.invalidateEntries(function2, function22);
    }

    private final void checkEntities(Map<Key, Value> cache2, Function2<? super Key, ? super Value, Boolean> validityCondition) {
        if (Companion.isValidityChecksEnabled() && validityCondition != null) {
            boolean allEntriesChecked = true;
            Iterator<Map.Entry<Key, Value>> iterator2 = cache2.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<Key, Value> entry = iterator2.next();
                if (((Boolean)validityCondition.invoke(entry.getKey(), entry.getValue())).booleanValue()) {
                    try {
                        this.checkKeyConsistency(cache2, entry.getKey());
                        this.checkValueValidity(entry.getValue());
                    }
                    catch (Throwable e) {
                        iterator2.remove();
                        this.disposeEntry(cache2, entry);
                        this.logger.error(e);
                    }
                    continue;
                }
                allEntriesChecked = false;
            }
            this.additionalEntitiesCheck(cache2);
            if (allEntriesChecked) {
                this.invalidationStamp.reset();
            }
        }
    }

    protected void additionalEntitiesCheck(@NotNull Map<Key, Value> cache2) {
        Intrinsics.checkNotNullParameter(cache2, (String)"cache");
    }

    protected void disposeEntry(@NotNull Map<Key, Value> cache2, @NotNull Map.Entry<Key, Value> entry) {
        Intrinsics.checkNotNullParameter(cache2, (String)"cache");
        Intrinsics.checkNotNullParameter(entry, (String)"entry");
    }

    protected abstract void subscribe();

    protected abstract void checkKeyValidity(@NotNull Key var1);

    protected void checkKeyConsistency(@NotNull Map<Key, Value> cache2, @NotNull Key key) {
        Intrinsics.checkNotNullParameter(cache2, (String)"cache");
        Intrinsics.checkNotNullParameter(key, (String)"key");
        this.checkKeyValidity(key);
    }

    protected void checkValueValidity(@NotNull Value value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
    }

    private static final Unit registerLowMemoryWatcher$lambda$2$lambda$1(FineGrainedEntityCache this$0) {
        boolean isInvalidationThrottled;
        long nowMs = System.currentTimeMillis();
        boolean bl = isInvalidationThrottled = Companion.getInvalidationThrottlingMs() > 0 && nowMs < this$0.lastInvalidatedTimestampMs.get() + (long)Companion.getInvalidationThrottlingMs();
        if (isInvalidationThrottled) {
            this$0.logger.debug("invalidation throttled");
        } else {
            this$0.logger.debug("invalidated on low memory");
            FineGrainedEntityCache.invalidate$default(this$0, false, 1, null);
            this$0.lastInvalidatedTimestampMs.getAndSet(nowMs);
        }
        return Unit.INSTANCE;
    }

    private static final void registerLowMemoryWatcher$lambda$2(FineGrainedEntityCache this$0) {
        ActionsKt.runReadAction(() -> FineGrainedEntityCache.registerLowMemoryWatcher$lambda$2$lambda$1(this$0));
    }

    private static final Collection values$lambda$4(Map it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.values();
    }

    private static final Unit checkKeyAndDisposeIllegalEntry$lambda$5(FineGrainedEntityCache this$0, Object $key, Map cache2) {
        Intrinsics.checkNotNullParameter((Object)cache2, (String)"cache");
        this$0.disposeIllegalEntry(cache2, $key);
        return Unit.INSTANCE;
    }

    private static final Unit putAll$lambda$6(Map $map, Map cache2) {
        Intrinsics.checkNotNullParameter((Object)cache2, (String)"cache");
        for (Map.Entry entry : $map.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            cache2.putIfAbsent(key, value);
        }
        return Unit.INSTANCE;
    }

    private static final Unit invalidate$lambda$7(FineGrainedEntityCache this$0, Map cache2) {
        Intrinsics.checkNotNullParameter((Object)cache2, (String)"cache");
        this$0.doInvalidate(cache2);
        return Unit.INSTANCE;
    }

    private static final Collection invalidateKeysAndGetOutdatedValues$lambda$9(FineGrainedEntityCache this$0, Collection $keys, Function2 $validityCondition, Map cache2) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)cache2, (String)"cache");
        Collection it = collection = this$0.doInvalidateKeysAndGetOutdatedValues($keys, cache2);
        boolean bl = false;
        this$0.invalidationStamp.incInvalidation();
        this$0.checkEntities(cache2, $validityCondition);
        return collection;
    }

    private static final Unit invalidateKeys$lambda$11(Collection $keys, FineGrainedEntityCache this$0, Function2 $validityCondition, Map cache2) {
        Intrinsics.checkNotNullParameter((Object)cache2, (String)"cache");
        for (Object key : $keys) {
            cache2.remove(key);
        }
        this$0.invalidationStamp.incInvalidation();
        this$0.checkEntities(cache2, $validityCondition);
        return Unit.INSTANCE;
    }

    private static final Unit invalidateEntries$lambda$12(Function2 $condition, FineGrainedEntityCache this$0, Function2 $validityCondition, Map cache2) {
        Intrinsics.checkNotNullParameter((Object)cache2, (String)"cache");
        Iterator iterator2 = cache2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Object value;
            Map.Entry entry = iterator2.next();
            Object key = entry.getKey();
            if (!((Boolean)$condition.invoke(key, value = entry.getValue())).booleanValue()) continue;
            iterator2.remove();
        }
        this$0.invalidationStamp.incInvalidation();
        this$0.checkEntities(cache2, $validityCondition);
        return Unit.INSTANCE;
    }

    private static final boolean CHECK_ALL$lambda$13(Object object, Object object2) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)object2, (String)"<unused var>");
        return true;
    }

    private static final boolean isValidityChecksEnabled_delegate$lambda$14() {
        return Registry.Companion.is("kotlin.caches.fine.grained.entity.validation");
    }

    private static final int invalidationThrottlingMs_delegate$lambda$15() {
        return Math.max(Registry.Companion.intValue("kotlin.caches.fine.grained.throttling.timeout.ms"), 0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R#\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\t\u001a\u00020\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u001b\u0010\r\u001a\u00020\u000e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\f\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/base/util/caching/FineGrainedEntityCache$Companion;", "", "<init>", "()V", "CHECK_ALL", "Lkotlin/Function2;", "", "getCHECK_ALL", "()Lkotlin/jvm/functions/Function2;", "isValidityChecksEnabled", "()Z", "isValidityChecksEnabled$delegate", "Lkotlin/Lazy;", "invalidationThrottlingMs", "", "getInvalidationThrottlingMs", "()I", "invalidationThrottlingMs$delegate", "kotlin.base.util"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Function2<Object, Object, Boolean> getCHECK_ALL() {
            return CHECK_ALL;
        }

        public final boolean isValidityChecksEnabled() {
            Lazy lazy = isValidityChecksEnabled$delegate;
            return (Boolean)lazy.getValue();
        }

        public final int getInvalidationThrottlingMs() {
            Lazy lazy = invalidationThrottlingMs$delegate;
            return ((Number)lazy.getValue()).intValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/base/util/caching/FineGrainedEntityCache$InvalidationStamp;", "", "<init>", "()V", "currentCount", "", "count", "isCheckRequired", "", "incInvalidation", "", "reset", "kotlin.base.util"})
    private static final class InvalidationStamp {
        private int currentCount;
        private int count;

        public final boolean isCheckRequired() {
            return this.currentCount > this.count;
        }

        public final void incInvalidation() {
            int n = this.currentCount;
            this.currentCount = n + 1;
        }

        public final void reset() {
            this.count = this.currentCount;
        }
    }
}

