/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiElement;
import com.intellij.ui.IconManager;
import com.intellij.ui.RowIcon;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.InvalidModuleException;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.idea.KotlinIcons;
import org.jetbrains.kotlin.psi.KtElement;

public final class KotlinDescriptorIconProvider {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.kotlin.idea.KotlinDescriptorIconProvider");

    private KotlinDescriptorIconProvider() {
    }

    @Nullable
    public static Icon getIcon(@NotNull DeclarationDescriptor descriptor2, @Nullable PsiElement declaration, @Iconable.IconFlags int flags) {
        if (descriptor2 == null) {
            KotlinDescriptorIconProvider.$$$reportNull$$$0(0);
        }
        if (declaration != null && !(declaration instanceof KtElement)) {
            return declaration.getIcon(flags);
        }
        Icon result2 = KotlinDescriptorIconProvider.getBaseIcon(descriptor2);
        if ((flags & 1) > 0) {
            RowIcon rowIcon = new RowIcon(2);
            rowIcon.setIcon(result2, 0);
            rowIcon.setIcon(KotlinDescriptorIconProvider.getVisibilityIcon(descriptor2), 1);
            result2 = rowIcon;
        }
        return result2;
    }

    private static Icon getVisibilityIcon(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            KotlinDescriptorIconProvider.$$$reportNull$$$0(1);
        }
        if (descriptor2 instanceof DeclarationDescriptorWithVisibility) {
            DeclarationDescriptorWithVisibility descriptorWithVisibility = (DeclarationDescriptorWithVisibility)descriptor2;
            DescriptorVisibility visibility2 = descriptorWithVisibility.getVisibility().normalize();
            if (visibility2 == DescriptorVisibilities.PUBLIC) {
                return PlatformIcons.PUBLIC_ICON;
            }
            if (visibility2 == DescriptorVisibilities.PROTECTED) {
                return IconManager.getInstance().getPlatformIcon(com.intellij.ui.PlatformIcons.Protected);
            }
            if (DescriptorVisibilities.isPrivate((DescriptorVisibility)visibility2)) {
                return IconManager.getInstance().getPlatformIcon(com.intellij.ui.PlatformIcons.Private);
            }
            if (visibility2 == DescriptorVisibilities.INTERNAL) {
                return IconManager.getInstance().getPlatformIcon(com.intellij.ui.PlatformIcons.Local);
            }
        }
        return null;
    }

    private static Modality getModalitySafe(@NotNull MemberDescriptor descriptor2) {
        if (descriptor2 == null) {
            KotlinDescriptorIconProvider.$$$reportNull$$$0(2);
        }
        try {
            return descriptor2.getModality();
        }
        catch (InvalidModuleException ex) {
            return Modality.FINAL;
        }
    }

    private static Icon getBaseIcon(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            KotlinDescriptorIconProvider.$$$reportNull$$$0(3);
        }
        if (descriptor2 instanceof PackageFragmentDescriptor || descriptor2 instanceof PackageViewDescriptor) {
            return AllIcons.Nodes.Package;
        }
        if (descriptor2 instanceof FunctionDescriptor) {
            FunctionDescriptor functionDescriptor = (FunctionDescriptor)descriptor2;
            if (functionDescriptor.getExtensionReceiverParameter() != null) {
                return Modality.ABSTRACT == KotlinDescriptorIconProvider.getModalitySafe((MemberDescriptor)functionDescriptor) ? KotlinIcons.ABSTRACT_EXTENSION_FUNCTION : KotlinIcons.EXTENSION_FUNCTION;
            }
            if (descriptor2.getContainingDeclaration() instanceof ClassDescriptor) {
                return Modality.ABSTRACT == KotlinDescriptorIconProvider.getModalitySafe((MemberDescriptor)functionDescriptor) ? PlatformIcons.ABSTRACT_METHOD_ICON : IconManager.getInstance().getPlatformIcon(com.intellij.ui.PlatformIcons.Method);
            }
            return KotlinIcons.FUNCTION;
        }
        if (descriptor2 instanceof ClassDescriptor) {
            ClassDescriptor classDescriptor = (ClassDescriptor)descriptor2;
            return switch (classDescriptor.getKind()) {
                default -> throw new IncompatibleClassChangeError();
                case ClassKind.INTERFACE -> KotlinIcons.INTERFACE;
                case ClassKind.ENUM_CLASS, ClassKind.ENUM_ENTRY -> KotlinIcons.ENUM;
                case ClassKind.ANNOTATION_CLASS -> KotlinIcons.ANNOTATION;
                case ClassKind.OBJECT -> KotlinIcons.OBJECT;
                case ClassKind.CLASS -> Modality.ABSTRACT == KotlinDescriptorIconProvider.getModalitySafe((MemberDescriptor)classDescriptor) ? KotlinIcons.ABSTRACT_CLASS : KotlinIcons.CLASS;
            };
        }
        if (descriptor2 instanceof ValueParameterDescriptor) {
            return KotlinIcons.PARAMETER;
        }
        if (descriptor2 instanceof LocalVariableDescriptor) {
            return ((VariableDescriptor)descriptor2).isVar() ? KotlinIcons.VAR : KotlinIcons.VAL;
        }
        if (descriptor2 instanceof PropertyDescriptor) {
            return ((VariableDescriptor)descriptor2).isVar() ? KotlinIcons.FIELD_VAR : KotlinIcons.FIELD_VAL;
        }
        if (descriptor2 instanceof TypeParameterDescriptor) {
            return IconManager.getInstance().getPlatformIcon(com.intellij.ui.PlatformIcons.Class);
        }
        if (descriptor2 instanceof TypeAliasDescriptor) {
            return KotlinIcons.TYPE_ALIAS;
        }
        LOG.warn("No icon for descriptor: " + String.valueOf(descriptor2));
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "descriptor";
        objectArray2[1] = "org/jetbrains/kotlin/idea/KotlinDescriptorIconProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getIcon";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getVisibilityIcon";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getModalitySafe";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getBaseIcon";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

