/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.jvm.facade;

import com.intellij.lang.jvm.JvmClass;
import com.intellij.lang.jvm.facade.JvmElementProvider;
import com.intellij.lang.jvm.facade.JvmFacade;
import com.intellij.lang.jvm.util.JvmClassUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.impl.JavaPsiFacadeImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public final class JvmFacadeImpl
implements JvmFacade {
    private static final Logger LOG = Logger.getInstance(JvmFacadeImpl.class);
    private final DumbService myDumbService;
    private final JavaPsiFacadeImpl myJavaPsiFacade;
    private final Map<GlobalSearchScope, Map<String, List<JvmClass>>> myClassCache;

    public JvmFacadeImpl(@NotNull Project project) {
        if (project == null) {
            JvmFacadeImpl.$$$reportNull$$$0(0);
        }
        this.myClassCache = CollectionFactory.createConcurrentWeakKeySoftValueMap();
        this.myDumbService = DumbService.getInstance((Project)project);
        this.myJavaPsiFacade = (JavaPsiFacadeImpl)JavaPsiFacade.getInstance(project);
        project.getMessageBus().simpleConnect().subscribe(PsiModificationTracker.TOPIC, () -> this.myClassCache.clear());
    }

    @Override
    public @Unmodifiable @NotNull List<? extends JvmClass> findClasses(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (qualifiedName == null) {
            JvmFacadeImpl.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            JvmFacadeImpl.$$$reportNull$$$0(2);
        }
        Map map2 = this.myClassCache.computeIfAbsent(scope, s -> CollectionFactory.createConcurrentWeakValueMap());
        List list = map2.computeIfAbsent(qualifiedName, fqn -> this.doFindClassesWithJavaFacade((String)fqn, scope));
        if (list == null) {
            JvmFacadeImpl.$$$reportNull$$$0(3);
        }
        return list;
    }

    private @Unmodifiable List<JvmClass> doFindClassesWithJavaFacade(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (qualifiedName == null) {
            JvmFacadeImpl.$$$reportNull$$$0(4);
        }
        if (scope == null) {
            JvmFacadeImpl.$$$reportNull$$$0(5);
        }
        return JvmFacadeImpl.sortByScope(this.findClassesWithJavaFacade(qualifiedName, scope), scope);
    }

    private @Unmodifiable List<JvmClass> findClassesWithJavaFacade(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        List<PsiClass> javaClasses;
        if (qualifiedName == null) {
            JvmFacadeImpl.$$$reportNull$$$0(6);
        }
        if (scope == null) {
            JvmFacadeImpl.$$$reportNull$$$0(7);
        }
        ArrayList<JvmClass> result = null;
        List<JvmClass> ownClasses = this.findClassesWithoutJavaFacade(qualifiedName, scope);
        if (!ownClasses.isEmpty()) {
            result = new ArrayList<JvmClass>(ownClasses);
        }
        if (!(javaClasses = this.myJavaPsiFacade.findClassesWithoutJvmFacade(qualifiedName, scope)).isEmpty()) {
            if (result == null) {
                result = new ArrayList<PsiClass>(javaClasses);
            } else {
                result.addAll(javaClasses);
            }
        }
        return result == null ? Collections.emptyList() : result;
    }

    public @Unmodifiable @NotNull List<JvmClass> findClassesWithoutJavaFacade(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (qualifiedName == null) {
            JvmFacadeImpl.$$$reportNull$$$0(8);
        }
        if (scope == null) {
            JvmFacadeImpl.$$$reportNull$$$0(9);
        }
        ArrayList<? extends JvmClass> result = null;
        for (JvmElementProvider provider : this.filteredProviders()) {
            List<? extends JvmClass> providedClasses = provider.getClasses(qualifiedName, scope);
            if (providedClasses.isEmpty()) continue;
            JvmFacadeImpl.assertNotNullClasses(provider, providedClasses);
            if (result == null) {
                result = new ArrayList<JvmClass>(providedClasses);
                continue;
            }
            result.addAll(providedClasses);
        }
        List<JvmClass> list = result == null ? Collections.emptyList() : result;
        if (list == null) {
            JvmFacadeImpl.$$$reportNull$$$0(10);
        }
        return list;
    }

    private static @Unmodifiable @NotNull List<JvmClass> sortByScope(@NotNull @Unmodifiable List<JvmClass> classes, @NotNull GlobalSearchScope scope) {
        if (classes == null) {
            JvmFacadeImpl.$$$reportNull$$$0(11);
        }
        if (scope == null) {
            JvmFacadeImpl.$$$reportNull$$$0(12);
        }
        if (classes.size() == 1) {
            List<JvmClass> list = classes;
            if (list == null) {
                JvmFacadeImpl.$$$reportNull$$$0(13);
            }
            return list;
        }
        List list = ContainerUtil.sorted(classes, JvmClassUtil.createScopeComparator(scope));
        if (list == null) {
            JvmFacadeImpl.$$$reportNull$$$0(14);
        }
        return list;
    }

    private static void assertNotNullClasses(@NotNull JvmElementProvider provider, @NotNull List<? extends JvmClass> classes) {
        if (provider == null) {
            JvmFacadeImpl.$$$reportNull$$$0(15);
        }
        if (classes == null) {
            JvmFacadeImpl.$$$reportNull$$$0(16);
        }
        for (JvmClass jvmClass : classes) {
            LOG.assertTrue(jvmClass != null, (Object)("Provider " + provider + "returned null JvmClass"));
        }
    }

    private @Unmodifiable @NotNull List<JvmElementProvider> filteredProviders() {
        List list = this.myDumbService.filterByDumbAwareness((Collection)JvmElementProvider.EP_NAME.getExtensionList((AreaInstance)this.myJavaPsiFacade.getProject()));
        if (list == null) {
            JvmFacadeImpl.$$$reportNull$$$0(17);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 10: 
            case 13: 
            case 14: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 10: 
            case 13: 
            case 14: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: 
            case 10: 
            case 13: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/jvm/facade/JvmFacadeImpl";
                break;
            }
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/jvm/facade/JvmFacadeImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findClasses";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findClassesWithoutJavaFacade";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "sortByScope";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "filteredProviders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findClasses";
                break;
            }
            case 3: 
            case 10: 
            case 13: 
            case 14: 
            case 17: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doFindClassesWithJavaFacade";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findClassesWithJavaFacade";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findClassesWithoutJavaFacade";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "sortByScope";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "assertNotNullClasses";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 10: 
            case 13: 
            case 14: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

