/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.excelinput;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import jxl.BooleanCell;
import jxl.Cell;
import jxl.CellType;
import jxl.DateCell;
import jxl.LabelCell;
import jxl.NumberCell;
import jxl.Sheet;
import jxl.Workbook;
import jxl.WorkbookSettings;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.fileinput.FileInputList;
import org.pentaho.di.core.playlist.FilePlayListAll;
import org.pentaho.di.core.playlist.FilePlayListReplay;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.errorhandling.CompositeFileErrorHandler;
import org.pentaho.di.trans.step.errorhandling.FileErrorHandler;
import org.pentaho.di.trans.step.errorhandling.FileErrorHandlerContentLineNumber;
import org.pentaho.di.trans.step.errorhandling.FileErrorHandlerMissingFiles;
import org.pentaho.di.trans.steps.excelinput.ExcelInputData;
import org.pentaho.di.trans.steps.excelinput.ExcelInputField;
import org.pentaho.di.trans.steps.excelinput.ExcelInputMeta;
import org.pentaho.di.trans.steps.excelinput.ExcelInputRow;
import org.pentaho.di.trans.steps.excelinput.KettleCellValueException;
import org.pentaho.di.trans.steps.excelinput.Messages;

public class ExcelInput
extends BaseStep
implements StepInterface {
    private ExcelInputMeta meta;
    private ExcelInputData data;

    public ExcelInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private Object[] fillRow(int startcolumn, ExcelInputRow excelInputRow) throws KettleException {
        Object[] r = new Object[this.data.outputRowMeta.size()];
        boolean errorHandled = false;
        Cell cell = null;
        for (int i = startcolumn; i < excelInputRow.cells.length && i - startcolumn < this.meta.getField().length; ++i) {
            ValueMetaInterface sourceMeta;
            ValueMetaInterface targetMeta;
            int rowcolumn;
            block36: {
                cell = excelInputRow.cells[i];
                rowcolumn = i - startcolumn;
                targetMeta = this.data.outputRowMeta.getValueMeta(rowcolumn);
                sourceMeta = null;
                try {
                    this.checkType(cell, targetMeta);
                }
                catch (KettleException ex2) {
                    if (!this.meta.isErrorIgnored()) {
                        KettleCellValueException ex2 = new KettleCellValueException(ex2, this.data.sheetnr, this.data.rownr, i, "");
                        throw ex2;
                    }
                    if (this.log.isBasic()) {
                        this.logBasic(Messages.getString("ExcelInput.Log.WarningProcessingExcelFile", "" + targetMeta, "" + this.data.filename, ex2.getMessage()));
                    }
                    if (!errorHandled) {
                        this.data.errorHandler.handleLineError(excelInputRow.rownr, excelInputRow.sheetName);
                        errorHandled = true;
                    }
                    if (!this.meta.isErrorLineSkipped()) break block36;
                    return null;
                }
            }
            CellType cellType = cell.getType();
            if (CellType.BOOLEAN.equals(cellType) || CellType.BOOLEAN_FORMULA.equals(cellType)) {
                r[rowcolumn] = ((BooleanCell)cell).getValue();
                sourceMeta = this.data.valueMetaBoolean;
            } else if (CellType.DATE.equals(cellType) || CellType.DATE_FORMULA.equals(cellType)) {
                Date date = ((DateCell)cell).getDate();
                long time = date.getTime();
                int offset = TimeZone.getDefault().getOffset(time);
                r[rowcolumn] = new Date(time - (long)offset);
                sourceMeta = this.data.valueMetaDate;
            } else if (CellType.LABEL.equals(cellType) || CellType.STRING_FORMULA.equals(cellType)) {
                String string = ((LabelCell)cell).getString();
                switch (this.meta.getField()[rowcolumn].getTrimType()) {
                    case 1: {
                        string = Const.ltrim((String)string);
                        break;
                    }
                    case 2: {
                        string = Const.rtrim((String)string);
                        break;
                    }
                    case 3: {
                        string = Const.trim((String)string);
                        break;
                    }
                }
                r[rowcolumn] = string;
                sourceMeta = this.data.valueMetaString;
            } else if (CellType.NUMBER.equals(cellType) || CellType.NUMBER_FORMULA.equals(cellType)) {
                r[rowcolumn] = new Double(((NumberCell)cell).getValue());
                sourceMeta = this.data.valueMetaNumber;
            } else {
                if (this.log.isDetailed()) {
                    this.logDetailed(Messages.getString("ExcelInput.Log.UnknownType", cell.getType().toString(), cell.getContents()));
                }
                r[rowcolumn] = null;
            }
            ExcelInputField field = this.meta.getField()[rowcolumn];
            try {
                if (sourceMeta == null || sourceMeta.getType() == targetMeta.getType() || r[rowcolumn] == null) continue;
                ValueMetaInterface sourceMetaCopy = sourceMeta.clone();
                sourceMetaCopy.setConversionMask(field.getFormat());
                sourceMetaCopy.setGroupingSymbol(field.getGroupSymbol());
                sourceMetaCopy.setDecimalSymbol(field.getDecimalSymbol());
                sourceMetaCopy.setCurrencySymbol(field.getCurrencySymbol());
                block7 : switch (targetMeta.getType()) {
                    case 1: 
                    case 5: {
                        switch (field.getType()) {
                            case 3: {
                                ValueMeta valueMetaNumber = new ValueMeta("num", 1);
                                valueMetaNumber.setConversionMask("#");
                                Object string = sourceMetaCopy.convertData((ValueMetaInterface)valueMetaNumber, r[rowcolumn]);
                                r[rowcolumn] = targetMeta.convertData(sourceMetaCopy, string);
                                break block7;
                            }
                        }
                        r[rowcolumn] = targetMeta.convertData(sourceMetaCopy, r[rowcolumn]);
                        break;
                    }
                    default: {
                        r[rowcolumn] = targetMeta.convertData(sourceMetaCopy, r[rowcolumn]);
                    }
                }
                continue;
            }
            catch (KettleException ex3) {
                if (!this.meta.isErrorIgnored()) {
                    KettleCellValueException ex3 = new KettleCellValueException(ex3, this.data.sheetnr, cell.getRow(), i, field.getName());
                    throw ex3;
                }
                if (this.log.isBasic()) {
                    this.logBasic(Messages.getString("ExcelInput.Log.WarningProcessingExcelFile", "" + targetMeta, "" + this.data.filename, ex3.toString()));
                }
                if (!errorHandled) {
                    this.data.errorHandler.handleLineError(excelInputRow.rownr, excelInputRow.sheetName);
                    errorHandled = true;
                }
                if (this.meta.isErrorLineSkipped()) {
                    return null;
                }
                r[rowcolumn] = null;
            }
        }
        int rowIndex = this.meta.getField().length;
        if (!Const.isEmpty((String)this.meta.getFileField())) {
            r[rowIndex] = this.data.filename;
            ++rowIndex;
        }
        if (!Const.isEmpty((String)this.meta.getSheetField())) {
            r[rowIndex] = excelInputRow.sheetName;
            ++rowIndex;
        }
        if (!Const.isEmpty((String)this.meta.getSheetRowNumberField())) {
            r[rowIndex] = new Long(this.data.rownr);
            ++rowIndex;
        }
        if (!Const.isEmpty((String)this.meta.getRowNumberField())) {
            r[rowIndex] = new Long(this.getLinesWritten() + 1L);
            ++rowIndex;
        }
        return r;
    }

    private void checkType(Cell cell, ValueMetaInterface v) throws KettleException {
        if (!this.meta.isStrictTypes()) {
            return;
        }
        CellType cellType = cell.getType();
        if (cellType.equals(CellType.BOOLEAN)) {
            if (v.getType() != 2 && v.getType() != 0 && v.getType() != 4) {
                throw new KettleException(Messages.getString("ExcelInput.Exception.InvalidTypeBoolean", v.getTypeDesc()));
            }
        } else if (cellType.equals(CellType.DATE)) {
            if (v.getType() != 2 && v.getType() != 0 && v.getType() != 3) {
                throw new KettleException(Messages.getString("ExcelInput.Exception.InvalidTypeDate", cell.getContents(), v.getTypeDesc()));
            }
        } else if (cellType.equals(CellType.LABEL)) {
            if (v.getType() == 4 || v.getType() == 3 || v.getType() == 5 || v.getType() == 1) {
                throw new KettleException(Messages.getString("ExcelInput.Exception.InvalidTypeLabel", cell.getContents(), v.getTypeDesc()));
            }
        } else if (!cellType.equals(CellType.EMPTY)) {
            if (cellType.equals(CellType.NUMBER)) {
                if (v.getType() != 2 && v.getType() != 0 && v.getType() != 5 && v.getType() != 6 && v.getType() != 1) {
                    throw new KettleException(Messages.getString("ExcelInput.Exception.InvalidTypeNumber", cell.getContents(), v.getTypeDesc()));
                }
            } else {
                throw new KettleException(Messages.getString("ExcelInput.Exception.UnsupportedType", "" + cellType, cell.getContents()));
            }
        }
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (ExcelInputMeta)smi;
        this.data = (ExcelInputData)sdi;
        if (this.first) {
            this.first = false;
            this.data.outputRowMeta = new RowMeta();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
            if (this.meta.isAcceptingFilenames()) {
                this.data.files.getFiles().clear();
                int idx = -1;
                RowSet rowSet = this.findInputRowSet(this.meta.getAcceptingStepName());
                Object[] fileRow = this.getRowFrom(rowSet);
                while (fileRow != null) {
                    if (idx < 0 && (idx = rowSet.getRowMeta().indexOfValue(this.meta.getAcceptingField())) < 0) {
                        this.logError(Messages.getString("ExcelInput.Error.FilenameFieldNotFound", "" + this.meta.getAcceptingField()));
                        this.setErrors(1L);
                        this.stopAll();
                        return false;
                    }
                    String fileValue = rowSet.getRowMeta().getString(fileRow, idx);
                    try {
                        this.data.files.addFile(KettleVFS.getFileObject((String)fileValue));
                    }
                    catch (IOException e) {
                        throw new KettleException(Messages.getString("ExcelInput.Exception.CanNotCreateFileObject", fileValue), (Throwable)e);
                    }
                    fileRow = this.getRowFrom(rowSet);
                }
            }
            this.handleMissingFiles();
        }
        if (this.data.filenr >= this.data.files.nrOfFiles()) {
            if (this.log.isDetailed()) {
                this.logDetailed(Messages.getString("ExcelInput.Log.NoMoreFiles", "" + this.data.filenr));
            }
            this.setOutputDone();
            return false;
        }
        if (this.meta.getRowLimit() > 0L && (long)this.data.rownr > this.meta.getRowLimit()) {
            if (this.log.isDetailed()) {
                this.logDetailed(Messages.getString("ExcelInput.Log.RowLimitReached", "" + this.meta.getRowLimit()));
            }
            this.setOutputDone();
            return false;
        }
        Object[] r = this.getRowFromWorkbooks();
        if (r != null) {
            if (this.data.previousRow != null) {
                for (int i = 0; i < this.meta.getField().length; ++i) {
                    Object valueData;
                    ValueMetaInterface valueMeta = this.data.outputRowMeta.getValueMeta(i);
                    if (!valueMeta.isNull(valueData = r[i]) || !this.meta.getField()[i].isRepeated()) continue;
                    r[i] = this.data.previousRow[i];
                }
            }
            this.data.previousRow = this.data.outputRowMeta.cloneRow(r);
            this.putRow(this.data.outputRowMeta, r);
            return true;
        }
        return true;
    }

    private void handleMissingFiles() throws KettleException {
        List nonAccessibleFiles;
        List nonExistantFiles = this.data.files.getNonExistantFiles();
        if (nonExistantFiles.size() != 0) {
            String message = FileInputList.getRequiredFilesDescription((List)nonExistantFiles);
            if (this.log.isBasic()) {
                this.log.logBasic(Messages.getString("ExcelInput.Log.RequiredFilesTitle"), Messages.getString("ExcelInput.Warning.MissingFiles", message), new Object[0]);
            }
            if (this.meta.isErrorIgnored()) {
                for (FileObject fileObject : nonExistantFiles) {
                    this.data.errorHandler.handleNonExistantFile(fileObject);
                }
            } else {
                throw new KettleException(Messages.getString("ExcelInput.Exception.MissingRequiredFiles", message));
            }
        }
        if ((nonAccessibleFiles = this.data.files.getNonAccessibleFiles()).size() != 0) {
            String message = FileInputList.getRequiredFilesDescription((List)nonAccessibleFiles);
            if (this.log.isBasic()) {
                this.log.logBasic(Messages.getString("ExcelInput.Log.RequiredFilesTitle"), Messages.getString("ExcelInput.Log.RequiredFilesMsgNotAccessible", message), new Object[0]);
            }
            if (this.meta.isErrorIgnored()) {
                for (FileObject fileObject : nonAccessibleFiles) {
                    this.data.errorHandler.handleNonAccessibleFile(fileObject);
                }
            } else {
                throw new KettleException(Messages.getString("ExcelInput.Exception.RequiredFilesNotAccessible", message));
            }
        }
    }

    public Object[] getRowFromWorkbooks() {
        Object[] retval = null;
        try {
            String sheetName;
            Sheet sheet;
            if (this.data.workbook == null) {
                this.data.file = this.data.files.getFile(this.data.filenr);
                this.data.filename = KettleVFS.getFilename((FileObject)this.data.file);
                if (this.meta.isAddResultFile()) {
                    ResultFile resultFile = new ResultFile(0, this.data.file, this.getTransMeta().getName(), this.toString());
                    resultFile.setComment(Messages.getString("ExcelInput.Log.FileReadByStep"));
                    this.addResultFile(resultFile);
                }
                if (this.log.isDetailed()) {
                    this.logDetailed(Messages.getString("ExcelInput.Log.OpeningFile", "" + this.data.filenr + " : " + this.data.filename));
                }
                WorkbookSettings ws = new WorkbookSettings();
                if (!Const.isEmpty((String)this.meta.getEncoding())) {
                    ws.setEncoding(this.meta.getEncoding());
                }
                this.data.workbook = Workbook.getWorkbook((InputStream)KettleVFS.getInputStream((FileObject)this.data.file), (WorkbookSettings)ws);
                this.data.errorHandler.handleFile(this.data.file);
                this.data.sheetnr = 0;
                if (this.meta.readAllSheets()) {
                    this.data.sheetNames = this.data.workbook.getSheetNames();
                    this.data.startColumn = new int[this.data.sheetNames.length];
                    this.data.startRow = new int[this.data.sheetNames.length];
                    for (int i = 0; i < this.data.sheetNames.length; ++i) {
                        this.data.startColumn[i] = this.data.defaultStartColumn;
                        this.data.startRow[i] = this.data.defaultStartRow;
                    }
                }
            }
            boolean nextsheet = false;
            if (this.log.isDebug()) {
                this.logDetailed(Messages.getString("ExcelInput.Log.GetSheet", "" + this.data.filenr + "." + this.data.sheetnr));
            }
            if ((sheet = this.data.workbook.getSheet(sheetName = this.data.sheetNames[this.data.sheetnr])) != null) {
                if (this.data.rownr < 0) {
                    this.data.rownr = this.data.startRow[this.data.sheetnr];
                    if (this.meta.startsWithHeader()) {
                        ++this.data.rownr;
                    }
                }
                this.data.colnr = this.data.startColumn[this.data.sheetnr];
                try {
                    Cell[] line = sheet.getRow(this.data.rownr);
                    int lineNr = ++this.data.rownr;
                    if (!this.data.filePlayList.isProcessingNeeded(this.data.file, lineNr, sheetName)) {
                        retval = null;
                    } else {
                        boolean isEmpty;
                        if (this.log.isRowLevel()) {
                            this.logRowlevel(Messages.getString("ExcelInput.Log.GetLine", "" + lineNr, this.data.filenr + "." + this.data.sheetnr));
                        }
                        if (this.log.isRowLevel()) {
                            this.logRowlevel(Messages.getString("ExcelInput.Log.ReadLineWith", "" + line.length));
                        }
                        ExcelInputRow excelInputRow = new ExcelInputRow(sheet.getName(), lineNr, line);
                        Object[] r = this.fillRow(this.data.colnr, excelInputRow);
                        if (this.log.isRowLevel()) {
                            this.logRowlevel(Messages.getString("ExcelInput.Log.ConvertedLinToRow", "" + lineNr, this.data.outputRowMeta.getString(r)));
                        }
                        if (!(isEmpty = this.isLineEmpty(line)) || !this.meta.ignoreEmptyRows()) {
                            retval = r;
                        } else if (this.data.rownr > sheet.getRows()) {
                            nextsheet = true;
                        }
                        if (isEmpty && this.meta.stopOnEmpty()) {
                            nextsheet = true;
                        }
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    if (this.log.isRowLevel()) {
                        this.logRowlevel(Messages.getString("ExcelInput.Log.OutOfIndex"));
                    }
                    nextsheet = true;
                }
            } else {
                nextsheet = true;
            }
            if (nextsheet) {
                ++this.data.sheetnr;
                this.data.rownr = -1;
                this.data.previousRow = null;
                if (this.data.sheetnr >= this.data.sheetNames.length) {
                    this.jumpToNextFile();
                }
            }
        }
        catch (Exception e) {
            this.logError(Messages.getString("ExcelInput.Error.ProcessRowFromExcel", this.data.filename + "", e.toString()));
            this.setErrors(1L);
            this.stopAll();
            return null;
        }
        return retval;
    }

    private boolean isLineEmpty(Cell[] line) {
        if (line.length == 0) {
            return true;
        }
        boolean isEmpty = true;
        for (int i = 0; i < line.length && isEmpty; ++i) {
            if (Const.isEmpty((String)line[i].getContents())) continue;
            isEmpty = false;
        }
        return isEmpty;
    }

    private void jumpToNextFile() throws KettleException {
        this.data.sheetnr = 0;
        this.data.rownr = -1;
        this.data.previousRow = null;
        this.data.workbook.close();
        this.data.workbook = null;
        this.data.errorHandler.close();
        ++this.data.filenr;
    }

    private void initErrorHandling() {
        ArrayList<FileErrorHandler> errorHandlers = new ArrayList<FileErrorHandler>(2);
        if (this.meta.getLineNumberFilesDestinationDirectory() != null) {
            errorHandlers.add(new FileErrorHandlerContentLineNumber(this.getTrans().getCurrentDate(), this.meta.getLineNumberFilesDestinationDirectory(), this.meta.getLineNumberFilesExtension(), "Latin1", this));
        }
        if (this.meta.getErrorFilesDestinationDirectory() != null) {
            errorHandlers.add(new FileErrorHandlerMissingFiles(this.getTrans().getCurrentDate(), this.meta.getErrorFilesDestinationDirectory(), this.meta.getErrorFilesExtension(), "Latin1", this));
        }
        this.data.errorHandler = new CompositeFileErrorHandler(errorHandlers);
    }

    private void initReplayFactory() {
        Date replayDate = this.getTrans().getReplayDate();
        this.data.filePlayList = replayDate == null ? FilePlayListAll.INSTANCE : new FilePlayListReplay(replayDate, this.meta.getLineNumberFilesDestinationDirectory(), this.meta.getLineNumberFilesExtension(), this.meta.getErrorFilesDestinationDirectory(), this.meta.getErrorFilesExtension(), "Latin1");
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (ExcelInputMeta)smi;
        this.data = (ExcelInputData)sdi;
        if (super.init(smi, sdi)) {
            this.initErrorHandling();
            this.initReplayFactory();
            this.data.files = this.meta.getFileList(this);
            if (this.data.files.nrOfFiles() == 0 && this.data.files.nrOfMissingFiles() == 0 && !this.meta.isAcceptingFilenames()) {
                this.logError(Messages.getString("ExcelInput.Error.NoFileSpecified"));
                return false;
            }
            if (this.meta.getEmptyFields().size() > 0) {
                this.data.maxfilelength = -1;
                for (FileObject file : this.data.files.getFiles()) {
                    String name = KettleVFS.getFilename((FileObject)file);
                    if (name.length() <= this.data.maxfilelength) continue;
                    this.data.maxfilelength = name.length();
                }
                this.data.maxsheetlength = -1;
                if (!this.meta.readAllSheets()) {
                    this.data.sheetNames = new String[this.meta.getSheetName().length];
                    this.data.startColumn = new int[this.meta.getSheetName().length];
                    this.data.startRow = new int[this.meta.getSheetName().length];
                    for (int i = 0; i < this.meta.getSheetName().length; ++i) {
                        this.data.sheetNames[i] = this.meta.getSheetName()[i];
                        this.data.startColumn[i] = this.meta.getStartColumn()[i];
                        this.data.startRow[i] = this.meta.getStartRow()[i];
                        if (this.meta.getSheetName()[i].length() <= this.data.maxsheetlength) continue;
                        this.data.maxsheetlength = this.meta.getSheetName()[i].length();
                    }
                } else {
                    this.data.defaultStartRow = this.meta.getStartRow().length == 1 ? this.meta.getStartRow()[0] : 0;
                    this.data.defaultStartColumn = this.meta.getStartColumn().length == 1 ? this.meta.getStartColumn()[0] : 0;
                }
                return true;
            }
            this.logError(Messages.getString("ExcelInput.Error.NotInputFieldsDefined"));
        }
        return false;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        block6: {
            this.meta = (ExcelInputMeta)smi;
            this.data = (ExcelInputData)sdi;
            if (this.data.workbook != null) {
                this.data.workbook.close();
            }
            if (this.data.file != null) {
                try {
                    this.data.file.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            try {
                this.data.errorHandler.close();
            }
            catch (KettleException e) {
                if (!this.log.isDebug()) break block6;
                this.logDebug(Messages.getString("ExcelInput.Error.CouldNotCloseErrorHandler", e.toString()));
                this.logDebug(Const.getStackTracker((Throwable)e));
            }
        }
        super.dispose(smi, sdi);
    }

    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }
}

