/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import net.i2p.data.Hash;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.router.RouterIdentity;
import net.i2p.router.HandlerJobBuilder;
import net.i2p.router.Job;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.networkdb.kademlia.HandleFloodfillDatabaseStoreMessageJob;
import net.i2p.util.RandomSource;

public class FloodfillDatabaseStoreMessageHandler
implements HandlerJobBuilder {
    private RouterContext _context;
    private FloodfillNetworkDatabaseFacade _facade;
    private final long _msgIDBloomXor = RandomSource.getInstance().nextLong(0xFFFFFFFFL);

    public FloodfillDatabaseStoreMessageHandler(RouterContext context, FloodfillNetworkDatabaseFacade facade) {
        this._context = context;
        this._facade = facade;
        context.statManager().createRateStat("netDb.storeHandled", "How many netDb store messages have we handled?", "NetworkDatabase", new long[]{60000L, 3600000L});
        context.statManager().createRateStat("netDb.storeLeaseSetHandled", "How many leaseSet store messages have we handled?", "NetworkDatabase", new long[]{60000L, 3600000L});
        context.statManager().createRateStat("netDb.storeRouterInfoHandled", "How many routerInfo store messages have we handled?", "NetworkDatabase", new long[]{60000L, 3600000L});
        context.statManager().createRateStat("netDb.storeRecvTime", "How long it takes to handle the local store part of a dbStore?", "NetworkDatabase", new long[]{3600000L});
        context.statManager().createRateStat("netDb.storeLocalLeaseSetAttempt", "How many local LeaseSet store messages were attempted?", "NetworkDatabase", new long[]{3600000L});
    }

    @Override
    public Job createJob(I2NPMessage receivedMessage, RouterIdentity from, Hash fromHash) {
        DatabaseStoreMessage dsm = (DatabaseStoreMessage)receivedMessage;
        Hash by = dsm.getEntry().getReceivedBy();
        FloodfillNetworkDatabaseFacade netdb = by != null ? (FloodfillNetworkDatabaseFacade)this._context.clientNetDb(by) : this._facade;
        HandleFloodfillDatabaseStoreMessageJob j = new HandleFloodfillDatabaseStoreMessageJob(this._context, dsm, from, fromHash, netdb, this._msgIDBloomXor);
        return j;
    }
}

