<?php

declare(strict_types=1);

/*
 * Copyright (c) 2017-2022 François Kooman <fkooman@tuxed.net>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

require_once dirname(__DIR__) . '/vendor/autoload.php';

use fkooman\SeCookie\ActiveSession;
use fkooman\SeCookie\PdoSessionStorage;

$sessionStorage = new PdoSessionStorage(
    new PDO(
        'mysql:host=localhost;port=3306;dbname=test',
        'test',
        'test'
    ),
    'abc_'
);
$sessionStorage->drop();
$sessionStorage->init();

$dateTime = new DateTimeImmutable('2045-10-10T09:00:00+00:00', new DateTimeZone('UTC'));
$sessionStorage->store(
    new ActiveSession(
        'session_id',
        $dateTime,
        [
            'foo' => 'bar',
        ]
    )
);

$activeSession = $sessionStorage->retrieve('session_id');
var_dump($activeSession->expiresAt()->format(DateTimeImmutable::ATOM));
var_dump($activeSession->get('foo'));
$sessionStorage->destroy('session_id');
var_dump($sessionStorage->retrieve('session_id'));
