/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.tree.TreeNode;
import org.openide.explorer.view.NodeModel;
import org.openide.explorer.view.VisualizerEvent;
import org.openide.explorer.view.VisualizerNode;
import org.openide.nodes.Node;

final class VisualizerChildren {
    public static final VisualizerChildren EMPTY = new VisualizerChildren();
    private static final Logger LOG = Logger.getLogger(VisualizerChildren.class.getName());
    public final VisualizerNode parent;
    private final List<VisualizerNode> visNodes;
    private List<Node> snapshot;

    private VisualizerChildren() {
        this.visNodes = Collections.emptyList();
        this.snapshot = Collections.emptyList();
        this.parent = null;
    }

    public VisualizerChildren(VisualizerNode visualizerNode, List<Node> list) {
        this.parent = visualizerNode;
        int n = list.size();
        this.visNodes = new ArrayList<VisualizerNode>(n);
        for (int i = 0; i < n; ++i) {
            this.visNodes.add(null);
        }
        this.snapshot = list;
    }

    private void recomputeIndexes(VisualizerNode visualizerNode) {
        VisualizerNode visualizerNode2;
        int n;
        List<VisualizerNode> list = this.getVisNodes(true);
        assert (list.size() == this.snapshot.size()) : "visnodes.size()=" + list.size() + " snapshot.size()=" + this.snapshot.size();
        for (n = 0; n < list.size(); ++n) {
            visualizerNode2 = list.get(n);
            if (visualizerNode2 == null) continue;
            visualizerNode2.indexOf = n;
        }
        if (visualizerNode != null && visualizerNode.indexOf == -1) {
            n = 0;
            while (n < list.size()) {
                visualizerNode2 = (VisualizerNode)this.getChildAt(n);
                visualizerNode2.indexOf = n++;
                if (visualizerNode2 != visualizerNode) continue;
                return;
            }
        }
    }

    public TreeNode getChildAt(int n) {
        List<VisualizerNode> list = this.getVisNodes(false);
        if (n >= list.size()) {
            return VisualizerNode.EMPTY;
        }
        VisualizerNode visualizerNode = list.get(n);
        if (visualizerNode == null) {
            Node node = this.snapshot.get(n);
            if (node == null) {
                throw new NullPointerException("snapshot: " + this.snapshot + " pos: " + n + " parent: " + this.parent);
            }
            visualizerNode = VisualizerNode.getVisualizer(this, node);
            visualizerNode.indexOf = n;
            list.set(n, visualizerNode);
            this.parent.notifyVisualizerChildrenChange(false, this);
        }
        return visualizerNode;
    }

    public int getChildCount() {
        return this.getVisNodes(false).size();
    }

    public Enumeration<VisualizerNode> children(final boolean bl) {
        return new Enumeration<VisualizerNode>(){
            private int index;

            @Override
            public boolean hasMoreElements() {
                return this.index < VisualizerChildren.this.getVisNodes(false).size();
            }

            @Override
            public VisualizerNode nextElement() {
                return bl ? (VisualizerNode)VisualizerChildren.this.getChildAt(this.index++) : VisualizerChildren.this.getVisNodes(false).get(this.index++);
            }
        };
    }

    public int getIndex(TreeNode treeNode) {
        VisualizerNode visualizerNode = (VisualizerNode)treeNode;
        if (visualizerNode.indexOf != -1) {
            List<VisualizerNode> list = this.getVisNodes(false);
            if (visualizerNode.indexOf >= list.size() || list.get(visualizerNode.indexOf) != visualizerNode) {
                return -1;
            }
        } else {
            this.recomputeIndexes(visualizerNode);
        }
        return visualizerNode.indexOf;
    }

    final String dumpIndexes(VisualizerNode visualizerNode) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("EMPTY: ").append(visualizerNode == VisualizerNode.EMPTY).append(", Lazy: ").append(this.snapshot.getClass().getName().endsWith("LazySnapshot"));
        stringBuilder.append("\nSeeking for: ").append(visualizerNode.toId());
        stringBuilder.append("\nwith parent: ").append((VisualizerNode)visualizerNode.getParent() != null ? ((VisualizerNode)visualizerNode.getParent()).toId() : "null");
        stringBuilder.append("\nSeeking in : ").append(this.parent != null ? this.parent.toId() : "null").append("\n");
        this.addVisNodesInfo(stringBuilder);
        return stringBuilder.toString();
    }

    private void addVisNodesInfo(StringBuilder stringBuilder) {
        List<VisualizerNode> list = this.getVisNodes(false);
        for (int i = 0; i < list.size(); ++i) {
            VisualizerNode visualizerNode = list.get(i);
            stringBuilder.append("  ").append(i);
            if (visualizerNode != null) {
                stringBuilder.append(" = ").append(visualizerNode.toId());
            } else {
                stringBuilder.append(" = null");
            }
            stringBuilder.append('\n');
        }
    }

    final String dumpEventInfo(VisualizerEvent visualizerEvent) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nEvent: ").append(visualizerEvent.getClass().getName());
        stringBuilder.append("\nOriginal event: ").append(visualizerEvent.originalEvent.getClass().getName());
        stringBuilder.append("\ncurrent vis. nodes:");
        this.addVisNodesInfo(stringBuilder);
        stringBuilder.append("\nIndexes: ");
        int[] nArray = visualizerEvent.getArray();
        for (int i = 0; i < nArray.length; ++i) {
            stringBuilder.append(Integer.toString(nArray[i]));
            stringBuilder.append(" ");
        }
        stringBuilder.append("\n");
        stringBuilder.append(visualizerEvent.originalEvent.toString());
        return stringBuilder.toString();
    }

    public void added(VisualizerEvent.Added added) {
        if (this != this.parent.getChildren()) {
            return;
        }
        this.snapshot = added.getSnapshot();
        ListIterator<VisualizerNode> listIterator = this.getVisNodes(true).listIterator();
        int[] nArray = added.getArray();
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            while (n++ < nArray[i]) {
                listIterator.next();
            }
            listIterator.add(null);
        }
        this.recomputeIndexes(null);
        for (VisualizerNode visualizerNode = this.parent; visualizerNode != null; visualizerNode = (VisualizerNode)visualizerNode.getParent()) {
            Object[] objectArray = visualizerNode.getListenerList();
            for (int i = objectArray.length - 1; i >= 0; i -= 2) {
                ((NodeModel)objectArray[i]).added(added);
            }
        }
    }

    public void removed(VisualizerEvent.Removed removed) {
        Object object;
        if (this != this.parent.getChildren()) {
            return;
        }
        this.snapshot = removed.getSnapshot();
        int[] nArray = removed.getArray();
        if (nArray.length == 0) {
            return;
        }
        List<VisualizerNode> list = this.getVisNodes(true);
        if (list.isEmpty()) {
            return;
        }
        assert (list.size() > nArray[nArray.length - 1]) : this.dumpEventInfo(removed);
        int n = Integer.MAX_VALUE;
        for (int i = nArray.length - 1; i >= 0; --i) {
            if (list.isEmpty()) continue;
            assert (nArray[i] < n) : "Indexes have to be descendant. Prev: " + n + " next: " + nArray[i] + " at " + i;
            object = list.remove(nArray[i]);
            removed.removed.add((VisualizerNode)(object != null ? object : VisualizerNode.EMPTY));
        }
        this.recomputeIndexes(null);
        for (VisualizerNode visualizerNode = this.parent; visualizerNode != null; visualizerNode = (VisualizerNode)visualizerNode.getParent()) {
            object = visualizerNode.getListenerList();
            for (int i = ((Object[])object).length - 1; i >= 0; i -= 2) {
                ((NodeModel)object[i]).removed(removed);
            }
        }
        if (list.isEmpty()) {
            this.parent.notifyVisualizerChildrenChange(true, this);
        }
    }

    public void reordered(VisualizerEvent.Reordered reordered) {
        int n;
        Object[] objectArray;
        if (this != this.parent.getChildren()) {
            return;
        }
        this.snapshot = reordered.getSnapshot();
        int[] nArray = reordered.getArray();
        List<VisualizerNode> list = this.getVisNodes(true);
        VisualizerNode[] visualizerNodeArray = list.toArray(new VisualizerNode[0]);
        VisualizerNode[] visualizerNodeArray2 = new VisualizerNode[visualizerNodeArray.length];
        int n2 = nArray.length;
        try {
            for (int i = 0; i < n2; ++i) {
                objectArray = visualizerNodeArray[i];
                n = nArray[i];
                if (visualizerNodeArray2[n] != null) {
                    LOG.log(Level.WARNING, "Writing to this index for the second time: {0}", n);
                    LOG.log(Level.WARNING, "Length of indxs array: {0}", nArray.length);
                    LOG.log(Level.WARNING, "Length of actual array: {0}", visualizerNodeArray.length);
                    LOG.warning("Indices of reorder event:");
                    int n3 = 0;
                    while (i < nArray.length) {
                        LOG.log(Level.WARNING, "\t{0}", nArray[n3]);
                        ++n3;
                    }
                    LOG.log(Level.WARNING, "Who", new Exception());
                    return;
                }
                visualizerNodeArray2[n] = objectArray;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            LOG.log(Level.WARNING, "Length of actual array: " + visualizerNodeArray.length, arrayIndexOutOfBoundsException);
            LOG.warning("Indices of reorder event:");
            for (int i = 0; i < nArray.length; ++i) {
                LOG.log(Level.WARNING, "\t{0}", nArray[i]);
            }
            return;
        }
        list.clear();
        list.addAll(Arrays.asList(visualizerNodeArray2));
        this.recomputeIndexes(null);
        for (VisualizerNode visualizerNode = this.parent; visualizerNode != null; visualizerNode = (VisualizerNode)visualizerNode.getParent()) {
            objectArray = visualizerNode.getListenerList();
            for (n = objectArray.length - 1; n >= 0; n -= 2) {
                ((NodeModel)objectArray[n]).reordered(reordered);
            }
        }
    }

    public String toString() {
        String string = "";
        if (this.parent != null) {
            string = "Parent: " + this.parent + " ";
        }
        string = string + "[";
        for (VisualizerNode visualizerNode : this.getVisNodes(false)) {
            VisualizerChildren visualizerChildren;
            string = string + visualizerNode;
            if (visualizerNode != null && (visualizerChildren = visualizerNode.getChildren(false)) != EMPTY) {
                string = string + visualizerChildren;
            }
            string = string + " ";
        }
        string = string + " {" + this.snapshot + "}";
        string = string + "]";
        return string;
    }

    final List<VisualizerNode> getVisNodes(boolean bl) {
        if (bl) assert (EventQueue.isDispatchThread());
        return this.visNodes;
    }
}

