/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.search.provider;

import java.io.File;
import java.net.URI;
import java.util.regex.Pattern;
import org.netbeans.api.search.RegexpUtil;
import org.netbeans.api.search.SearchScopeOptions;
import org.openide.filesystems.FileObject;

public abstract class FileNameMatcher {
    private static final FileNameMatcher TAKE_ALL_INSTANCE = new TakeAllMatcher();

    private FileNameMatcher() {
    }

    public abstract boolean pathMatches(File var1);

    public abstract boolean pathMatches(FileObject var1);

    public abstract boolean pathMatches(URI var1);

    public static FileNameMatcher create(SearchScopeOptions searchScopeOptions) {
        if (searchScopeOptions.getPattern().isEmpty()) {
            return TAKE_ALL_INSTANCE;
        }
        if (!searchScopeOptions.isRegexp() && searchScopeOptions.getPattern().matches("\\*\\.\\w+")) {
            return new ExtensionMatcher(searchScopeOptions.getPattern().substring(2));
        }
        if (!searchScopeOptions.isRegexp()) {
            return new SimplePatternMatcher(searchScopeOptions);
        }
        return new RegexpPatternMatcher(searchScopeOptions);
    }

    private static class SimplePatternMatcher
    extends FileNameMatcher {
        private Pattern pattern = null;

        protected SimplePatternMatcher(SearchScopeOptions searchScopeOptions) {
            if (searchScopeOptions != null) {
                this.pattern = RegexpUtil.makeFileNamePattern(searchScopeOptions);
            }
        }

        @Override
        public boolean pathMatches(File file) {
            return this.pattern.matcher(file.getName()).matches();
        }

        @Override
        public boolean pathMatches(FileObject fileObject) {
            return this.pattern.matcher(fileObject.getNameExt()).matches();
        }

        @Override
        public boolean pathMatches(URI uRI) {
            String string = uRI.getPath();
            int n = string.lastIndexOf("\\");
            if (n == -1) {
                n = string.lastIndexOf("/");
            }
            if (n == -1) {
                return false;
            }
            String string2 = string.substring(n + 1);
            return this.pattern.matcher(string2).matches();
        }
    }

    private static class RegexpPatternMatcher
    extends FileNameMatcher {
        private Pattern pattern = null;

        protected RegexpPatternMatcher(SearchScopeOptions searchScopeOptions) {
            if (searchScopeOptions != null) {
                this.pattern = RegexpUtil.makeFileNamePattern(searchScopeOptions);
            }
        }

        @Override
        public boolean pathMatches(File file) {
            return this.pattern.matcher(file.getPath()).find();
        }

        @Override
        public boolean pathMatches(FileObject fileObject) {
            return this.pattern.matcher(fileObject.getPath()).find();
        }

        @Override
        public boolean pathMatches(URI uRI) {
            return this.pattern.matcher(uRI.getPath()).find();
        }
    }

    private static class ExtensionMatcher
    extends FileNameMatcher {
        private String ext;
        private String extWithDot;
        private int extWithDotLen;

        public ExtensionMatcher(String string) {
            this.ext = string;
            this.extWithDot = "." + string;
            this.extWithDotLen = string.length() + 1;
        }

        private boolean pathMatches(String string) {
            if (string == null || string.length() <= this.extWithDotLen) {
                return false;
            }
            return string.substring(string.length() - this.extWithDotLen).equalsIgnoreCase(this.extWithDot);
        }

        @Override
        public boolean pathMatches(File file) {
            String string = file.getName();
            return this.pathMatches(string);
        }

        @Override
        public boolean pathMatches(FileObject fileObject) {
            String string = fileObject.getExt();
            return string != null && string.equalsIgnoreCase(this.ext);
        }

        @Override
        public boolean pathMatches(URI uRI) {
            String string = uRI.getPath();
            return this.pathMatches(string);
        }
    }

    private static class TakeAllMatcher
    extends FileNameMatcher {
        private TakeAllMatcher() {
        }

        @Override
        public boolean pathMatches(File file) {
            return true;
        }

        @Override
        public boolean pathMatches(FileObject fileObject) {
            return true;
        }

        @Override
        public boolean pathMatches(URI uRI) {
            return true;
        }
    }
}

