/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.filters;

import java.util.Arrays;
import java.util.Properties;
import org.graalvm.visualvm.lib.jfluid.filters.GenericFilter;

public class JavaTypeFilter
extends GenericFilter {
    protected static final int MODE_STARTS_WITH_EX = 1025;
    private transient Boolean isAll;
    private transient Boolean isExact;
    private transient Boolean hasArray;

    public JavaTypeFilter() {
    }

    public JavaTypeFilter(GenericFilter other) {
        super(other);
    }

    public JavaTypeFilter(String value, int type) {
        super(null, value, type);
    }

    public JavaTypeFilter(Properties properties, String id) {
        super(properties, id);
    }

    public void copyFrom(JavaTypeFilter other) {
        super.copyFrom(other);
        this.isAll = other.isAll;
        this.isExact = other.isExact;
        this.hasArray = other.hasArray;
    }

    @Override
    public final boolean isAll() {
        if (super.isAll()) {
            return true;
        }
        if (this.isAll == null) {
            this.computeFlags();
        }
        return this.isAll;
    }

    public final boolean isExact() {
        if (this.isExact == null) {
            this.computeFlags();
        }
        return this.isExact;
    }

    private void computeFlags() {
        for (String value : this.getValues()) {
            if ("*".equals(value) || "**".equals(value)) {
                this.isAll = true;
                this.isExact = false;
                break;
            }
            if (value.charAt(value.length() - 1) != '*') continue;
            this.isExact = false;
        }
        if (this.isAll == null) {
            this.isAll = false;
        }
        if (this.isExact == null) {
            this.isExact = true;
        }
    }

    public final boolean hasArray() {
        if (this.hasArray == null) {
            this.hasArray = this.getValue().indexOf(91) > -1;
        }
        return this.hasArray;
    }

    @Override
    protected void valueChanged() {
        super.valueChanged();
        this.isAll = null;
        this.isExact = null;
        this.hasArray = null;
    }

    @Override
    protected String[] computeValues(String value) {
        return super.computeValues(value.replace('.', '/'));
    }

    @Override
    protected int[] computeModes(String[] values) {
        int length = values.length;
        int[] modes = new int[length];
        Arrays.fill(modes, 1000);
        for (int i = 0; i < length; ++i) {
            int vlength;
            String value = values[i];
            int n = vlength = value == null ? 0 : value.length();
            if (vlength <= 0 || '*' != value.charAt(vlength - 1)) continue;
            if (vlength > 1 && '*' == value.charAt(vlength - 2)) {
                value = value.substring(0, vlength - 2);
                modes[i] = 1020;
            } else {
                value = value.substring(0, vlength - 1);
                modes[i] = 1025;
            }
            values[i] = value;
        }
        return modes;
    }

    @Override
    protected boolean matches(String string, String filter, int mode) {
        if (filter.isEmpty()) {
            return true;
        }
        if (mode == 1025) {
            if (!string.startsWith(filter)) {
                return false;
            }
            for (int i = filter.length(); i < string.length(); ++i) {
                if ('/' != string.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return super.matches(string, filter, mode);
    }
}

