/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.session;

import io.netty.channel.Channel;
import io.netty.handler.codec.http.HttpRequestDecoder;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import org.traccar.BasePipelineFactory;
import org.traccar.Protocol;
import org.traccar.model.Command;
import org.traccar.session.ConnectionKey;

public class DeviceSession {
    private final long deviceId;
    private final String uniqueId;
    private final String model;
    private final Protocol protocol;
    private final Channel channel;
    private final SocketAddress remoteAddress;
    public static final String KEY_TIMEZONE = "timezone";
    private final Map<String, Object> locals = new HashMap<String, Object>();

    public DeviceSession(long deviceId, String uniqueId, String model, Protocol protocol, Channel channel, SocketAddress remoteAddress) {
        this.deviceId = deviceId;
        this.uniqueId = uniqueId;
        this.model = model;
        this.protocol = protocol;
        this.channel = channel;
        this.remoteAddress = remoteAddress;
    }

    public long getDeviceId() {
        return this.deviceId;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public String getModel() {
        return this.model;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public ConnectionKey getConnectionKey() {
        return new ConnectionKey(this.channel, this.remoteAddress);
    }

    public boolean supportsLiveCommands() {
        return BasePipelineFactory.getHandler(this.channel.pipeline(), HttpRequestDecoder.class) == null;
    }

    public void sendCommand(Command command) {
        this.protocol.sendDataCommand(this.channel, this.remoteAddress, command);
    }

    public boolean contains(String key) {
        return this.locals.containsKey(key);
    }

    public void set(String key, Object value) {
        if (value != null) {
            this.locals.put(key, value);
        } else {
            this.locals.remove(key);
        }
    }

    public <T> T get(String key) {
        return (T)this.locals.get(key);
    }
}

