/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import java.io.Reader;
import java.io.StringReader;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.traccar.BaseHttpProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class RamacProtocolDecoder
extends BaseHttpProtocolDecoder {
    private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public RamacProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        FullHttpRequest request = (FullHttpRequest)msg;
        String content = request.content().toString(StandardCharsets.UTF_8);
        JsonObject json = Json.createReader((Reader)new StringReader(content)).readObject();
        String deviceId = json.getString("DeviceId");
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, deviceId);
        if (deviceSession == null) {
            this.sendResponse(channel, HttpResponseStatus.BAD_REQUEST);
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.set("type", json.getInt("PacketType"));
        position.set("index", json.getInt("SeqNumber"));
        position.setDeviceTime(this.dateFormat.parse(json.getString("UpdateDate")));
        int alert = json.getInt("Alert");
        if (alert > 0) {
            position.set("alert", alert);
            String alertMessage = json.getString("AlertMessage");
            if (!alertMessage.isEmpty()) {
                position.set("alertMessage", alertMessage);
            }
        }
        if (json.containsKey((Object)"GpsEvent")) {
            position.set("gpsEvent", json.getInt("GpsEvent"));
            if (json.containsKey((Object)"GpsEventText")) {
                position.set("gpsEventText", json.getString("GpsEventText"));
            }
        }
        if (json.containsKey((Object)"Event")) {
            position.set("event", json.getInt("Event"));
        }
        if (json.containsKey((Object)"BatteryPercentage")) {
            position.set("batteryLevel", json.getInt("BatteryPercentage"));
        }
        if (json.containsKey((Object)"Battery")) {
            position.set("battery", json.getJsonNumber("Battery").doubleValue());
        }
        position.set("deviceType", json.getString("DeviceTypeText"));
        if (json.containsKey((Object)"Latitude") && json.containsKey((Object)"Longitude")) {
            position.setValid(true);
            if (json.containsKey((Object)"LocationDateTime")) {
                position.setFixTime(this.dateFormat.parse(json.getString("LocationDateTime")));
            } else {
                position.setFixTime(position.getDeviceTime());
            }
            position.setLatitude(json.getJsonNumber("Latitude").doubleValue());
            position.setLongitude(json.getJsonNumber("Longitude").doubleValue());
        } else {
            this.getLastLocation(position, position.getDeviceTime());
        }
        this.sendResponse(channel, HttpResponseStatus.OK, Unpooled.copiedBuffer((CharSequence)"{\"CaseID\":1,\"EventID\":1}", (Charset)StandardCharsets.UTF_8));
        return position;
    }
}

