/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.base.Preconditions;
import io.grpc.ConnectivityState;
import io.grpc.LoadBalancer;
import io.grpc.Status;
import io.grpc.util.ForwardingLoadBalancer;

final class LazyLoadBalancer
extends ForwardingLoadBalancer {
    private LoadBalancer delegate;

    public LazyLoadBalancer(LoadBalancer.Helper helper, LoadBalancer.Factory delegateFactory) {
        this.delegate = new LazyDelegate(helper, delegateFactory);
    }

    protected LoadBalancer delegate() {
        return this.delegate;
    }

    public Status acceptResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        return this.delegate.acceptResolvedAddresses(resolvedAddresses);
    }

    public static final class Factory
    extends LoadBalancer.Factory {
        private final LoadBalancer.Factory delegate;

        public Factory(LoadBalancer.Factory delegate) {
            this.delegate = (LoadBalancer.Factory)Preconditions.checkNotNull((Object)delegate, (Object)"delegate");
        }

        public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
            return new LazyLoadBalancer(helper, this.delegate);
        }
    }

    private final class LazyDelegate
    extends LoadBalancer {
        private final LoadBalancer.Helper helper;
        private final LoadBalancer.Factory delegateFactory;
        private LoadBalancer.ResolvedAddresses addresses;
        private Status error;
        private boolean updatedBalancingState;

        public LazyDelegate(LoadBalancer.Helper helper, LoadBalancer.Factory delegateFactory) {
            this.helper = (LoadBalancer.Helper)Preconditions.checkNotNull((Object)helper, (Object)"helper");
            this.delegateFactory = (LoadBalancer.Factory)Preconditions.checkNotNull((Object)delegateFactory, (Object)"delegateFactory");
        }

        private LoadBalancer activate() {
            if (LazyLoadBalancer.this.delegate != this) {
                return LazyLoadBalancer.this.delegate;
            }
            LazyLoadBalancer.this.delegate = this.delegateFactory.newLoadBalancer(this.helper);
            if (this.addresses != null) {
                LazyLoadBalancer.this.delegate.acceptResolvedAddresses(this.addresses);
            }
            if (this.error != null) {
                LazyLoadBalancer.this.delegate.handleNameResolutionError(this.error);
            }
            return LazyLoadBalancer.this.delegate;
        }

        public Status acceptResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
            this.addresses = resolvedAddresses;
            this.error = null;
            this.initializeBalancingState();
            return Status.OK;
        }

        public void handleNameResolutionError(Status error) {
            this.error = error;
            this.initializeBalancingState();
        }

        private void initializeBalancingState() {
            if (this.updatedBalancingState) {
                return;
            }
            this.helper.updateBalancingState(ConnectivityState.IDLE, (LoadBalancer.SubchannelPicker)new LazyPicker());
            this.updatedBalancingState = true;
        }

        public void requestConnection() {
            this.activate().requestConnection();
        }

        public void shutdown() {
        }

        private final class LazyPicker
        extends LoadBalancer.SubchannelPicker {
            private LazyPicker() {
            }

            public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
                LazyDelegate.this.helper.getSynchronizationContext().execute(() -> LazyDelegate.this.activate());
                return LoadBalancer.PickResult.withNoResult();
            }

            public void requestConnection() {
                LazyDelegate.this.helper.getSynchronizationContext().execute(LazyDelegate.this::requestConnection);
            }
        }
    }
}

