/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.EnumMap;
import java.util.Map;
import org.apache.kafka.common.message.BrokerHeartbeatResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractResponse;

public class BrokerHeartbeatResponse
extends AbstractResponse {
    private final BrokerHeartbeatResponseData data;

    public BrokerHeartbeatResponse(BrokerHeartbeatResponseData data) {
        super(ApiKeys.BROKER_HEARTBEAT);
        this.data = data;
    }

    @Override
    public BrokerHeartbeatResponseData data() {
        return this.data;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        EnumMap<Errors, Integer> errorCounts = new EnumMap<Errors, Integer>(Errors.class);
        errorCounts.put(Errors.forCode(this.data.errorCode()), 1);
        return errorCounts;
    }

    public static BrokerHeartbeatResponse parse(Readable readable, short version) {
        return new BrokerHeartbeatResponse(new BrokerHeartbeatResponseData(readable, version));
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return true;
    }
}

