/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import org.apache.kafka.common.message.ListConfigResourcesResponseData;
import org.apache.kafka.common.protocol.MessageUtil;

public class ListConfigResourcesResponseDataJsonConverter {
    public static ListConfigResourcesResponseData read(JsonNode _node, short _version) {
        ListConfigResourcesResponseData _object = new ListConfigResourcesResponseData();
        JsonNode _throttleTimeMsNode = _node.get("throttleTimeMs");
        if (_throttleTimeMsNode == null) {
            throw new RuntimeException("ListConfigResourcesResponseData: unable to locate field 'throttleTimeMs', which is mandatory in version " + _version);
        }
        _object.throttleTimeMs = MessageUtil.jsonNodeToInt(_throttleTimeMsNode, "ListConfigResourcesResponseData");
        JsonNode _errorCodeNode = _node.get("errorCode");
        if (_errorCodeNode == null) {
            throw new RuntimeException("ListConfigResourcesResponseData: unable to locate field 'errorCode', which is mandatory in version " + _version);
        }
        _object.errorCode = MessageUtil.jsonNodeToShort(_errorCodeNode, "ListConfigResourcesResponseData");
        JsonNode _configResourcesNode = _node.get("configResources");
        if (_configResourcesNode == null) {
            throw new RuntimeException("ListConfigResourcesResponseData: unable to locate field 'configResources', which is mandatory in version " + _version);
        }
        if (!_configResourcesNode.isArray()) {
            throw new RuntimeException("ListConfigResourcesResponseData expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
        }
        ArrayList<ListConfigResourcesResponseData.ConfigResource> _collection = new ArrayList<ListConfigResourcesResponseData.ConfigResource>(_configResourcesNode.size());
        _object.configResources = _collection;
        for (JsonNode _element : _configResourcesNode) {
            _collection.add(ConfigResourceJsonConverter.read(_element, _version));
        }
        return _object;
    }

    public static JsonNode write(ListConfigResourcesResponseData _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("throttleTimeMs", (JsonNode)new IntNode(_object.throttleTimeMs));
        _node.set("errorCode", (JsonNode)new ShortNode(_object.errorCode));
        ArrayNode _configResourcesArray = new ArrayNode(JsonNodeFactory.instance);
        for (ListConfigResourcesResponseData.ConfigResource _element : _object.configResources) {
            _configResourcesArray.add(ConfigResourceJsonConverter.write(_element, _version, _serializeRecords));
        }
        _node.set("configResources", (JsonNode)_configResourcesArray);
        return _node;
    }

    public static JsonNode write(ListConfigResourcesResponseData _object, short _version) {
        return ListConfigResourcesResponseDataJsonConverter.write(_object, _version, true);
    }

    public static class ConfigResourceJsonConverter {
        public static ListConfigResourcesResponseData.ConfigResource read(JsonNode _node, short _version) {
            ListConfigResourcesResponseData.ConfigResource _object = new ListConfigResourcesResponseData.ConfigResource();
            JsonNode _resourceNameNode = _node.get("resourceName");
            if (_resourceNameNode == null) {
                throw new RuntimeException("ConfigResource: unable to locate field 'resourceName', which is mandatory in version " + _version);
            }
            if (!_resourceNameNode.isTextual()) {
                throw new RuntimeException("ConfigResource expected a string type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.resourceName = _resourceNameNode.asText();
            JsonNode _resourceTypeNode = _node.get("resourceType");
            if (_resourceTypeNode == null) {
                if (_version >= 1) {
                    throw new RuntimeException("ConfigResource: unable to locate field 'resourceType', which is mandatory in version " + _version);
                }
                _object.resourceType = (byte)16;
            } else {
                _object.resourceType = MessageUtil.jsonNodeToByte(_resourceTypeNode, "ConfigResource");
            }
            return _object;
        }

        public static JsonNode write(ListConfigResourcesResponseData.ConfigResource _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("resourceName", (JsonNode)new TextNode(_object.resourceName));
            if (_version >= 1) {
                _node.set("resourceType", (JsonNode)new ShortNode((short)_object.resourceType));
            }
            return _node;
        }

        public static JsonNode write(ListConfigResourcesResponseData.ConfigResource _object, short _version) {
            return ConfigResourceJsonConverter.write(_object, _version, true);
        }
    }
}

