/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.clients.ClientDnsLookup;
import org.apache.kafka.clients.CommonClientConfigs;
import org.apache.kafka.clients.MetadataRecoveryStrategy;
import org.apache.kafka.clients.consumer.CooperativeStickyAssignor;
import org.apache.kafka.clients.consumer.GroupProtocol;
import org.apache.kafka.clients.consumer.RangeAssignor;
import org.apache.kafka.clients.consumer.internals.AutoOffsetResetStrategy;
import org.apache.kafka.clients.consumer.internals.ShareAcknowledgementMode;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.requests.JoinGroupRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.utils.Utils;

public class ConsumerConfig
extends AbstractConfig {
    private static final ConfigDef CONFIG;
    public static final List<String> ASSIGN_FROM_SUBSCRIBED_ASSIGNORS;
    public static final String GROUP_ID_CONFIG = "group.id";
    private static final String GROUP_ID_DOC = "A unique string that identifies the consumer group this consumer belongs to. This property is required if the consumer uses either the group management functionality by using <code>subscribe(topic)</code> or the Kafka-based offset management strategy.";
    public static final String GROUP_INSTANCE_ID_CONFIG = "group.instance.id";
    private static final String GROUP_INSTANCE_ID_DOC = "A unique identifier of the consumer instance provided by the end user. Only non-empty strings are permitted. If set, the consumer is treated as a static member, which means that only one instance with this ID is allowed in the consumer group at any time. This can be used in combination with a larger session timeout to avoid group rebalances caused by transient unavailability (e.g. process restarts). If not set, the consumer will join the group as a dynamic member, which is the traditional behavior.";
    public static final String MAX_POLL_RECORDS_CONFIG = "max.poll.records";
    private static final String MAX_POLL_RECORDS_DOC = "The maximum number of records returned in a single call to poll(). Note, that <code>max.poll.records</code> does not impact the underlying fetching behavior. The consumer will cache the records from each fetch request and returns them incrementally from each poll.";
    public static final int DEFAULT_MAX_POLL_RECORDS = 500;
    public static final String MAX_POLL_INTERVAL_MS_CONFIG = "max.poll.interval.ms";
    private static final String MAX_POLL_INTERVAL_MS_DOC = "The maximum delay between invocations of poll() when using consumer group management. This places an upper bound on the amount of time that the consumer can be idle before fetching more records. If poll() is not called before expiration of this timeout, then the consumer is considered failed and the group will rebalance in order to reassign the partitions to another member. For consumers using a non-null <code>group.instance.id</code> which reach this timeout, partitions will not be immediately reassigned. Instead, the consumer will stop sending heartbeats and partitions will be reassigned after expiration of the session timeout (defined by the client config <code>session.timeout.ms</code> if using the Classic rebalance protocol, or by the broker config <code>group.consumer.session.timeout.ms</code> if using the Consumer protocol). This mirrors the behavior of a static consumer which has shutdown.";
    public static final String SESSION_TIMEOUT_MS_CONFIG = "session.timeout.ms";
    private static final String SESSION_TIMEOUT_MS_DOC = "The timeout used to detect client failures when using Kafka's group management facility. The client sends periodic heartbeats to indicate its liveness to the broker. If no heartbeats are received by the broker before the expiration of this session timeout, then the broker will remove this client from the group and initiate a rebalance. Note that the value must be in the allowable range as configured in the broker configuration by <code>group.min.session.timeout.ms</code> and <code>group.max.session.timeout.ms</code>. Note that this client configuration is not supported when <code>group.protocol</code> is set to \"consumer\". In that case, session timeout is controlled by the broker config <code>group.consumer.session.timeout.ms</code>.";
    public static final String HEARTBEAT_INTERVAL_MS_CONFIG = "heartbeat.interval.ms";
    private static final String HEARTBEAT_INTERVAL_MS_DOC = "The expected time between heartbeats to the consumer coordinator when using Kafka's group management facilities. Heartbeats are used to ensure that the consumer's session stays active and to facilitate rebalancing when new consumers join or leave the group. This config is only supported if <code>group.protocol</code> is set to \"classic\". In that case, the value must be set lower than <code>session.timeout.ms</code>, but typically should be set no higher than 1/3 of that value. It can be adjusted even lower to control the expected time for normal rebalances.If <code>group.protocol</code> is set to \"consumer\", this config is not supported, as the heartbeat interval is controlled by the broker with <code>group.consumer.heartbeat.interval.ms</code>.";
    public static final String GROUP_PROTOCOL_CONFIG = "group.protocol";
    public static final String DEFAULT_GROUP_PROTOCOL;
    public static final String GROUP_PROTOCOL_DOC = "The group protocol consumer should use. We currently support \"classic\" or \"consumer\". If \"consumer\" is specified, then the consumer group protocol will be used. Otherwise, the classic group protocol will be used.";
    public static final String GROUP_REMOTE_ASSIGNOR_CONFIG = "group.remote.assignor";
    public static final String DEFAULT_GROUP_REMOTE_ASSIGNOR;
    public static final String GROUP_REMOTE_ASSIGNOR_DOC = "The name of the server-side assignor to use. If not specified, the group coordinator will pick the first assignor defined in the broker config group.consumer.assignors.This configuration is applied only if <code>group.protocol</code> is set to \"consumer\".";
    public static final String BOOTSTRAP_SERVERS_CONFIG = "bootstrap.servers";
    public static final String CLIENT_DNS_LOOKUP_CONFIG = "client.dns.lookup";
    public static final String ENABLE_AUTO_COMMIT_CONFIG = "enable.auto.commit";
    private static final String ENABLE_AUTO_COMMIT_DOC = "If true the consumer's offset will be periodically committed in the background.";
    public static final String AUTO_COMMIT_INTERVAL_MS_CONFIG = "auto.commit.interval.ms";
    private static final String AUTO_COMMIT_INTERVAL_MS_DOC = "The frequency in milliseconds that the consumer offsets are auto-committed to Kafka if <code>enable.auto.commit</code> is set to <code>true</code>.";
    public static final String PARTITION_ASSIGNMENT_STRATEGY_CONFIG = "partition.assignment.strategy";
    private static final String PARTITION_ASSIGNMENT_STRATEGY_DOC = "A list of class names or class types, ordered by preference, of supported partition assignment strategies that the client will use to distribute partition ownership amongst consumer instances when group management is used. Available options are:<ul><li><code>org.apache.kafka.clients.consumer.RangeAssignor</code>: Assigns partitions on a per-topic basis.</li><li><code>org.apache.kafka.clients.consumer.RoundRobinAssignor</code>: Assigns partitions to consumers in a round-robin fashion.</li><li><code>org.apache.kafka.clients.consumer.StickyAssignor</code>: Guarantees an assignment that is maximally balanced while preserving as many existing partition assignments as possible.</li><li><code>org.apache.kafka.clients.consumer.CooperativeStickyAssignor</code>: Follows the same StickyAssignor logic, but allows for cooperative rebalancing.</li></ul><p>The default assignor is [RangeAssignor, CooperativeStickyAssignor], which will use the RangeAssignor by default, but allows upgrading to the CooperativeStickyAssignor with just a single rolling bounce that removes the RangeAssignor from the list.</p><p>Implementing the <code>org.apache.kafka.clients.consumer.ConsumerPartitionAssignor</code> interface allows you to plug in a custom assignment strategy.</p>";
    public static final String AUTO_OFFSET_RESET_CONFIG = "auto.offset.reset";
    public static final String AUTO_OFFSET_RESET_DOC = "What to do when there is no initial offset in Kafka or if the current offset does not exist any more on the server (e.g. because that data has been deleted): <ul><li>earliest: automatically reset the offset to the earliest offset</li><li>latest: automatically reset the offset to the latest offset</li><li>by_duration:&lt;duration&gt;: automatically reset the offset to a configured &lt;duration&gt; from the current timestamp. &lt;duration&gt; must be specified in ISO8601 format (PnDTnHnMn.nS). Negative duration is not allowed.</li><li>none: throw exception to the consumer if no previous offset is found for the consumer's group</li><li>anything else: throw exception to the consumer.</li></ul><p>Note that altering partition numbers while setting this config to latest may cause message delivery loss since producers could start to send messages to newly added partitions (i.e. no initial offsets exist yet) before consumers reset their offsets.";
    public static final String FETCH_MIN_BYTES_CONFIG = "fetch.min.bytes";
    public static final int DEFAULT_FETCH_MIN_BYTES = 1;
    private static final String FETCH_MIN_BYTES_DOC = "The minimum amount of data the server should return for a fetch request. If insufficient data is available the request will wait for that much data to accumulate before answering the request. The default setting of 1 byte means that fetch requests are answered as soon as that many byte(s) of data is available or the fetch request times out waiting for data to arrive. Setting this to a larger value will cause the server to wait for larger amounts of data to accumulate which can improve server throughput a bit at the cost of some additional latency.";
    public static final String FETCH_MAX_BYTES_CONFIG = "fetch.max.bytes";
    private static final String FETCH_MAX_BYTES_DOC = "The maximum amount of data the server should return for a fetch request. Records are fetched in batches by the consumer, and if the first record batch in the first non-empty partition of the fetch is larger than this value, the record batch will still be returned to ensure that the consumer can make progress. As such, this is not a absolute maximum. The maximum record batch size accepted by the broker is defined via <code>message.max.bytes</code> (broker config) or <code>max.message.bytes</code> (topic config). A fetch request consists of many partitions, and there is another setting that controls how much data is returned for each partition in a fetch request - see <code>max.partition.fetch.bytes</code>. Note that there is a current limitation when performing remote reads from tiered storage (KIP-405) - only one partition out of the fetch request is fetched from the remote store (KAFKA-14915). Note also that the consumer performs multiple fetches in parallel.";
    public static final int DEFAULT_FETCH_MAX_BYTES = 0x3200000;
    public static final String FETCH_MAX_WAIT_MS_CONFIG = "fetch.max.wait.ms";
    private static final String FETCH_MAX_WAIT_MS_DOC = "The maximum amount of time the server will block before answering the fetch request there isn't sufficient data to immediately satisfy the requirement given by fetch.min.bytes. This config is used only for local log fetch. To tune the remote fetch maximum wait time, please refer to 'remote.fetch.max.wait.ms' broker config";
    public static final int DEFAULT_FETCH_MAX_WAIT_MS = 500;
    public static final String METADATA_MAX_AGE_CONFIG = "metadata.max.age.ms";
    public static final String MAX_PARTITION_FETCH_BYTES_CONFIG = "max.partition.fetch.bytes";
    private static final String MAX_PARTITION_FETCH_BYTES_DOC = "The maximum amount of data per-partition the server will return. Records are fetched in batches by the consumer. If the first record batch in the first non-empty partition of the fetch is larger than this limit, the batch will still be returned to ensure that the consumer can make progress. The maximum record batch size accepted by the broker is defined via <code>message.max.bytes</code> (broker config) or <code>max.message.bytes</code> (topic config). See fetch.max.bytes for limiting the consumer request size. Consider increasing <code>max.partition.fetch.bytes</code> especially in the cases of remote storage reads (KIP-405), because currently only one partition per fetch request is served from the remote store (KAFKA-14915).";
    public static final int DEFAULT_MAX_PARTITION_FETCH_BYTES = 0x100000;
    public static final String SEND_BUFFER_CONFIG = "send.buffer.bytes";
    public static final String RECEIVE_BUFFER_CONFIG = "receive.buffer.bytes";
    public static final String CLIENT_ID_CONFIG = "client.id";
    public static final String CLIENT_RACK_CONFIG = "client.rack";
    public static final String DEFAULT_CLIENT_RACK = "";
    public static final String RECONNECT_BACKOFF_MS_CONFIG = "reconnect.backoff.ms";
    public static final String RECONNECT_BACKOFF_MAX_MS_CONFIG = "reconnect.backoff.max.ms";
    public static final String RETRY_BACKOFF_MS_CONFIG = "retry.backoff.ms";
    public static final String ENABLE_METRICS_PUSH_CONFIG = "enable.metrics.push";
    public static final String ENABLE_METRICS_PUSH_DOC = "Whether to enable pushing of client metrics to the cluster, if the cluster has a client metrics subscription which matches this client.";
    public static final String RETRY_BACKOFF_MAX_MS_CONFIG = "retry.backoff.max.ms";
    public static final String METRICS_SAMPLE_WINDOW_MS_CONFIG = "metrics.sample.window.ms";
    public static final String METRICS_NUM_SAMPLES_CONFIG = "metrics.num.samples";
    public static final String METRICS_RECORDING_LEVEL_CONFIG = "metrics.recording.level";
    public static final String METRIC_REPORTER_CLASSES_CONFIG = "metric.reporters";
    public static final String CHECK_CRCS_CONFIG = "check.crcs";
    private static final String CHECK_CRCS_DOC = "Automatically check the CRC32 of the records consumed. This ensures no on-the-wire or on-disk corruption to the messages occurred. This check adds some overhead, so it may be disabled in cases seeking extreme performance.";
    public static final String KEY_DESERIALIZER_CLASS_CONFIG = "key.deserializer";
    public static final String KEY_DESERIALIZER_CLASS_DOC = "Deserializer class for key that implements the <code>org.apache.kafka.common.serialization.Deserializer</code> interface.";
    public static final String VALUE_DESERIALIZER_CLASS_CONFIG = "value.deserializer";
    public static final String VALUE_DESERIALIZER_CLASS_DOC = "Deserializer class for value that implements the <code>org.apache.kafka.common.serialization.Deserializer</code> interface.";
    public static final String SOCKET_CONNECTION_SETUP_TIMEOUT_MS_CONFIG = "socket.connection.setup.timeout.ms";
    public static final String SOCKET_CONNECTION_SETUP_TIMEOUT_MAX_MS_CONFIG = "socket.connection.setup.timeout.max.ms";
    public static final String CONNECTIONS_MAX_IDLE_MS_CONFIG = "connections.max.idle.ms";
    public static final String REQUEST_TIMEOUT_MS_CONFIG = "request.timeout.ms";
    private static final String REQUEST_TIMEOUT_MS_DOC = "The configuration controls the maximum amount of time the client will wait for the response of a request. If the response is not received before the timeout elapses the client will resend the request if necessary or fail the request if retries are exhausted.";
    public static final String DEFAULT_API_TIMEOUT_MS_CONFIG = "default.api.timeout.ms";
    public static final String INTERCEPTOR_CLASSES_CONFIG = "interceptor.classes";
    public static final String INTERCEPTOR_CLASSES_DOC = "A list of classes to use as interceptors. Implementing the <code>org.apache.kafka.clients.consumer.ConsumerInterceptor</code> interface allows you to intercept (and possibly mutate) records received by the consumer. By default, there are no interceptors.";
    public static final String EXCLUDE_INTERNAL_TOPICS_CONFIG = "exclude.internal.topics";
    private static final String EXCLUDE_INTERNAL_TOPICS_DOC = "Whether internal topics matching a subscribed pattern should be excluded from the subscription. It is always possible to explicitly subscribe to an internal topic.";
    public static final boolean DEFAULT_EXCLUDE_INTERNAL_TOPICS = true;
    static final String LEAVE_GROUP_ON_CLOSE_CONFIG = "internal.leave.group.on.close";
    static final String THROW_ON_FETCH_STABLE_OFFSET_UNSUPPORTED = "internal.throw.on.fetch.stable.offset.unsupported";
    public static final String ISOLATION_LEVEL_CONFIG = "isolation.level";
    public static final String ISOLATION_LEVEL_DOC = "Controls how to read messages written transactionally. If set to <code>read_committed</code>, consumer.poll() will only return transactional messages which have been committed. If set to <code>read_uncommitted</code> (the default), consumer.poll() will return all messages, even transactional messages which have been aborted. Non-transactional messages will be returned unconditionally in either mode. <p>Messages will always be returned in offset order. Hence, in  <code>read_committed</code> mode, consumer.poll() will only return messages up to the last stable offset (LSO), which is the one less than the offset of the first open transaction. In particular any messages appearing after messages belonging to ongoing transactions will be withheld until the relevant transaction has been completed. As a result, <code>read_committed</code> consumers will not be able to read up to the high watermark when there are in flight transactions.</p><p> Further, when in <code>read_committed</code> the seekToEnd method will return the LSO</p>";
    public static final String DEFAULT_ISOLATION_LEVEL;
    public static final String ALLOW_AUTO_CREATE_TOPICS_CONFIG = "allow.auto.create.topics";
    private static final String ALLOW_AUTO_CREATE_TOPICS_DOC = "Allow automatic topic creation on the broker when subscribing to or assigning a topic. A topic being subscribed to will be automatically created only if the broker allows for it using `auto.create.topics.enable` broker configuration.";
    public static final boolean DEFAULT_ALLOW_AUTO_CREATE_TOPICS = true;
    public static final String SECURITY_PROVIDERS_CONFIG = "security.providers";
    private static final String SECURITY_PROVIDERS_DOC = "A list of configurable creator classes each returning a provider implementing security algorithms. These classes should implement the <code>org.apache.kafka.common.security.auth.SecurityProviderCreator</code> interface.";
    public static final String SHARE_ACKNOWLEDGEMENT_MODE_CONFIG = "share.acknowledgement.mode";
    private static final String SHARE_ACKNOWLEDGEMENT_MODE_DOC = "Controls the acknowledgement mode for a share consumer. If set to <code>implicit</code>, the acknowledgement mode of the consumer is implicit and it must not use <code>org.apache.kafka.clients.consumer.ShareConsumer.acknowledge()</code> to acknowledge delivery of records. Instead, delivery is acknowledged implicitly on the next call to poll or commit. If set to <code>explicit</code>, the acknowledgement mode of the consumer is explicit and it must use <code>org.apache.kafka.clients.consumer.ShareConsumer.acknowledge()</code> to acknowledge delivery of records.";
    private static final AtomicInteger CONSUMER_CLIENT_ID_SEQUENCE;
    private static final List<String> CLASSIC_PROTOCOL_UNSUPPORTED_CONFIGS;
    private static final List<String> CONSUMER_PROTOCOL_UNSUPPORTED_CONFIGS;

    @Override
    protected Map<String, Object> postProcessParsedConfig(Map<String, Object> parsedValues) {
        CommonClientConfigs.postValidateSaslMechanismConfig(this);
        CommonClientConfigs.warnDisablingExponentialBackoff(this);
        Map<String, Object> refinedConfigs = CommonClientConfigs.postProcessReconnectBackoffConfigs(this, parsedValues);
        this.maybeOverrideClientId(refinedConfigs);
        this.maybeOverrideEnableAutoCommit(refinedConfigs);
        this.checkUnsupportedConfigsPostProcess();
        return refinedConfigs;
    }

    private void maybeOverrideClientId(Map<String, Object> configs) {
        String clientId = this.getString(CLIENT_ID_CONFIG);
        if (clientId == null || clientId.isEmpty()) {
            String groupId = this.getString(GROUP_ID_CONFIG);
            String groupInstanceId = this.getString(GROUP_INSTANCE_ID_CONFIG);
            if (groupInstanceId != null) {
                JoinGroupRequest.validateGroupInstanceId(groupInstanceId);
            }
            String groupInstanceIdPart = groupInstanceId != null ? groupInstanceId : DEFAULT_CLIENT_RACK + CONSUMER_CLIENT_ID_SEQUENCE.getAndIncrement();
            String generatedClientId = String.format("consumer-%s-%s", groupId, groupInstanceIdPart);
            configs.put(CLIENT_ID_CONFIG, generatedClientId);
        }
    }

    public static Map<String, Object> appendDeserializerToConfig(Map<String, Object> configs, Deserializer<?> keyDeserializer, Deserializer<?> valueDeserializer) {
        HashMap<String, Object> newConfigs = new HashMap<String, Object>(configs);
        if (keyDeserializer != null) {
            newConfigs.put(KEY_DESERIALIZER_CLASS_CONFIG, keyDeserializer.getClass());
        } else if (newConfigs.get(KEY_DESERIALIZER_CLASS_CONFIG) == null) {
            throw new ConfigException(KEY_DESERIALIZER_CLASS_CONFIG, null, "must be non-null.");
        }
        if (valueDeserializer != null) {
            newConfigs.put(VALUE_DESERIALIZER_CLASS_CONFIG, valueDeserializer.getClass());
        } else if (newConfigs.get(VALUE_DESERIALIZER_CLASS_CONFIG) == null) {
            throw new ConfigException(VALUE_DESERIALIZER_CLASS_CONFIG, null, "must be non-null.");
        }
        return newConfigs;
    }

    private void maybeOverrideEnableAutoCommit(Map<String, Object> configs) {
        boolean enableAutoCommit;
        Optional<String> groupId = Optional.ofNullable(this.getString(GROUP_ID_CONFIG));
        Map<String, Object> originals = this.originals();
        boolean bl = enableAutoCommit = originals.containsKey(ENABLE_AUTO_COMMIT_CONFIG) ? this.getBoolean(ENABLE_AUTO_COMMIT_CONFIG) : false;
        if (groupId.isEmpty()) {
            if (!originals.containsKey(ENABLE_AUTO_COMMIT_CONFIG)) {
                configs.put(ENABLE_AUTO_COMMIT_CONFIG, false);
            } else if (enableAutoCommit) {
                throw new InvalidConfigurationException("enable.auto.commit cannot be set to true when default group id (null) is used.");
            }
        }
    }

    protected void checkUnsupportedConfigsPostProcess() {
        String groupProtocol = this.getString(GROUP_PROTOCOL_CONFIG);
        if (GroupProtocol.CLASSIC.name().equalsIgnoreCase(groupProtocol)) {
            this.checkUnsupportedConfigsPostProcess(GroupProtocol.CLASSIC, CLASSIC_PROTOCOL_UNSUPPORTED_CONFIGS);
        } else if (GroupProtocol.CONSUMER.name().equalsIgnoreCase(groupProtocol)) {
            this.checkUnsupportedConfigsPostProcess(GroupProtocol.CONSUMER, CONSUMER_PROTOCOL_UNSUPPORTED_CONFIGS);
        }
    }

    private void checkUnsupportedConfigsPostProcess(GroupProtocol groupProtocol, List<String> unsupportedConfigs) {
        if (this.getString(GROUP_PROTOCOL_CONFIG).equalsIgnoreCase(groupProtocol.name())) {
            ArrayList invalidConfigs = new ArrayList();
            unsupportedConfigs.forEach(configName -> {
                Object config = this.originals().get(configName);
                if (config != null && !Utils.isBlank(config.toString())) {
                    invalidConfigs.add(configName);
                }
            });
            if (!invalidConfigs.isEmpty()) {
                throw new ConfigException(String.join((CharSequence)", ", invalidConfigs) + " cannot be set when group.protocol=" + groupProtocol.name());
            }
        }
    }

    public ConsumerConfig(Properties props) {
        super(CONFIG, props);
    }

    public ConsumerConfig(Map<String, Object> props) {
        super(CONFIG, props);
    }

    protected ConsumerConfig(Map<?, ?> props, boolean doLog) {
        super(CONFIG, props, doLog);
    }

    public static Set<String> configNames() {
        return CONFIG.names();
    }

    public static ConfigDef configDef() {
        return new ConfigDef(CONFIG);
    }

    public static void main(String[] args) {
        System.out.println(CONFIG.toHtml(4, config -> "consumerconfigs_" + config));
    }

    static {
        ASSIGN_FROM_SUBSCRIBED_ASSIGNORS = List.of("range", "roundrobin", "sticky", "cooperative-sticky");
        DEFAULT_GROUP_PROTOCOL = GroupProtocol.CLASSIC.name().toLowerCase(Locale.ROOT);
        DEFAULT_GROUP_REMOTE_ASSIGNOR = null;
        DEFAULT_ISOLATION_LEVEL = IsolationLevel.READ_UNCOMMITTED.toString();
        CONSUMER_CLIENT_ID_SEQUENCE = new AtomicInteger(1);
        CLASSIC_PROTOCOL_UNSUPPORTED_CONFIGS = List.of(GROUP_REMOTE_ASSIGNOR_CONFIG, SHARE_ACKNOWLEDGEMENT_MODE_CONFIG);
        CONSUMER_PROTOCOL_UNSUPPORTED_CONFIGS = List.of(PARTITION_ASSIGNMENT_STRATEGY_CONFIG, HEARTBEAT_INTERVAL_MS_CONFIG, SESSION_TIMEOUT_MS_CONFIG, SHARE_ACKNOWLEDGEMENT_MODE_CONFIG);
        CONFIG = new ConfigDef().define(BOOTSTRAP_SERVERS_CONFIG, ConfigDef.Type.LIST, Collections.emptyList(), new ConfigDef.NonNullValidator(), ConfigDef.Importance.HIGH, "A list of host/port pairs used to establish the initial connection to the Kafka cluster. Clients use this list to bootstrap and discover the full set of Kafka brokers. While the order of servers in the list does not matter, we recommend including more than one server to ensure resilience if any servers are down. This list does not need to contain the entire set of brokers, as Kafka clients automatically manage and update connections to the cluster efficiently. This list must be in the form <code>host1:port1,host2:port2,...</code>.").define(CLIENT_DNS_LOOKUP_CONFIG, ConfigDef.Type.STRING, (Object)ClientDnsLookup.USE_ALL_DNS_IPS.toString(), ConfigDef.ValidString.in(ClientDnsLookup.USE_ALL_DNS_IPS.toString(), ClientDnsLookup.RESOLVE_CANONICAL_BOOTSTRAP_SERVERS_ONLY.toString()), ConfigDef.Importance.MEDIUM, "Controls how the client uses DNS lookups. If set to <code>use_all_dns_ips</code>, connect to each returned IP address in sequence until a successful connection is established. After a disconnection, the next IP is used. Once all IPs have been used once, the client resolves the IP(s) from the hostname again (both the JVM and the OS cache DNS name lookups, however). If set to <code>resolve_canonical_bootstrap_servers_only</code>, resolve each bootstrap address into a list of canonical names. After the bootstrap phase, this behaves the same as <code>use_all_dns_ips</code>.").define(GROUP_ID_CONFIG, ConfigDef.Type.STRING, null, ConfigDef.Importance.HIGH, GROUP_ID_DOC).define(GROUP_INSTANCE_ID_CONFIG, ConfigDef.Type.STRING, null, new ConfigDef.NonEmptyString(), ConfigDef.Importance.MEDIUM, GROUP_INSTANCE_ID_DOC).define(SESSION_TIMEOUT_MS_CONFIG, ConfigDef.Type.INT, 45000, ConfigDef.Importance.HIGH, SESSION_TIMEOUT_MS_DOC).define(HEARTBEAT_INTERVAL_MS_CONFIG, ConfigDef.Type.INT, 3000, ConfigDef.Importance.HIGH, HEARTBEAT_INTERVAL_MS_DOC).define(PARTITION_ASSIGNMENT_STRATEGY_CONFIG, ConfigDef.Type.LIST, List.of(RangeAssignor.class, CooperativeStickyAssignor.class), new ConfigDef.NonNullValidator(), ConfigDef.Importance.MEDIUM, PARTITION_ASSIGNMENT_STRATEGY_DOC).define(METADATA_MAX_AGE_CONFIG, ConfigDef.Type.LONG, (Object)300000, ConfigDef.Range.atLeast(0), ConfigDef.Importance.LOW, "The period of time in milliseconds after which we force a refresh of metadata even if we haven't seen any partition leadership changes to proactively discover any new brokers or partitions.").define(ENABLE_AUTO_COMMIT_CONFIG, ConfigDef.Type.BOOLEAN, true, ConfigDef.Importance.MEDIUM, ENABLE_AUTO_COMMIT_DOC).define(AUTO_COMMIT_INTERVAL_MS_CONFIG, ConfigDef.Type.INT, (Object)5000, ConfigDef.Range.atLeast(0), ConfigDef.Importance.LOW, AUTO_COMMIT_INTERVAL_MS_DOC).define(CLIENT_ID_CONFIG, ConfigDef.Type.STRING, DEFAULT_CLIENT_RACK, ConfigDef.Importance.LOW, "An id string to pass to the server when making requests. The purpose of this is to be able to track the source of requests beyond just ip/port by allowing a logical application name to be included in server-side request logging.").define(CLIENT_RACK_CONFIG, ConfigDef.Type.STRING, DEFAULT_CLIENT_RACK, ConfigDef.Importance.LOW, "A rack identifier for this client. This can be any string value which indicates where this client is physically located. It corresponds with the broker config 'broker.rack'").define(MAX_PARTITION_FETCH_BYTES_CONFIG, ConfigDef.Type.INT, (Object)0x100000, ConfigDef.Range.atLeast(0), ConfigDef.Importance.HIGH, MAX_PARTITION_FETCH_BYTES_DOC).define(SEND_BUFFER_CONFIG, ConfigDef.Type.INT, (Object)131072, ConfigDef.Range.atLeast(-1), ConfigDef.Importance.MEDIUM, "The size of the TCP send buffer (SO_SNDBUF) to use when sending data. If the value is -1, the OS default will be used.").define(RECEIVE_BUFFER_CONFIG, ConfigDef.Type.INT, (Object)65536, ConfigDef.Range.atLeast(-1), ConfigDef.Importance.MEDIUM, "The size of the TCP receive buffer (SO_RCVBUF) to use when reading data. If the value is -1, the OS default will be used.").define(FETCH_MIN_BYTES_CONFIG, ConfigDef.Type.INT, (Object)1, ConfigDef.Range.atLeast(0), ConfigDef.Importance.HIGH, FETCH_MIN_BYTES_DOC).define(FETCH_MAX_BYTES_CONFIG, ConfigDef.Type.INT, (Object)0x3200000, ConfigDef.Range.atLeast(0), ConfigDef.Importance.MEDIUM, FETCH_MAX_BYTES_DOC).define(FETCH_MAX_WAIT_MS_CONFIG, ConfigDef.Type.INT, (Object)500, ConfigDef.Range.atLeast(0), ConfigDef.Importance.LOW, FETCH_MAX_WAIT_MS_DOC).define(RECONNECT_BACKOFF_MS_CONFIG, ConfigDef.Type.LONG, (Object)50L, ConfigDef.Range.atLeast(0L), ConfigDef.Importance.LOW, "The base amount of time to wait before attempting to reconnect to a given host. This avoids repeatedly connecting to a host in a tight loop. This backoff applies to all connection attempts by the client to a broker. This value is the initial backoff value and will increase exponentially for each consecutive connection failure, up to the <code>reconnect.backoff.max.ms</code> value.").define(RECONNECT_BACKOFF_MAX_MS_CONFIG, ConfigDef.Type.LONG, (Object)1000L, ConfigDef.Range.atLeast(0L), ConfigDef.Importance.LOW, "The maximum amount of time in milliseconds to wait when reconnecting to a broker that has repeatedly failed to connect. If provided, the backoff per host will increase exponentially for each consecutive connection failure, up to this maximum. After calculating the backoff increase, 20% random jitter is added to avoid connection storms.").define(RETRY_BACKOFF_MS_CONFIG, ConfigDef.Type.LONG, (Object)CommonClientConfigs.DEFAULT_RETRY_BACKOFF_MS, ConfigDef.Range.atLeast(0L), ConfigDef.Importance.LOW, "The amount of time to wait before attempting to retry a failed request to a given topic partition. This avoids repeatedly sending requests in a tight loop under some failure scenarios. This value is the initial backoff value and will increase exponentially for each failed request, up to the <code>retry.backoff.max.ms</code> value.").define(RETRY_BACKOFF_MAX_MS_CONFIG, ConfigDef.Type.LONG, (Object)CommonClientConfigs.DEFAULT_RETRY_BACKOFF_MAX_MS, ConfigDef.Range.atLeast(0L), ConfigDef.Importance.LOW, "The maximum amount of time in milliseconds to wait when retrying a request to the broker that has repeatedly failed. If provided, the backoff per client will increase exponentially for each failed request, up to this maximum. To prevent all clients from being synchronized upon retry, a randomized jitter with a factor of 0.2 will be applied to the backoff, resulting in the backoff falling within a range between 20% below and 20% above the computed value. If <code>retry.backoff.ms</code> is set to be higher than <code>retry.backoff.max.ms</code>, then <code>retry.backoff.max.ms</code> will be used as a constant backoff from the beginning without any exponential increase").define(ENABLE_METRICS_PUSH_CONFIG, ConfigDef.Type.BOOLEAN, true, ConfigDef.Importance.LOW, ENABLE_METRICS_PUSH_DOC).define(AUTO_OFFSET_RESET_CONFIG, ConfigDef.Type.STRING, (Object)AutoOffsetResetStrategy.LATEST.name(), new AutoOffsetResetStrategy.Validator(), ConfigDef.Importance.MEDIUM, AUTO_OFFSET_RESET_DOC).define(CHECK_CRCS_CONFIG, ConfigDef.Type.BOOLEAN, true, ConfigDef.Importance.LOW, CHECK_CRCS_DOC).define(METRICS_SAMPLE_WINDOW_MS_CONFIG, ConfigDef.Type.LONG, (Object)30000, ConfigDef.Range.atLeast(0), ConfigDef.Importance.LOW, "The window of time a metrics sample is computed over.").define(METRICS_NUM_SAMPLES_CONFIG, ConfigDef.Type.INT, (Object)2, ConfigDef.Range.atLeast(1), ConfigDef.Importance.LOW, "The number of samples maintained to compute metrics.").define(METRICS_RECORDING_LEVEL_CONFIG, ConfigDef.Type.STRING, (Object)Sensor.RecordingLevel.INFO.toString(), ConfigDef.ValidString.in(Sensor.RecordingLevel.INFO.toString(), Sensor.RecordingLevel.DEBUG.toString(), Sensor.RecordingLevel.TRACE.toString()), ConfigDef.Importance.LOW, "The highest recording level for metrics. It has three levels for recording metrics - info, debug, and trace.\n \nINFO level records only essential metrics necessary for monitoring system performance and health. It collects vital data without gathering too much detail, making it suitable for production environments where minimal overhead is desired.\n\nDEBUG level records most metrics, providing more detailed information about the system's operation. It's useful for development and testing environments where you need deeper insights to debug and fine-tune the application.\n\nTRACE level records all possible metrics, capturing every detail about the system's performance and operation. It's best for controlled environments where in-depth analysis is required, though it can introduce significant overhead.").define(METRIC_REPORTER_CLASSES_CONFIG, ConfigDef.Type.LIST, (Object)JmxReporter.class.getName(), new ConfigDef.NonNullValidator(), ConfigDef.Importance.LOW, "A list of classes to use as metrics reporters. Implementing the <code>org.apache.kafka.common.metrics.MetricsReporter</code> interface allows plugging in classes that will be notified of new metric creation. When custom reporters are set and <code>org.apache.kafka.common.metrics.JmxReporter</code> is needed, it has to be explicitly added to the list.").define(KEY_DESERIALIZER_CLASS_CONFIG, ConfigDef.Type.CLASS, ConfigDef.Importance.HIGH, KEY_DESERIALIZER_CLASS_DOC).define(VALUE_DESERIALIZER_CLASS_CONFIG, ConfigDef.Type.CLASS, ConfigDef.Importance.HIGH, VALUE_DESERIALIZER_CLASS_DOC).define(REQUEST_TIMEOUT_MS_CONFIG, ConfigDef.Type.INT, (Object)30000, ConfigDef.Range.atLeast(0), ConfigDef.Importance.MEDIUM, REQUEST_TIMEOUT_MS_DOC).define(DEFAULT_API_TIMEOUT_MS_CONFIG, ConfigDef.Type.INT, (Object)60000, ConfigDef.Range.atLeast(0), ConfigDef.Importance.MEDIUM, "Specifies the timeout (in milliseconds) for client APIs. This configuration is used as the default timeout for all client operations that do not specify a <code>timeout</code> parameter.").define(SOCKET_CONNECTION_SETUP_TIMEOUT_MS_CONFIG, ConfigDef.Type.LONG, CommonClientConfigs.DEFAULT_SOCKET_CONNECTION_SETUP_TIMEOUT_MS, ConfigDef.Importance.MEDIUM, "The amount of time the client will wait for the socket connection to be established. If the connection is not built before the timeout elapses, clients will close the socket channel. This value is the initial backoff value and will increase exponentially for each consecutive connection failure, up to the <code>socket.connection.setup.timeout.max.ms</code> value.").define(SOCKET_CONNECTION_SETUP_TIMEOUT_MAX_MS_CONFIG, ConfigDef.Type.LONG, CommonClientConfigs.DEFAULT_SOCKET_CONNECTION_SETUP_TIMEOUT_MAX_MS, ConfigDef.Importance.MEDIUM, "The maximum amount of time the client will wait for the socket connection to be established. The connection setup timeout will increase exponentially for each consecutive connection failure up to this maximum. To avoid connection storms, a randomization factor of 0.2 will be applied to the timeout resulting in a random range between 20% below and 20% above the computed value.").define(CONNECTIONS_MAX_IDLE_MS_CONFIG, ConfigDef.Type.LONG, 540000, ConfigDef.Importance.MEDIUM, "Close idle connections after the number of milliseconds specified by this config.").define(INTERCEPTOR_CLASSES_CONFIG, ConfigDef.Type.LIST, Collections.emptyList(), new ConfigDef.NonNullValidator(), ConfigDef.Importance.LOW, INTERCEPTOR_CLASSES_DOC).define(MAX_POLL_RECORDS_CONFIG, ConfigDef.Type.INT, (Object)500, ConfigDef.Range.atLeast(1), ConfigDef.Importance.MEDIUM, MAX_POLL_RECORDS_DOC).define(MAX_POLL_INTERVAL_MS_CONFIG, ConfigDef.Type.INT, (Object)300000, ConfigDef.Range.atLeast(1), ConfigDef.Importance.MEDIUM, MAX_POLL_INTERVAL_MS_DOC).define(EXCLUDE_INTERNAL_TOPICS_CONFIG, ConfigDef.Type.BOOLEAN, true, ConfigDef.Importance.MEDIUM, EXCLUDE_INTERNAL_TOPICS_DOC).defineInternal(LEAVE_GROUP_ON_CLOSE_CONFIG, ConfigDef.Type.BOOLEAN, true, ConfigDef.Importance.LOW).defineInternal(THROW_ON_FETCH_STABLE_OFFSET_UNSUPPORTED, ConfigDef.Type.BOOLEAN, false, ConfigDef.Importance.LOW).define(ISOLATION_LEVEL_CONFIG, ConfigDef.Type.STRING, (Object)DEFAULT_ISOLATION_LEVEL, ConfigDef.ValidString.in(IsolationLevel.READ_COMMITTED.toString(), IsolationLevel.READ_UNCOMMITTED.toString()), ConfigDef.Importance.MEDIUM, ISOLATION_LEVEL_DOC).define(ALLOW_AUTO_CREATE_TOPICS_CONFIG, ConfigDef.Type.BOOLEAN, true, ConfigDef.Importance.MEDIUM, ALLOW_AUTO_CREATE_TOPICS_DOC).define(GROUP_PROTOCOL_CONFIG, ConfigDef.Type.STRING, (Object)DEFAULT_GROUP_PROTOCOL, ConfigDef.CaseInsensitiveValidString.in(Utils.enumOptions(GroupProtocol.class)), ConfigDef.Importance.HIGH, GROUP_PROTOCOL_DOC).define(GROUP_REMOTE_ASSIGNOR_CONFIG, ConfigDef.Type.STRING, DEFAULT_GROUP_REMOTE_ASSIGNOR, ConfigDef.Importance.MEDIUM, GROUP_REMOTE_ASSIGNOR_DOC).define(SECURITY_PROVIDERS_CONFIG, ConfigDef.Type.STRING, null, ConfigDef.Importance.LOW, SECURITY_PROVIDERS_DOC).define("security.protocol", ConfigDef.Type.STRING, (Object)"PLAINTEXT", ConfigDef.CaseInsensitiveValidString.in(Utils.enumOptions(SecurityProtocol.class)), ConfigDef.Importance.MEDIUM, "Protocol used to communicate with brokers.").withClientSslSupport().withClientSaslSupport().define("metadata.recovery.strategy", ConfigDef.Type.STRING, (Object)CommonClientConfigs.DEFAULT_METADATA_RECOVERY_STRATEGY, ConfigDef.CaseInsensitiveValidString.in(Utils.enumOptions(MetadataRecoveryStrategy.class)), ConfigDef.Importance.LOW, "Controls how the client recovers when none of the brokers known to it is available. If set to <code>none</code>, the client fails. If set to <code>rebootstrap</code>, the client repeats the bootstrap process using <code>bootstrap.servers</code>. Rebootstrapping is useful when a client communicates with brokers so infrequently that the set of brokers may change entirely before the client refreshes metadata. Metadata recovery is triggered when all last-known brokers appear unavailable simultaneously. Brokers appear unavailable when disconnected and no current retry attempt is in-progress. Consider increasing <code>reconnect.backoff.ms</code> and <code>reconnect.backoff.max.ms</code> and decreasing <code>socket.connection.setup.timeout.ms</code> and <code>socket.connection.setup.timeout.max.ms</code> for the client. Rebootstrap is also triggered if connection cannot be established to any of the brokers for <code>metadata.recovery.rebootstrap.trigger.ms</code> milliseconds or if server requests rebootstrap.").define("metadata.recovery.rebootstrap.trigger.ms", ConfigDef.Type.LONG, (Object)300000L, ConfigDef.Range.atLeast(0), ConfigDef.Importance.LOW, "If a client configured to rebootstrap using <code>metadata.recovery.strategy=rebootstrap</code> is unable to obtain metadata from any of the brokers in the last known metadata for this interval, client repeats the bootstrap process using <code>bootstrap.servers</code> configuration.").define(SHARE_ACKNOWLEDGEMENT_MODE_CONFIG, ConfigDef.Type.STRING, (Object)ShareAcknowledgementMode.IMPLICIT.name(), new ShareAcknowledgementMode.Validator(), ConfigDef.Importance.MEDIUM, SHARE_ACKNOWLEDGEMENT_MODE_DOC);
    }
}

