/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.reporting;

import dotty.tools.dotc.CompilationUnit;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Symbols;
import dotty.tools.dotc.reporting.Profile$;
import dotty.tools.dotc.reporting.Profile$MethodInfo$;
import dotty.tools.dotc.reporting.Profile$NoInfo$;
import dotty.tools.dotc.util.Spans;
import dotty.tools.dotc.util.Spans$Span$;
import java.io.Serializable;
import scala.Array$;
import scala.Product;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public abstract class Profile {
    public static int chunks(int n) {
        return Profile$.MODULE$.chunks(n);
    }

    public static Profile current(Contexts.Context context) {
        return Profile$.MODULE$.current(context);
    }

    public abstract Info unitProfile(CompilationUnit var1);

    public abstract void recordNewLine(Contexts.Context var1);

    public abstract void recordNewToken(Contexts.Context var1);

    public abstract void recordTasty(int var1, Contexts.Context var2);

    public abstract void recordMethodSize(Symbols.Symbol var1, int var2, long var3, Contexts.Context var5);

    public abstract void printSummary(Contexts.Context var1);

    public static class Info {
        private int lineCount = 0;
        private int tokenCount = 0;
        private int tastySize = 0;
        private final MethodInfo[] leading;

        public Info(int details) {
            this.leading = (MethodInfo[])Array$.MODULE$.fill(details, this::$init$$$anonfun$1, ClassTag$.MODULE$.apply(MethodInfo.class));
        }

        public int lineCount() {
            return this.lineCount;
        }

        public void lineCount_$eq(int x$1) {
            this.lineCount = x$1;
        }

        public int tokenCount() {
            return this.tokenCount;
        }

        public void tokenCount_$eq(int x$1) {
            this.tokenCount = x$1;
        }

        public int tastySize() {
            return this.tastySize;
        }

        public void tastySize_$eq(int x$1) {
            this.tastySize = x$1;
        }

        public float complexity() {
            return (float)Profile$.MODULE$.chunks(this.tastySize()) / (float)this.lineCount();
        }

        public MethodInfo[] leading() {
            return this.leading;
        }

        public void recordMethodSize(Symbols.Symbol meth, int size, long span) {
            int i;
            for (i = this.leading().length; i > 0 && this.leading()[i - 1].size() < size; --i) {
                if (i >= this.leading().length) continue;
                this.leading()[i] = this.leading()[i - 1];
            }
            if (i < this.leading().length) {
                this.leading()[i] = Profile$MethodInfo$.MODULE$.apply(meth, size, span);
                return;
            }
        }

        private final MethodInfo $init$$$anonfun$1() {
            return Profile$NoInfo$.MODULE$;
        }
    }

    public static class MethodInfo
    implements Product,
    Serializable {
        private final Symbols.Symbol meth;
        private final int size;
        private final long span;

        public static MethodInfo apply(Symbols.Symbol symbol, int n, long l) {
            return Profile$MethodInfo$.MODULE$.apply(symbol, n, l);
        }

        public static MethodInfo fromProduct(Product product) {
            return Profile$MethodInfo$.MODULE$.fromProduct(product);
        }

        public static MethodInfo unapply(MethodInfo methodInfo) {
            return Profile$MethodInfo$.MODULE$.unapply(methodInfo);
        }

        public MethodInfo(Symbols.Symbol meth, int size, long span) {
            this.meth = meth;
            this.size = size;
            this.span = span;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)1270164815);
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.meth()));
            n = Statics.mix((int)n, (int)this.size());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)new Spans.Span(this.span())));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            MethodInfo methodInfo;
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MethodInfo)) return false;
            MethodInfo methodInfo2 = methodInfo = (MethodInfo)object;
            if (this.size() != methodInfo2.size()) return false;
            Symbols.Symbol symbol = this.meth();
            Symbols.Symbol symbol2 = methodInfo2.meth();
            if (symbol == null) {
                if (symbol2 != null) {
                    return false;
                }
            } else if (!symbol.equals(symbol2)) return false;
            if (!Spans$Span$.MODULE$.$eq$eq$extension(this.span(), methodInfo2.span())) return false;
            if (!methodInfo2.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof MethodInfo;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "MethodInfo";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this._2());
                }
                case 2: {
                    return new Spans.Span(this._3());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "meth";
                }
                case 1: {
                    return "size";
                }
                case 2: {
                    return "span";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Symbols.Symbol meth() {
            return this.meth;
        }

        public int size() {
            return this.size;
        }

        public long span() {
            return this.span;
        }

        public MethodInfo copy(Symbols.Symbol meth, int size, long span) {
            return new MethodInfo(meth, size, span);
        }

        public Symbols.Symbol copy$default$1() {
            return this.meth();
        }

        public int copy$default$2() {
            return this.size();
        }

        public long copy$default$3() {
            return this.span();
        }

        public Symbols.Symbol _1() {
            return this.meth();
        }

        public int _2() {
            return this.size();
        }

        public long _3() {
            return this.span();
        }
    }
}

