/*
 * Decompiled with CFR 0.152.
 */
package scala.quoted.staging;

import dotty.tools.FatalError;
import dotty.tools.dotc.Driver;
import dotty.tools.dotc.config.Settings;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.quoted.QuotesCache$;
import dotty.tools.dotc.reporting.Reporter;
import dotty.tools.dotc.reporting.ThrowingReporter;
import dotty.tools.dotc.util.ClasspathFromClassloader$;
import dotty.tools.io.AbstractFile;
import dotty.tools.io.Directory;
import dotty.tools.io.Directory$;
import dotty.tools.io.PlainDirectory;
import dotty.tools.io.VirtualDirectory;
import dotty.tools.io.VirtualDirectory$;
import dotty.tools.repl.AbstractFileClassLoader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.quoted.Expr;
import scala.quoted.Quotes;
import scala.quoted.staging.Compiler;
import scala.quoted.staging.QuoteCompiler;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Scala3RunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public class QuoteDriver
extends Driver {
    private final ClassLoader appClassloader;
    private final Contexts.ContextBase contextBase;

    public QuoteDriver(ClassLoader appClassloader) {
        this.appClassloader = appClassloader;
        this.contextBase = new Contexts.ContextBase();
    }

    public <T> T run(Function1<Quotes, Expr<T>> exprBuilder, Compiler.Settings settings) {
        Either<String, Object> compiledExpr;
        Either<String, Object> either;
        VirtualDirectory virtualDirectory;
        Option<String> option = settings.outDir();
        if (option instanceof Some) {
            Some some = (Some)option;
            String out = (String)some.value();
            Directory dir = Directory$.MODULE$.apply(out);
            dir.createDirectory(dir.createDirectory$default$1(), dir.createDirectory$default$2());
            virtualDirectory = new PlainDirectory(Directory$.MODULE$.apply(out));
        } else if (None$.MODULE$.equals(option)) {
            virtualDirectory = new VirtualDirectory("<quote compilation output>", VirtualDirectory$.MODULE$.$lessinit$greater$default$2());
        } else {
            throw new MatchError(option);
        }
        VirtualDirectory outDir = virtualDirectory;
        Contexts.FreshContext ctx0 = QuotesCache$.MODULE$.init(this.initCtx().fresh());
        Object object = Predef$.MODULE$.refArrayOps((Object[])settings.compilerArgs().toArray(ClassTag$.MODULE$.apply(String.class)));
        Contexts.Context ctx1 = (Contexts.Context)((Tuple2)this.setup((String[])ArrayOps$.MODULE$.$colon$plus$extension(object, (Object)"dummy.scala", ClassTag$.MODULE$.apply(String.class)), (Contexts.Context)ctx0).get())._2();
        Contexts.FreshContext ctx = this.setCompilerSettings(ctx1.fresh().setSetting(ctx1.settings().outputDir(), (Object)outDir), settings);
        try {
            either = new QuoteCompiler().newRun((Contexts.Context)ctx).compileExpr(exprBuilder);
        }
        catch (FatalError ex) {
            String enrichedMessage = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("An unhandled exception was thrown in the staging compiler.\n            |This might be caused by using an incorrect classloader\n            |when creating the `staging.Compiler` instance with `staging.Compiler.make`.\n            |For details, please refer to the documentation.\n            |For non-enriched exceptions, compile with -Xno-enrich-error-messages."));
            if (BoxesRunTime.unboxToBoolean((Object)Settings.Setting$.MODULE$.value(ctx.settings().XnoEnrichErrorMessages(), (Contexts.Context)ctx))) {
                throw ex;
            }
            throw new Exception(enrichedMessage, ex);
        }
        Either<String, Object> either2 = compiledExpr = either;
        if (either2 instanceof Right) {
            Right right = (Right)either2;
            Object value = right.value();
            return (T)value;
        }
        if (either2 instanceof Left) {
            Object object2;
            Left left = (Left)either2;
            String classname = (String)left.value();
            if (ctx.reporter().hasErrors()) {
                throw Scala3RunTime$.MODULE$.assertFailed();
            }
            AbstractFileClassLoader classLoader = new AbstractFileClassLoader((AbstractFile)outDir, this.appClassloader);
            Class clazz = classLoader.loadClass(classname);
            Method method = clazz.getMethod("apply", new Class[0]);
            Object inst = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            try {
                object2 = method.invoke(inst, new Object[0]);
            }
            catch (InvocationTargetException ex) {
                Throwable throwable = ex.getCause();
                if (throwable instanceof NoClassDefFoundError) {
                    NoClassDefFoundError noClassDefFoundError = (NoClassDefFoundError)throwable;
                    throw new Exception(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("`scala.quoted.staging.run` failed to load a class.\n                   |The classloader used for the `staging.Compiler` instance might not be the correct one.\n                   |Make sure that this classloader is the one that loaded the missing class.\n                   |Note that the classloader that loads the standard library might not be the same as\n                   |the one that loaded the application classes.")), ex);
                }
                throw ex;
            }
            return (T)object2;
        }
        throw new MatchError(either2);
    }

    public Contexts.Context initCtx() {
        Contexts.Context ictx = this.contextBase.initialCtx();
        Settings.Setting$.MODULE$.update(ictx.settings().classpath(), (Object)ClasspathFromClassloader$.MODULE$.apply(this.appClassloader), ictx);
        return ictx;
    }

    private Contexts.FreshContext setCompilerSettings(Contexts.FreshContext ctx, Compiler.Settings settings) {
        return ctx.setReporter((Reporter)new ThrowingReporter(ctx.reporter()));
    }
}

