/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * greaterThanEqual(uvec4(0u, 0u, 0u, 0u), uvec4(0u, 1u, 2u, 5u)) => bvec4(true, false, false, false)
 * greaterThanEqual(uvec4(0u, 1u, 1u, 1u), uvec4(34u, 0u, 1u, 2u)) => bvec4(false, true, true, false)
 * greaterThanEqual(uvec4(1u, 1u, 2u, 2u), uvec4(5u, 34u, 0u, 1u)) => bvec4(false, false, true, true)
 * greaterThanEqual(uvec4(2u, 2u, 2u, 5u), uvec4(2u, 5u, 34u, 0u)) => bvec4(true, false, false, true)
 * greaterThanEqual(uvec4(5u, 5u, 5u, 5u), uvec4(1u, 2u, 5u, 34u)) => bvec4(true, true, true, false)
 * greaterThanEqual(uvec4(34u, 34u, 34u, 34u), uvec4(0u, 1u, 2u, 5u)) => bvec4(true, true, true, true)
 * greaterThanEqual(uvec4(34u, 0u, 0u, 0u), uvec4(34u, 0u, 1u, 2u)) => bvec4(true, true, false, false)
 */
#version 150

void main()
{
  float[all(equal(greaterThanEqual(uvec4(0u, 0u, 0u, 0u), uvec4(0u, 1u, 2u, 5u)), bvec4(true, false, false, false))) ? 1 : -1] array0;
  float[all(equal(greaterThanEqual(uvec4(0u, 1u, 1u, 1u), uvec4(34u, 0u, 1u, 2u)), bvec4(false, true, true, false))) ? 1 : -1] array1;
  float[all(equal(greaterThanEqual(uvec4(1u, 1u, 2u, 2u), uvec4(5u, 34u, 0u, 1u)), bvec4(false, false, true, true))) ? 1 : -1] array2;
  float[all(equal(greaterThanEqual(uvec4(2u, 2u, 2u, 5u), uvec4(2u, 5u, 34u, 0u)), bvec4(true, false, false, true))) ? 1 : -1] array3;
  float[all(equal(greaterThanEqual(uvec4(5u, 5u, 5u, 5u), uvec4(1u, 2u, 5u, 34u)), bvec4(true, true, true, false))) ? 1 : -1] array4;
  float[all(equal(greaterThanEqual(uvec4(34u, 34u, 34u, 34u), uvec4(0u, 1u, 2u, 5u)), bvec4(true, true, true, true))) ? 1 : -1] array5;
  float[all(equal(greaterThanEqual(uvec4(34u, 0u, 0u, 0u), uvec4(34u, 0u, 1u, 2u)), bvec4(true, true, false, false))) ? 1 : -1] array6;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length());
}
