/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * pow(vec4(0.0, 0.0, 0.6666667, 0.6666667), vec4(0.6666667, 2.0, -2.0, -0.6666667)) => vec4(0.0, 0.0, 2.2499998, 1.3103707)
 * pow(vec4(0.6666667, 0.6666667, 1.3333334, 1.3333334), vec4(0.6666667, 2.0, -2.0, -0.6666667)) => vec4(0.7631428, 0.44444448, 0.56249994, 0.8254818)
 * pow(vec4(1.3333334, 1.3333334, 2.0, 2.0), vec4(0.6666667, 2.0, -2.0, -0.6666667)) => vec4(1.2114137, 1.7777779, 0.25, 0.62996054)
 * pow(vec4(2.0, 2.0, 0.0, 0.0), vec4(0.6666667, 2.0, 0.6666667, 2.0)) => vec4(1.587401, 4.0, 0.0, 0.0)
 */
#version 120

void main()
{
  float[distance(pow(vec4(0.0, 0.0, 0.6666667, 0.6666667), vec4(0.6666667, 2.0, -2.0, -0.6666667)), vec4(0.0, 0.0, 2.2499998, 1.3103707)) <= 2.603761e-05 ? 1 : -1] array0;
  float[distance(pow(vec4(0.6666667, 0.6666667, 1.3333334, 1.3333334), vec4(0.6666667, 2.0, -2.0, -0.6666667)), vec4(0.7631428, 0.44444448, 0.56249994, 0.8254818)) <= 1.3333208e-05 ? 1 : -1] array1;
  float[distance(pow(vec4(1.3333334, 1.3333334, 2.0, 2.0), vec4(0.6666667, 2.0, -2.0, -0.6666667)), vec4(1.2114137, 1.7777779, 0.25, 0.62996054)) <= 2.2555194e-05 ? 1 : -1] array2;
  float[distance(pow(vec4(2.0, 2.0, 0.0, 0.0), vec4(0.6666667, 2.0, 0.6666667, 2.0)), vec4(1.587401, 4.0, 0.0, 0.0)) <= 4.3034684e-05 ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
