/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.common;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.openhab.core.common.NamedThreadFactory;
import org.openhab.core.common.PoolBasedSequentialScheduledExecutorService;
import org.openhab.core.common.QueueingThreadPoolExecutor;
import org.openhab.core.internal.common.WrappedScheduledExecutorService;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPid={"org.openhab.threadpool"})
public class ThreadPoolManager {
    public static final String CONFIGURATION_PID = "org.openhab.threadpool";
    public static final String THREAD_POOL_NAME_COMMON = "common";
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadPoolManager.class);
    protected static final int DEFAULT_THREAD_POOL_SIZE = 5;
    protected static final long THREAD_TIMEOUT = 65L;
    protected static final long THREAD_MONITOR_SLEEP = 60000L;
    protected static Map<String, ExecutorService> pools = new ConcurrentHashMap<String, ExecutorService>();
    private static Map<String, Integer> configs = new ConcurrentHashMap<String, Integer>();
    private static final Set<String> OSGI_PROPERTY_NAMES = Set.of("service.pid", "component.id", "component.name", "osgi.ds.satisfying.condition.target");

    protected void activate(Map<String, Object> properties) {
        this.modified(properties);
    }

    protected void modified(Map<String, Object> properties) {
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            if (OSGI_PROPERTY_NAMES.contains(entry.getKey())) continue;
            String poolName = entry.getKey();
            Object config = entry.getValue();
            if (config == null) {
                configs.remove(poolName);
            }
            if (!(config instanceof String)) continue;
            String string = (String)config;
            try {
                Integer poolSize = Integer.valueOf(string);
                configs.put(poolName, poolSize);
                ThreadPoolExecutor pool = (ThreadPoolExecutor)pools.get(poolName);
                if (pool instanceof PoolBasedSequentialScheduledExecutorService.BasePoolExecutor) {
                    PoolBasedSequentialScheduledExecutorService.BasePoolExecutor basePool = (PoolBasedSequentialScheduledExecutorService.BasePoolExecutor)pool;
                    basePool.setMinimumPoolSize(poolSize);
                    LOGGER.debug("Updated scheduled thread pool '{}' to minimum size {}", (Object)poolName, (Object)poolSize);
                    continue;
                }
                if (pool instanceof ScheduledThreadPoolExecutor) {
                    pool.setCorePoolSize(poolSize);
                    LOGGER.debug("Updated scheduled thread pool '{}' to size {}", (Object)poolName, (Object)poolSize);
                    continue;
                }
                if (!(pool instanceof QueueingThreadPoolExecutor)) continue;
                pool.setMaximumPoolSize(poolSize);
                LOGGER.debug("Updated queuing thread pool '{}' to size {}", (Object)poolName, (Object)poolSize);
            }
            catch (NumberFormatException e) {
                LOGGER.warn("Ignoring invalid configuration for pool '{}': {} - value must be an integer", (Object)poolName, config);
            }
        }
    }

    public static ScheduledExecutorService getPoolBasedSequentialScheduledExecutorService(String poolName, String threadName) {
        if (configs.getOrDefault(poolName, 0) > 0) {
            ExecutorService pool = pools.computeIfAbsent(poolName, name -> {
                int cfg = ThreadPoolManager.getConfig(name);
                PoolBasedSequentialScheduledExecutorService.BasePoolExecutor executor = new PoolBasedSequentialScheduledExecutorService.BasePoolExecutor((String)name, cfg, new NamedThreadFactory((String)name, true, 5));
                executor.setKeepAliveTime(65L, TimeUnit.SECONDS);
                executor.allowCoreThreadTimeOut(true);
                executor.setRemoveOnCancelPolicy(true);
                LOGGER.debug("Created scheduled pool based thread pool '{}' of size {}", name, (Object)cfg);
                return executor;
            });
            if (pool instanceof PoolBasedSequentialScheduledExecutorService.BasePoolExecutor) {
                PoolBasedSequentialScheduledExecutorService.BasePoolExecutor service = (PoolBasedSequentialScheduledExecutorService.BasePoolExecutor)pool;
                return new PoolBasedSequentialScheduledExecutorService(service);
            }
            throw new IllegalArgumentException("Pool " + poolName + " is not a base pool!");
        }
        return Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory(threadName));
    }

    public static ScheduledExecutorService getScheduledPool(String poolName) {
        ExecutorService pool = pools.computeIfAbsent(poolName, name -> {
            int cfg = ThreadPoolManager.getConfig(name);
            WrappedScheduledExecutorService executor = new WrappedScheduledExecutorService(cfg, new NamedThreadFactory((String)name, true, 5));
            executor.setKeepAliveTime(65L, TimeUnit.SECONDS);
            executor.allowCoreThreadTimeOut(true);
            executor.setRemoveOnCancelPolicy(true);
            LOGGER.debug("Created scheduled thread pool '{}' of size {}", name, (Object)cfg);
            return executor;
        });
        if (pool instanceof ScheduledExecutorService) {
            ScheduledExecutorService service = (ScheduledExecutorService)pool;
            return new UnstoppableScheduledExecutorService(poolName, service);
        }
        throw new IllegalArgumentException("Pool " + poolName + " is not a scheduled pool!");
    }

    public static ExecutorService getPool(String poolName) {
        ExecutorService pool = pools.computeIfAbsent(poolName, name -> {
            int cfg = ThreadPoolManager.getConfig(name);
            QueueingThreadPoolExecutor executor = QueueingThreadPoolExecutor.createInstance(name, cfg);
            executor.setKeepAliveTime(65L, TimeUnit.SECONDS);
            executor.allowCoreThreadTimeOut(true);
            LOGGER.debug("Created thread pool '{}' with size {}", name, (Object)cfg);
            return executor;
        });
        return new UnstoppableExecutorService<ExecutorService>(poolName, pool);
    }

    static ThreadPoolExecutor getPoolUnwrapped(String poolName) {
        UnstoppableExecutorService ret = (UnstoppableExecutorService)ThreadPoolManager.getPool(poolName);
        return (ThreadPoolExecutor)ret.getDelegate();
    }

    static ScheduledThreadPoolExecutor getScheduledPoolUnwrapped(String poolName) {
        UnstoppableScheduledExecutorService ret = (UnstoppableScheduledExecutorService)ThreadPoolManager.getScheduledPool(poolName);
        return (ScheduledThreadPoolExecutor)ret.getDelegate();
    }

    protected static int getConfig(String poolName) {
        Integer cfg = configs.get(poolName);
        return cfg != null ? cfg : 5;
    }

    public static Set<String> getPoolNames() {
        return new HashSet<String>(pools.keySet());
    }

    static class UnstoppableExecutorService<T extends ExecutorService>
    extends ThreadPoolExecutor {
        protected final Logger logger = LoggerFactory.getLogger(this.getClass());
        protected final T delegate;
        protected final String threadPoolName;

        private UnstoppableExecutorService(String threadPoolName, T delegate) {
            super(0, 1, 0L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(1));
            this.threadPoolName = threadPoolName;
            this.delegate = delegate;
        }

        @Override
        public void shutdown() {
            this.logger.warn("shutdown() invoked on a shared thread pool '{}'. This is a bug, please submit a bug report", (Object)this.threadPoolName, (Object)new IllegalStateException());
        }

        @Override
        public List<Runnable> shutdownNow() {
            this.logger.warn("shutdownNow() invoked on a shared thread pool '{}'. This is a bug, please submit a bug report", (Object)this.threadPoolName, (Object)new IllegalStateException());
            return List.of();
        }

        @Override
        public boolean isShutdown() {
            return this.delegate.isShutdown();
        }

        @Override
        public boolean isTerminated() {
            return this.delegate.isTerminated();
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return this.delegate.awaitTermination(timeout, unit);
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            return this.delegate.submit(task);
        }

        @Override
        public <T> Future<T> submit(Runnable task, T result) {
            return this.delegate.submit(task, result);
        }

        @Override
        public Future<?> submit(Runnable task) {
            return this.delegate.submit(task);
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
            return this.delegate.invokeAll(tasks);
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
            return this.delegate.invokeAll(tasks, timeout, unit);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
            return this.delegate.invokeAny(tasks);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.delegate.invokeAny(tasks, timeout, unit);
        }

        @Override
        public void execute(Runnable command) {
            this.delegate.execute(command);
        }

        T getDelegate() {
            return this.delegate;
        }

        @Override
        public long getCompletedTaskCount() {
            return ((ThreadPoolExecutor)this.delegate).getCompletedTaskCount();
        }

        @Override
        public int getActiveCount() {
            return ((ThreadPoolExecutor)this.delegate).getActiveCount();
        }

        @Override
        public int getMaximumPoolSize() {
            return ((ThreadPoolExecutor)this.delegate).getMaximumPoolSize();
        }

        @Override
        public int getCorePoolSize() {
            return ((ThreadPoolExecutor)this.delegate).getCorePoolSize();
        }

        @Override
        public int getPoolSize() {
            return ((ThreadPoolExecutor)this.delegate).getPoolSize();
        }

        @Override
        public BlockingQueue<Runnable> getQueue() {
            return new ArrayBlockingQueue<Runnable>(1){

                @Override
                public int remainingCapacity() {
                    return ((ThreadPoolExecutor)delegate).getQueue().remainingCapacity();
                }

                @Override
                public int size() {
                    return ((ThreadPoolExecutor)delegate).getQueue().size();
                }
            };
        }
    }

    static class UnstoppableScheduledExecutorService
    extends UnstoppableExecutorService<ScheduledExecutorService>
    implements ScheduledExecutorService {
        private UnstoppableScheduledExecutorService(String threadPoolName, ScheduledExecutorService delegate) {
            super(threadPoolName, delegate);
        }

        @Override
        public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
            return ((ScheduledExecutorService)this.delegate).schedule(command, delay, unit);
        }

        @Override
        public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
            return ((ScheduledExecutorService)this.delegate).schedule(callable, delay, unit);
        }

        @Override
        public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
            return ((ScheduledExecutorService)this.delegate).scheduleAtFixedRate(command, initialDelay, period, unit);
        }

        @Override
        public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
            return ((ScheduledExecutorService)this.delegate).scheduleWithFixedDelay(command, initialDelay, delay, unit);
        }
    }
}

