/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.ClientKeyExchange;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.PskPublicInformation;

public final class PSKClientKeyExchange
extends ClientKeyExchange {
    private static final int IDENTITY_LENGTH_BITS = 16;
    private final PskPublicInformation identity;

    public PSKClientKeyExchange(PskPublicInformation identity) {
        this.identity = identity;
    }

    private PSKClientKeyExchange(byte[] identityEncoded) {
        this.identity = PskPublicInformation.fromByteArray(identityEncoded);
    }

    @Override
    public int getMessageLength() {
        return 2 + this.identity.length();
    }

    @Override
    public String toString(int indent) {
        StringBuilder sb = new StringBuilder(super.toString(indent));
        String indentation = StringUtil.indentation((int)(indent + 1));
        sb.append(indentation).append("PSK Identity: ").append((Object)this.identity).append(StringUtil.lineSeparator());
        return sb.toString();
    }

    @Override
    public byte[] fragmentToByteArray() {
        DatagramWriter writer = new DatagramWriter(this.identity.length() + 2);
        writer.writeVarBytes((Bytes)this.identity, 16);
        return writer.toByteArray();
    }

    public static HandshakeMessage fromReader(DatagramReader reader) {
        byte[] identityEncoded = reader.readVarBytes(16);
        return new PSKClientKeyExchange(identityEncoded);
    }

    public PskPublicInformation getIdentity() {
        return this.identity;
    }
}

