/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.rest.auth.internal;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Priority;
import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.openhab.core.io.rest.JSONResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsApplicationSelect;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Component
@JaxrsExtension
@JaxrsApplicationSelect(value="(osgi.jaxrs.name=openhab)")
public class RolesAllowedDynamicFeatureImpl
implements DynamicFeature {
    private final Logger logger = LoggerFactory.getLogger(RolesAllowedDynamicFeatureImpl.class);

    public void configure(ResourceInfo resourceInfo, FeatureContext configuration) {
        Method am = resourceInfo.getResourceMethod();
        try {
            if (am.isAnnotationPresent(DenyAll.class)) {
                configuration.register((Object)new RolesAllowedRequestFilter());
                return;
            }
            Optional<Annotation> ra = Arrays.stream(am.getAnnotations()).filter(a -> a.annotationType().getName().equals(RolesAllowed.class.getName())).findFirst();
            if (ra.isPresent()) {
                configuration.register((Object)new RolesAllowedRequestFilter(((RolesAllowed)ra.get()).value()));
                return;
            }
            if (am.isAnnotationPresent(PermitAll.class)) {
                return;
            }
            ra = Arrays.stream(resourceInfo.getResourceClass().getAnnotations()).filter(a -> a.annotationType().getName().equals(RolesAllowed.class.getName())).findFirst();
            if (ra.isPresent()) {
                configuration.register((Object)new RolesAllowedRequestFilter(((RolesAllowed)ra.get()).value()));
            }
        }
        catch (Exception e) {
            this.logger.error("Error while configuring the roles", (Throwable)e);
        }
    }

    @Priority(value=2000)
    private static class RolesAllowedRequestFilter
    implements ContainerRequestFilter {
        private final boolean denyAll;
        private final String[] rolesAllowed;

        RolesAllowedRequestFilter() {
            this.denyAll = true;
            this.rolesAllowed = null;
        }

        RolesAllowedRequestFilter(String[] rolesAllowed) {
            this.denyAll = false;
            this.rolesAllowed = rolesAllowed != null ? rolesAllowed : new String[]{};
        }

        public void filter(ContainerRequestContext requestContext) throws IOException {
            if (!this.denyAll) {
                if (this.rolesAllowed.length == 0) {
                    return;
                }
                String[] stringArray = this.rolesAllowed;
                int n = this.rolesAllowed.length;
                int n2 = 0;
                while (n2 < n) {
                    String role = stringArray[n2];
                    if (requestContext.getSecurityContext().isUserInRole(role)) {
                        return;
                    }
                    ++n2;
                }
            }
            if (!RolesAllowedRequestFilter.isAuthenticated(requestContext)) {
                requestContext.abortWith(JSONResponse.createErrorResponse((Response.StatusType)Response.Status.UNAUTHORIZED, (String)"Authentication required"));
                return;
            }
            requestContext.abortWith(JSONResponse.createErrorResponse((Response.StatusType)Response.Status.FORBIDDEN, (String)"Access denied"));
        }

        private static boolean isAuthenticated(ContainerRequestContext requestContext) {
            return requestContext.getSecurityContext().getUserPrincipal() != null;
        }
    }
}

