/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.protocol;

import java.net.URI;
import java.net.URL;
import java.util.List;
import org.jupnp.UpnpService;
import org.jupnp.UpnpServiceConfiguration;
import org.jupnp.model.NetworkAddress;
import org.jupnp.model.action.ActionInvocation;
import org.jupnp.model.gena.LocalGENASubscription;
import org.jupnp.model.gena.RemoteGENASubscription;
import org.jupnp.model.message.IncomingDatagramMessage;
import org.jupnp.model.message.StreamRequestMessage;
import org.jupnp.model.message.UpnpRequest;
import org.jupnp.model.message.UpnpResponse;
import org.jupnp.model.message.header.UpnpHeader;
import org.jupnp.model.meta.LocalDevice;
import org.jupnp.model.meta.RemoteDevice;
import org.jupnp.model.meta.RemoteDeviceIdentity;
import org.jupnp.model.meta.RemoteService;
import org.jupnp.model.types.InvalidValueException;
import org.jupnp.model.types.NamedServiceType;
import org.jupnp.model.types.NotificationSubtype;
import org.jupnp.model.types.ServiceType;
import org.jupnp.protocol.ProtocolCreationException;
import org.jupnp.protocol.ProtocolFactory;
import org.jupnp.protocol.ReceivingAsync;
import org.jupnp.protocol.ReceivingSync;
import org.jupnp.protocol.async.ReceivingNotification;
import org.jupnp.protocol.async.ReceivingSearch;
import org.jupnp.protocol.async.ReceivingSearchResponse;
import org.jupnp.protocol.async.SendingNotificationAlive;
import org.jupnp.protocol.async.SendingNotificationByebye;
import org.jupnp.protocol.async.SendingSearch;
import org.jupnp.protocol.sync.ReceivingAction;
import org.jupnp.protocol.sync.ReceivingEvent;
import org.jupnp.protocol.sync.ReceivingRetrieval;
import org.jupnp.protocol.sync.ReceivingSubscribe;
import org.jupnp.protocol.sync.ReceivingUnsubscribe;
import org.jupnp.protocol.sync.SendingAction;
import org.jupnp.protocol.sync.SendingEvent;
import org.jupnp.protocol.sync.SendingRenewal;
import org.jupnp.protocol.sync.SendingSubscribe;
import org.jupnp.protocol.sync.SendingUnsubscribe;
import org.jupnp.transport.RouterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolFactoryImpl
implements ProtocolFactory {
    private final Logger logger = LoggerFactory.getLogger(ProtocolFactory.class);
    protected final UpnpService upnpService;

    protected ProtocolFactoryImpl() {
        this.upnpService = null;
    }

    public ProtocolFactoryImpl(UpnpService upnpService) {
        this.logger.trace("Creating ProtocolFactory: {}", (Object)this.getClass().getName());
        this.upnpService = upnpService;
    }

    @Override
    public UpnpService getUpnpService() {
        return this.upnpService;
    }

    @Override
    public ReceivingAsync createReceivingAsync(IncomingDatagramMessage message) throws ProtocolCreationException {
        this.logger.trace("Creating protocol for incoming asynchronous: {}", (Object)message);
        if (message.getOperation() instanceof UpnpRequest) {
            switch (((UpnpRequest)message.getOperation()).getMethod()) {
                case NOTIFY: {
                    return this.isByeBye(message) || this.isSupportedServiceAdvertisement(message) ? this.createReceivingNotification(message) : null;
                }
                case MSEARCH: {
                    return this.createReceivingSearch(message);
                }
            }
        } else if (message.getOperation() instanceof UpnpResponse) {
            return this.isSupportedServiceAdvertisement(message) ? this.createReceivingSearchResponse(message) : null;
        }
        throw new ProtocolCreationException("Protocol for incoming datagram message not found: " + String.valueOf(message));
    }

    protected ReceivingAsync createReceivingNotification(IncomingDatagramMessage<UpnpRequest> incomingRequest) {
        return new ReceivingNotification(this.getUpnpService(), incomingRequest);
    }

    protected ReceivingAsync createReceivingSearch(IncomingDatagramMessage<UpnpRequest> incomingRequest) {
        return new ReceivingSearch(this.getUpnpService(), incomingRequest);
    }

    protected ReceivingAsync createReceivingSearchResponse(IncomingDatagramMessage<UpnpResponse> incomingResponse) {
        return new ReceivingSearchResponse(this.getUpnpService(), incomingResponse);
    }

    protected boolean isByeBye(IncomingDatagramMessage message) {
        String ntsHeader = message.getHeaders().getFirstHeader(UpnpHeader.Type.NTS.getHttpName());
        return ntsHeader != null && ntsHeader.equals(NotificationSubtype.BYEBYE.getHeaderString());
    }

    protected boolean isSupportedServiceAdvertisement(IncomingDatagramMessage message) {
        UpnpServiceConfiguration config = this.upnpService.getConfiguration();
        if (config == null) {
            return false;
        }
        ServiceType[] exclusiveServiceTypes = config.getExclusiveServiceTypes();
        if (exclusiveServiceTypes == null) {
            return false;
        }
        if (exclusiveServiceTypes.length == 0) {
            return true;
        }
        String usnHeader = message.getHeaders().getFirstHeader(UpnpHeader.Type.USN.getHttpName());
        if (usnHeader == null) {
            return false;
        }
        try {
            NamedServiceType nst = NamedServiceType.valueOf(usnHeader);
            for (ServiceType exclusiveServiceType : exclusiveServiceTypes) {
                if (!nst.getServiceType().implementsVersion(exclusiveServiceType)) continue;
                return true;
            }
        }
        catch (InvalidValueException e) {
            this.logger.trace("Not a named service type header value: {}", (Object)usnHeader);
        }
        this.logger.trace("Service advertisement not supported, dropping it: {}", (Object)usnHeader);
        return false;
    }

    @Override
    public ReceivingSync createReceivingSync(StreamRequestMessage message) throws ProtocolCreationException {
        this.logger.trace("Creating protocol for incoming synchronous: {}", (Object)message);
        if (((UpnpRequest)message.getOperation()).getMethod().equals((Object)UpnpRequest.Method.GET)) {
            return this.createReceivingRetrieval(message);
        }
        if (this.getUpnpService().getConfiguration().getNamespace().isControlPath(message.getUri())) {
            if (((UpnpRequest)message.getOperation()).getMethod().equals((Object)UpnpRequest.Method.POST)) {
                return this.createReceivingAction(message);
            }
        } else if (this.getUpnpService().getConfiguration().getNamespace().isEventSubscriptionPath(message.getUri())) {
            if (((UpnpRequest)message.getOperation()).getMethod().equals((Object)UpnpRequest.Method.SUBSCRIBE)) {
                return this.createReceivingSubscribe(message);
            }
            if (((UpnpRequest)message.getOperation()).getMethod().equals((Object)UpnpRequest.Method.UNSUBSCRIBE)) {
                return this.createReceivingUnsubscribe(message);
            }
        } else if (this.getUpnpService().getConfiguration().getNamespace().isEventCallbackPath(message.getUri())) {
            if (((UpnpRequest)message.getOperation()).getMethod().equals((Object)UpnpRequest.Method.NOTIFY)) {
                return this.createReceivingEvent(message);
            }
        } else if (message.getUri().getPath().contains("/event/cb")) {
            this.logger.warn("Fixing trailing garbage in event message path: {}", (Object)message.getUri().getPath());
            String invalid = message.getUri().toString();
            message.setUri(URI.create(invalid.substring(0, invalid.indexOf("/cb") + "/cb".length())));
            if (this.getUpnpService().getConfiguration().getNamespace().isEventCallbackPath(message.getUri()) && ((UpnpRequest)message.getOperation()).getMethod().equals((Object)UpnpRequest.Method.NOTIFY)) {
                return this.createReceivingEvent(message);
            }
        }
        throw new ProtocolCreationException("Protocol for message type not found: " + String.valueOf(message));
    }

    @Override
    public SendingNotificationAlive createSendingNotificationAlive(LocalDevice localDevice) {
        return new SendingNotificationAlive(this.getUpnpService(), localDevice);
    }

    @Override
    public SendingNotificationByebye createSendingNotificationByebye(LocalDevice localDevice) {
        return new SendingNotificationByebye(this.getUpnpService(), localDevice);
    }

    @Override
    public SendingSearch createSendingSearch(UpnpHeader searchTarget, int mxSeconds) {
        return new SendingSearch(this.getUpnpService(), searchTarget, mxSeconds);
    }

    @Override
    public SendingAction createSendingAction(ActionInvocation actionInvocation, URL controlURL) {
        return new SendingAction(this.getUpnpService(), actionInvocation, controlURL);
    }

    @Override
    public SendingSubscribe createSendingSubscribe(RemoteGENASubscription subscription) throws ProtocolCreationException {
        try {
            List<NetworkAddress> activeStreamServers = this.getUpnpService().getRouter().getActiveStreamServers(((RemoteDeviceIdentity)((RemoteDevice)((RemoteService)subscription.getService()).getDevice()).getIdentity()).getDiscoveredOnLocalAddress());
            return new SendingSubscribe(this.getUpnpService(), subscription, activeStreamServers);
        }
        catch (RouterException e) {
            throw new ProtocolCreationException("Failed to obtain local stream servers (for event callback URL creation) from router", e);
        }
    }

    @Override
    public SendingRenewal createSendingRenewal(RemoteGENASubscription subscription) {
        return new SendingRenewal(this.getUpnpService(), subscription);
    }

    @Override
    public SendingUnsubscribe createSendingUnsubscribe(RemoteGENASubscription subscription) {
        return new SendingUnsubscribe(this.getUpnpService(), subscription);
    }

    @Override
    public SendingEvent createSendingEvent(LocalGENASubscription subscription) {
        return new SendingEvent(this.getUpnpService(), subscription);
    }

    protected ReceivingRetrieval createReceivingRetrieval(StreamRequestMessage message) {
        return new ReceivingRetrieval(this.getUpnpService(), message);
    }

    protected ReceivingAction createReceivingAction(StreamRequestMessage message) {
        return new ReceivingAction(this.getUpnpService(), message);
    }

    protected ReceivingSubscribe createReceivingSubscribe(StreamRequestMessage message) {
        return new ReceivingSubscribe(this.getUpnpService(), message);
    }

    protected ReceivingUnsubscribe createReceivingUnsubscribe(StreamRequestMessage message) {
        return new ReceivingUnsubscribe(this.getUpnpService(), message);
    }

    protected ReceivingEvent createReceivingEvent(StreamRequestMessage message) {
        return new ReceivingEvent(this.getUpnpService(), message);
    }
}

