/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.transport.modbus.endpoint;

import java.util.Objects;
import net.wimpi.modbus.util.SerialParameters;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.io.transport.modbus.endpoint.ModbusSlaveEndpoint;
import org.openhab.core.io.transport.modbus.endpoint.ModbusSlaveEndpointVisitor;

@NonNullByDefault
public class ModbusSerialSlaveEndpoint
implements ModbusSlaveEndpoint {
    private SerialParameters serialParameters;

    public ModbusSerialSlaveEndpoint(String portName, int baudRate, int flowControlIn, int flowControlOut, int databits, int stopbits, int parity, String encoding, boolean echo, int receiveTimeoutMillis) {
        this(new SerialParameters(portName, baudRate, flowControlIn, flowControlOut, databits, stopbits, parity, encoding, echo, receiveTimeoutMillis));
    }

    public ModbusSerialSlaveEndpoint(String portName, int baudRate, String flowControlIn, String flowControlOut, int databits, String stopbits, String parity, String encoding, boolean echo, int receiveTimeoutMillis) {
        SerialParameters parameters = new SerialParameters();
        parameters.setPortName(portName);
        parameters.setBaudRate(baudRate);
        parameters.setFlowControlIn(flowControlIn);
        parameters.setFlowControlOut(flowControlOut);
        parameters.setDatabits(databits);
        parameters.setStopbits(stopbits);
        parameters.setParity(parity);
        parameters.setEncoding(encoding);
        parameters.setEcho(echo);
        parameters.setReceiveTimeoutMillis(receiveTimeoutMillis);
        this.serialParameters = parameters;
    }

    private ModbusSerialSlaveEndpoint(SerialParameters serialParameters) {
        this.serialParameters = serialParameters;
    }

    public SerialParameters getSerialParameters() {
        return this.serialParameters;
    }

    @Override
    public <R> R accept(ModbusSlaveEndpointVisitor<R> factory) {
        return factory.visit(this);
    }

    public String getPortName() {
        return this.serialParameters.getPortName();
    }

    public int hashCode() {
        return this.serialParameters.getPortName().hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ModbusSerialSlaveEndpoint rhs = (ModbusSerialSlaveEndpoint)obj;
        return Objects.equals(this.getPortName(), rhs.getPortName());
    }

    public String toString() {
        return "ModbusSerialSlaveEndpoint [getPortName()=" + this.getPortName() + "]";
    }
}

