/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.script.jvmmodel;

import java.util.Collection;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.openhab.core.common.registry.RegistryChangeListener;
import org.openhab.core.items.Item;
import org.openhab.core.items.ItemRegistry;
import org.openhab.core.items.ItemRegistryChangeListener;
import org.openhab.core.model.core.ModelRepository;
import org.openhab.core.model.script.engine.action.ActionService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ScriptItemRefresher.class}, immediate=true)
public class ScriptItemRefresher
implements ItemRegistryChangeListener {
    private final Logger logger = LoggerFactory.getLogger(ScriptItemRefresher.class);
    private static final long REFRESH_DELAY = 2000L;
    ModelRepository modelRepository;
    private ItemRegistry itemRegistry;
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private ScheduledFuture<?> job;
    Runnable runnable = new Runnable(){

        @Override
        public void run() {
            try {
                ScriptItemRefresher.this.modelRepository.reloadAllModelsOfType("script");
            }
            catch (Exception e) {
                ScriptItemRefresher.this.logger.debug("Exception occurred during execution: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    };

    @Reference
    public void setModelRepository(ModelRepository modelRepository) {
        this.modelRepository = modelRepository;
    }

    public void unsetModelRepository(ModelRepository modelRepository) {
        if (this.job != null && !this.job.isDone()) {
            this.job.cancel(false);
        }
        this.modelRepository = null;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    public void setItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = itemRegistry;
        this.itemRegistry.addRegistryChangeListener((RegistryChangeListener)this);
    }

    public void unsetItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry.removeRegistryChangeListener((RegistryChangeListener)this);
        this.itemRegistry = null;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addActionService(ActionService actionService) {
        this.logger.debug("Script action added => scripts are going to be refreshed");
        this.scheduleScriptRefresh();
    }

    protected void removeActionService(ActionService actionService) {
        this.logger.debug("Script action removed => scripts are going to be refreshed");
        this.scheduleScriptRefresh();
    }

    public void added(Item element) {
        this.logger.debug("Item \"{}\" added => scripts are going to be refreshed", (Object)element.getName());
        this.scheduleScriptRefresh();
    }

    public void removed(Item element) {
        this.logger.debug("Item \"{}\" removed => scripts are going to be refreshed", (Object)element.getName());
        this.scheduleScriptRefresh();
    }

    public void updated(Item oldElement, Item element) {
    }

    public void allItemsChanged(Collection<String> oldItemNames) {
        this.logger.debug("All items changed => scripts are going to be refreshed");
        this.scheduleScriptRefresh();
    }

    private synchronized void scheduleScriptRefresh() {
        if (this.job != null && !this.job.isDone()) {
            this.job.cancel(false);
        }
        this.job = this.scheduler.schedule(this.runnable, 2000L, TimeUnit.MILLISECONDS);
    }
}

