/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.staxex.util;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public class SaajStaxWriter
implements XMLStreamWriter {
    protected SOAPMessage soap;
    protected String envURI;
    protected SOAPElement currentElement;
    protected static final String Envelope = "Envelope";
    protected static final String Header = "Header";
    protected static final String Body = "Body";
    protected static final String xmlns = "xmlns";

    public SaajStaxWriter(SOAPMessage msg, String uri) throws SOAPException {
        this.soap = msg;
        this.envURI = uri;
    }

    public SOAPMessage getSOAPMessage() {
        return this.soap;
    }

    protected SOAPElement getEnvelope() throws SOAPException {
        return this.soap.getSOAPPart().getEnvelope();
    }

    public void writeStartElement(String localName) throws XMLStreamException {
        try {
            this.currentElement = this.currentElement.addChildElement(localName);
        }
        catch (SOAPException e) {
            throw new XMLStreamException(e);
        }
    }

    public void writeStartElement(String ns, String ln) throws XMLStreamException {
        this.writeStartElement(null, ln, ns);
    }

    public void writeStartElement(String prefix, String ln, String ns) throws XMLStreamException {
        try {
            if (this.envURI.equals(ns)) {
                if (Envelope.equals(ln)) {
                    this.currentElement = this.getEnvelope();
                    this.fixPrefix(prefix);
                    return;
                }
                if (Header.equals(ln)) {
                    this.currentElement = this.soap.getSOAPHeader();
                    this.fixPrefix(prefix);
                    return;
                }
                if (Body.equals(ln)) {
                    this.currentElement = this.soap.getSOAPBody();
                    this.fixPrefix(prefix);
                    return;
                }
            }
            this.currentElement = prefix == null ? this.currentElement.addChildElement(new QName(ns, ln)) : this.currentElement.addChildElement(ln, prefix, ns);
        }
        catch (SOAPException e) {
            throw new XMLStreamException(e);
        }
    }

    private void fixPrefix(String prfx) throws XMLStreamException {
        String oldPrfx = this.currentElement.getPrefix();
        if (prfx != null && !prfx.equals(oldPrfx)) {
            this.currentElement.setPrefix(prfx);
        }
    }

    public void writeEmptyElement(String uri, String ln) throws XMLStreamException {
        this.writeStartElement(null, ln, uri);
    }

    public void writeEmptyElement(String prefix, String ln, String uri) throws XMLStreamException {
        this.writeStartElement(prefix, ln, uri);
    }

    public void writeEmptyElement(String ln) throws XMLStreamException {
        this.writeStartElement(null, ln, null);
    }

    public void writeEndElement() throws XMLStreamException {
        if (this.currentElement != null) {
            this.currentElement = this.currentElement.getParentElement();
        }
    }

    public void writeEndDocument() throws XMLStreamException {
    }

    public void close() throws XMLStreamException {
    }

    public void flush() throws XMLStreamException {
    }

    public void writeAttribute(String ln, String val) throws XMLStreamException {
        this.writeAttribute(null, null, ln, val);
    }

    public void writeAttribute(String prefix, String ns, String ln, String value) throws XMLStreamException {
        try {
            if (ns == null) {
                if (prefix == null && xmlns.equals(ln)) {
                    this.currentElement.addNamespaceDeclaration("", value);
                } else {
                    this.currentElement.setAttributeNS("", ln, value);
                }
            } else {
                QName name = prefix == null ? new QName(ns, ln) : new QName(ns, ln, prefix);
                this.currentElement.addAttribute(name, value);
            }
        }
        catch (SOAPException e) {
            throw new XMLStreamException(e);
        }
    }

    public void writeAttribute(String ns, String ln, String val) throws XMLStreamException {
        this.writeAttribute(null, ns, ln, val);
    }

    public void writeNamespace(String prefix, String uri) throws XMLStreamException {
        if (prefix == null || xmlns.equals(prefix)) {
            prefix = "";
        }
        try {
            this.currentElement.addNamespaceDeclaration(prefix, uri);
        }
        catch (SOAPException e) {
            throw new XMLStreamException(e);
        }
    }

    public void writeDefaultNamespace(String uri) throws XMLStreamException {
        this.writeNamespace("", uri);
    }

    public void writeComment(String data) throws XMLStreamException {
        Comment c = this.soap.getSOAPPart().createComment(data);
        this.currentElement.appendChild((Node)c);
    }

    public void writeProcessingInstruction(String target) throws XMLStreamException {
        ProcessingInstruction n = this.soap.getSOAPPart().createProcessingInstruction(target, "");
        this.currentElement.appendChild((Node)n);
    }

    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        ProcessingInstruction n = this.soap.getSOAPPart().createProcessingInstruction(target, data);
        this.currentElement.appendChild((Node)n);
    }

    public void writeCData(String data) throws XMLStreamException {
        CDATASection n = this.soap.getSOAPPart().createCDATASection(data);
        this.currentElement.appendChild((Node)n);
    }

    public void writeDTD(String dtd) throws XMLStreamException {
    }

    public void writeEntityRef(String name) throws XMLStreamException {
        EntityReference n = this.soap.getSOAPPart().createEntityReference(name);
        this.currentElement.appendChild((Node)n);
    }

    public void writeStartDocument() throws XMLStreamException {
    }

    public void writeStartDocument(String version) throws XMLStreamException {
        if (version != null) {
            this.soap.getSOAPPart().setXmlVersion(version);
        }
    }

    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        if (version != null) {
            this.soap.getSOAPPart().setXmlVersion(version);
        }
        if (encoding != null) {
            try {
                this.soap.setProperty("javax.xml.soap.character-set-encoding", (Object)encoding);
            }
            catch (SOAPException e) {
                throw new XMLStreamException(e);
            }
        }
    }

    public void writeCharacters(String text) throws XMLStreamException {
        try {
            this.currentElement.addTextNode(text);
        }
        catch (SOAPException e) {
            throw new XMLStreamException(e);
        }
    }

    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        char[] chr = start == 0 && len == text.length ? text : Arrays.copyOfRange(text, start, start + len);
        try {
            this.currentElement.addTextNode(new String(chr));
        }
        catch (SOAPException e) {
            throw new XMLStreamException(e);
        }
    }

    public String getPrefix(String uri) throws XMLStreamException {
        return this.currentElement.lookupPrefix(uri);
    }

    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        try {
            this.currentElement.addNamespaceDeclaration(prefix, uri);
        }
        catch (SOAPException e) {
            throw new XMLStreamException(e);
        }
    }

    public void setDefaultNamespace(String uri) throws XMLStreamException {
        this.setPrefix("", uri);
    }

    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    public Object getProperty(String name) throws IllegalArgumentException {
        if ("javax.xml.stream.isRepairingNamespaces".equals(name)) {
            return Boolean.FALSE;
        }
        return null;
    }

    public NamespaceContext getNamespaceContext() {
        return new NamespaceContext(){

            public String getNamespaceURI(String prefix) {
                return SaajStaxWriter.this.currentElement.getNamespaceURI(prefix);
            }

            public String getPrefix(String namespaceURI) {
                return SaajStaxWriter.this.currentElement.lookupPrefix(namespaceURI);
            }

            public Iterator getPrefixes(final String namespaceURI) {
                return new Iterator(){
                    String prefix;
                    {
                        this.prefix = this.getPrefix(namespaceURI);
                    }

                    public boolean hasNext() {
                        return this.prefix != null;
                    }

                    public Object next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        String next = this.prefix;
                        this.prefix = null;
                        return next;
                    }

                    public void remove() {
                    }
                };
            }
        };
    }
}

