/*
 * Decompiled with CFR 0.152.
 */
package io.github.dmlloyd.classfile.impl;

import io.github.dmlloyd.classfile.AccessFlags;
import io.github.dmlloyd.classfile.ClassModel;
import io.github.dmlloyd.classfile.FieldBuilder;
import io.github.dmlloyd.classfile.FieldElement;
import io.github.dmlloyd.classfile.FieldModel;
import io.github.dmlloyd.classfile.constantpool.ConstantPoolBuilder;
import io.github.dmlloyd.classfile.constantpool.Utf8Entry;
import io.github.dmlloyd.classfile.extras.reflect.AccessFlag;
import io.github.dmlloyd.classfile.impl.AbstractUnboundModel;
import io.github.dmlloyd.classfile.impl.AccessFlagsImpl;
import io.github.dmlloyd.classfile.impl.ClassFileImpl;
import io.github.dmlloyd.classfile.impl.DirectClassBuilder;
import io.github.dmlloyd.classfile.impl.SplitConstantPool;
import io.github.dmlloyd.classfile.impl.TerminalFieldBuilder;
import io.github.dmlloyd.classfile.impl.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public final class BufferedFieldBuilder
implements TerminalFieldBuilder {
    private final SplitConstantPool constantPool;
    private final ClassFileImpl context;
    private final Utf8Entry name;
    private final Utf8Entry desc;
    private final List<FieldElement> elements = new ArrayList<FieldElement>();
    private AccessFlags flags;

    public BufferedFieldBuilder(SplitConstantPool constantPool, ClassFileImpl context, Utf8Entry name, Utf8Entry type) {
        this.constantPool = constantPool;
        this.context = context;
        this.name = Objects.requireNonNull(name);
        this.desc = Objects.requireNonNull(type);
        this.flags = new AccessFlagsImpl(AccessFlag.Location.FIELD, new AccessFlag[0]);
    }

    @Override
    public ConstantPoolBuilder constantPool() {
        return this.constantPool;
    }

    @Override
    public FieldBuilder with(FieldElement element) {
        this.elements.add(Objects.requireNonNull(element));
        if (element instanceof AccessFlags) {
            AccessFlags f;
            this.flags = f = (AccessFlags)element;
        }
        return this;
    }

    public BufferedFieldBuilder run(Consumer<? super FieldBuilder> handler) {
        handler.accept(this);
        return this;
    }

    public FieldModel toModel() {
        return new Model();
    }

    public final class Model
    extends AbstractUnboundModel<FieldElement>
    implements FieldModel {
        public Model() {
            super(BufferedFieldBuilder.this.elements);
        }

        @Override
        public Optional<ClassModel> parent() {
            return Optional.empty();
        }

        @Override
        public AccessFlags flags() {
            return BufferedFieldBuilder.this.flags;
        }

        @Override
        public Utf8Entry fieldName() {
            return BufferedFieldBuilder.this.name;
        }

        @Override
        public Utf8Entry fieldType() {
            return BufferedFieldBuilder.this.desc;
        }

        @Override
        public void writeTo(DirectClassBuilder builder) {
            builder.withField(BufferedFieldBuilder.this.name, BufferedFieldBuilder.this.desc, Util.writingAll(this));
        }

        public String toString() {
            return String.format("FieldModel[fieldName=%s, fieldType=%s, flags=%d]", BufferedFieldBuilder.this.name.stringValue(), BufferedFieldBuilder.this.desc.stringValue(), BufferedFieldBuilder.this.flags.flagsMask());
        }
    }
}

