/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.rmi.registry;

import java.util.NoSuchElementException;
import javax.naming.CompositeName;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

class NameClassPairEnumeration
implements NamingEnumeration<NameClassPair> {
    private final String[] names;
    private int nextName;

    NameClassPairEnumeration(String[] stringArray) {
        this.names = stringArray;
        this.nextName = 0;
    }

    @Override
    public boolean hasMore() {
        return this.nextName < this.names.length;
    }

    @Override
    public NameClassPair next() throws NamingException {
        if (!this.hasMore()) {
            throw new NoSuchElementException();
        }
        String string = this.names[this.nextName++];
        Name name = new CompositeName().add(string);
        NameClassPair nameClassPair = new NameClassPair(name.toString(), "java.lang.Object");
        nameClassPair.setNameInNamespace(string);
        return nameClassPair;
    }

    @Override
    public boolean hasMoreElements() {
        return this.hasMore();
    }

    @Override
    public NameClassPair nextElement() {
        try {
            return this.next();
        }
        catch (NamingException namingException) {
            throw new NoSuchElementException("javax.naming.NamingException was thrown");
        }
    }

    @Override
    public void close() {
        this.nextName = this.names.length;
    }
}

