/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.utilities.soql;

import java.util.Iterator;
import java.util.List;
import sun.jvm.hotspot.utilities.soql.DefaultScriptObject;
import sun.jvm.hotspot.utilities.soql.JSJavaFactory;

public class JSList
extends DefaultScriptObject {
    private final List list;
    private final JSJavaFactory factory;

    public JSList(List list, JSJavaFactory fac) {
        this.list = list;
        this.factory = fac;
    }

    @Override
    public Object get(String name) {
        if (name.equals("length")) {
            return new Integer(this.list.size());
        }
        return super.get(name);
    }

    @Override
    public Object get(int index) {
        if (this.isInRange(index)) {
            Object item = this.list.get(index);
            return this.wrapObject(item);
        }
        return super.get(index);
    }

    @Override
    public Object[] getIds() {
        Object[] superIds = super.getIds();
        int size = this.list.size();
        Object[] res = new Object[superIds.length + size];
        for (int i = 0; i < size; ++i) {
            res[i] = new Integer(i);
        }
        System.arraycopy(superIds, 0, res, size, superIds.length);
        return res;
    }

    @Override
    public boolean has(String name) {
        if (name.equals("length")) {
            return true;
        }
        return super.has(name);
    }

    @Override
    public boolean has(int index) {
        if (this.isInRange(index)) {
            return true;
        }
        return super.has(index);
    }

    @Override
    public void put(String name, Object value) {
        if (!name.equals("length")) {
            super.put(name, value);
        }
    }

    @Override
    public void put(int index, Object value) {
        if (!this.isInRange(index)) {
            super.put(index, value);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append('[');
        Iterator itr = this.list.iterator();
        while (itr.hasNext()) {
            buf.append(this.wrapObject(itr.next()));
            if (!itr.hasNext()) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    private boolean isInRange(int index) {
        return index >= 0 && index < this.list.size();
    }

    private Object wrapObject(Object obj) {
        return this.factory.newJSJavaWrapper(obj);
    }
}

