/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import net.i2p.i2ptunnel.util.LimitOutputStream;

public class ByteLimitOutputStream
extends LimitOutputStream {
    private final long _limit;
    private long _count;

    public ByteLimitOutputStream(OutputStream out, LimitOutputStream.DoneCallback done, long limit) {
        super(out, done);
        if (limit <= 0L) {
            throw new IllegalArgumentException();
        }
        this._limit = limit;
    }

    @Override
    public void write(byte[] src, int off, int len) throws IOException {
        boolean last;
        if (len == 0) {
            return;
        }
        if (this._isDone) {
            throw new EOFException("done");
        }
        long togo = this._limit - this._count;
        boolean bl = last = (long)len >= togo;
        if (last) {
            len = (int)togo;
        }
        super.write(src, off, len);
        this._count += (long)len;
        if (last) {
            this.setDone();
        }
    }
}

