/*
 * Decompiled with CFR 0.152.
 */
package io.mola.galimatias.canonicalize;

import io.mola.galimatias.GalimatiasParseException;
import io.mola.galimatias.URL;
import io.mola.galimatias.canonicalize.URLCanonicalizer;
import java.util.regex.Pattern;

public class RegexCanonicalizer
implements URLCanonicalizer {
    private final Scope scope;
    private final Pattern pattern;
    private final String substitution;

    public RegexCanonicalizer(Scope scope, Pattern pattern, String substitution) {
        this.scope = scope;
        this.pattern = pattern;
        this.substitution = substitution;
    }

    @Override
    public URL canonicalize(URL input) throws GalimatiasParseException {
        switch (this.scope.ordinal()) {
            case 0: {
                return input.withHost(this.pattern.matcher(input.host().toString()).replaceAll(this.substitution));
            }
            case 1: {
                return input.withPath(this.pattern.matcher(input.path()).replaceAll(this.substitution));
            }
            case 2: {
                return input.withQuery(this.pattern.matcher(input.query()).replaceAll(this.substitution));
            }
            case 3: {
                return input.withFragment(this.pattern.matcher(input.fragment()).replaceAll(this.substitution));
            }
            case 4: {
                return URL.parse(this.pattern.matcher(input.toString()).replaceAll(this.substitution));
            }
        }
        return input;
    }

    public static enum Scope {
        HOST,
        PATH,
        QUERY,
        FRAGMENT,
        FULL;

    }
}

