/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class SupermateProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().number("d+:").number("(d+):").number("d+:").text("*,").number("(d+),").expression("([^,]{2}),").expression("([AV]),").number("(xx)(xx)(xx),").number("(xx)(xx)(xx),").number("(x)(x{7}),").number("(x)(x{7}),").number("(x{4}),").number("(x{4}),").number("(x{12}),").number("(x+),").number("(d+),").number("(x{4}),").number("(x+)?").any().compile();

    public SupermateProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        Parser parser = new Parser(PATTERN, (String)msg);
        if (!parser.matches()) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        String imei = parser.next();
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, imei);
        if (deviceSession == null) {
            return null;
        }
        position.setDeviceId(deviceSession.getDeviceId());
        position.set("commandId", parser.next());
        position.set("command", parser.next());
        position.setValid(parser.next().equals("A"));
        DateBuilder dateBuilder = new DateBuilder().setDate(parser.nextHexInt(0), parser.nextHexInt(0), parser.nextHexInt(0)).setTime(parser.nextHexInt(0), parser.nextHexInt(0), parser.nextHexInt(0));
        position.setTime(dateBuilder.getDate());
        if (parser.nextHexInt(0) == 8) {
            position.setLatitude((double)(-parser.nextHexInt(0)) / 600000.0);
        } else {
            position.setLatitude((double)parser.nextHexInt(0) / 600000.0);
        }
        if (parser.nextHexInt(0) == 8) {
            position.setLongitude((double)(-parser.nextHexInt(0)) / 600000.0);
        } else {
            position.setLongitude((double)parser.nextHexInt(0) / 600000.0);
        }
        position.setSpeed((double)parser.nextHexInt(0) / 100.0);
        position.setCourse((double)parser.nextHexInt(0) / 100.0);
        position.set("status", parser.next());
        position.set("signal", parser.next());
        position.set("power", parser.nextDouble(0.0));
        position.set("oil", parser.nextHexInt(0));
        position.set("odometer", parser.nextHexInt(0));
        if (channel != null) {
            Calendar calendar = Calendar.getInstance();
            String content = String.format("#1:%s:1:*,00000000,UP,%02x%02x%02x,%02x%02x%02x#", imei, calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13));
            channel.writeAndFlush((Object)new NetworkMessage(Unpooled.copiedBuffer((CharSequence)content, (Charset)StandardCharsets.US_ASCII), remoteAddress));
        }
        return position;
    }
}

