/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import java.io.Reader;
import java.io.StringReader;
import java.net.SocketAddress;
import java.util.Date;
import java.util.LinkedList;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;
import org.traccar.model.WifiAccessPoint;
import org.traccar.session.DeviceSession;

public class B2316ProtocolDecoder
extends BaseProtocolDecoder {
    public B2316ProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private String decodeAlarm(int value) {
        return switch (value) {
            case 1 -> "lowBattery";
            case 2 -> "sos";
            case 3 -> "powerOff";
            case 4 -> "removing";
            default -> null;
        };
    }

    private Integer decodeBattery(int value) {
        return switch (value) {
            case 0 -> 10;
            case 1 -> 30;
            case 2 -> 60;
            case 3 -> 80;
            case 4 -> 100;
            default -> null;
        };
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        JsonObject root = Json.createReader((Reader)new StringReader((String)msg)).readObject();
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, root.getString("imei"));
        if (deviceSession == null) {
            return null;
        }
        LinkedList<Position> positions = new LinkedList<Position>();
        JsonArray data = root.getJsonArray("data");
        for (int i = 0; i < data.size(); ++i) {
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            Network network = new Network();
            JsonObject item = data.getJsonObject(i);
            Date time = new Date(item.getJsonNumber("tm").longValue() * 1000L);
            if (item.containsKey((Object)"gp")) {
                String[] coordinates = item.getString("gp").split(",");
                position.setLongitude(Double.parseDouble(coordinates[0]));
                position.setLatitude(Double.parseDouble(coordinates[1]));
                position.setValid(true);
                position.setTime(time);
            } else {
                this.getLastLocation(position, time);
            }
            if (item.containsKey((Object)"ci")) {
                String[] cell = item.getString("ci").split(",");
                network.addCellTower(CellTower.from(Integer.parseInt(cell[0]), Integer.parseInt(cell[1]), Integer.parseInt(cell[2]), Integer.parseInt(cell[3]), Integer.parseInt(cell[4])));
            }
            if (item.containsKey((Object)"wi")) {
                String[] points;
                for (String point : points = item.getString("wi").split(";")) {
                    String[] values = point.split(",");
                    String mac = values[0].replaceAll("(..)", "$1:");
                    network.addWifiAccessPoint(WifiAccessPoint.from(mac.substring(0, mac.length() - 1), Integer.parseInt(values[1])));
                }
            }
            if (item.containsKey((Object)"wn")) {
                position.addAlarm(this.decodeAlarm(item.getInt("wn")));
            }
            if (item.containsKey((Object)"ic")) {
                position.set("iccid", item.getString("ic"));
            }
            if (item.containsKey((Object)"ve")) {
                position.set("versionFw", item.getString("ve"));
            }
            if (item.containsKey((Object)"te")) {
                String[] temperatures = item.getString("te").split(",");
                for (int j = 0; j < temperatures.length; ++j) {
                    position.set("temp" + (j + 1), (double)Integer.parseInt(temperatures[j]) * 0.1);
                }
            }
            if (item.containsKey((Object)"st")) {
                position.set("steps", item.getInt("st"));
            }
            if (item.containsKey((Object)"ba")) {
                position.set("batteryLevel", this.decodeBattery(item.getInt("ba")));
            }
            if (item.containsKey((Object)"sn")) {
                position.set("rssi", item.getInt("sn"));
            }
            if (item.containsKey((Object)"hr")) {
                position.set("heartRate", item.getInt("hr"));
            }
            if (network.getCellTowers() != null || network.getWifiAccessPoints() != null) {
                position.setNetwork(network);
            }
            positions.add(position);
        }
        return positions.isEmpty() ? null : positions;
    }
}

