/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.dialect;

import com.networknt.schema.SchemaRegistry;
import com.networknt.schema.Specification;
import com.networknt.schema.dialect.BasicDialectRegistry;
import com.networknt.schema.dialect.Dialect;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;

public class DefaultDialectRegistry
extends BasicDialectRegistry {
    private final ConcurrentMap<String, Dialect> loadedDialects = new ConcurrentHashMap<String, Dialect>();

    public DefaultDialectRegistry() {
    }

    public DefaultDialectRegistry(Function<String, Dialect> dialects) {
        super(dialects);
    }

    public DefaultDialectRegistry(Dialect dialect) {
        super(dialect);
    }

    public DefaultDialectRegistry(Collection<Dialect> dialects) {
        super(dialects);
    }

    @Override
    public Dialect getDialect(String dialectId, SchemaRegistry schemaFactory) {
        Dialect dialect;
        if (this.dialects != null && (dialect = (Dialect)this.dialects.apply(dialectId)) != null) {
            return dialect;
        }
        dialect = Specification.getDialect(dialectId);
        if (dialect != null) {
            return dialect;
        }
        return this.loadedDialects.computeIfAbsent(dialectId, id -> this.loadDialect((String)id, schemaFactory));
    }

    public static DefaultDialectRegistry getInstance() {
        return Holder.INSTANCE;
    }

    private static class Holder {
        private static final DefaultDialectRegistry INSTANCE = new DefaultDialectRegistry();

        private Holder() {
        }
    }
}

