/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server;

import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.glassfish.jersey.innate.inject.Bindings;
import org.glassfish.jersey.innate.inject.InjectionIds;
import org.glassfish.jersey.innate.inject.InstanceBinding;
import org.glassfish.jersey.internal.BootstrapBag;
import org.glassfish.jersey.internal.BootstrapConfigurator;
import org.glassfish.jersey.internal.inject.Binding;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.model.ContractProvider;
import org.glassfish.jersey.model.internal.ComponentBag;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.ServerBootstrapBag;
import org.glassfish.jersey.server.model.ModelProcessor;
import org.glassfish.jersey.server.wadl.processor.OptionsMethodProcessor;

class ModelProcessorConfigurator
implements BootstrapConfigurator {
    private static final Function<Object, ModelProcessor> CAST_TO_MODEL_PROCESSOR = ModelProcessor.class::cast;
    private static final Predicate<Binding> BINDING_MODEL_PROCESSOR_ONLY = binding -> binding.getContracts().contains(ModelProcessor.class);
    private static final Predicate<ContractProvider> CONTRACT_PROVIDER_MODEL_PROCESSOR_ONLY = provider -> provider.getContracts().contains(ModelProcessor.class);

    ModelProcessorConfigurator() {
    }

    public void init(InjectionManager injectionManager, BootstrapBag bootstrapBag) {
        ServerBootstrapBag serverBag = (ServerBootstrapBag)bootstrapBag;
        ResourceConfig runtimeConfig = serverBag.getRuntimeConfig();
        ComponentBag componentBag = runtimeConfig.getComponentBag();
        OptionsMethodProcessor optionsMethodProcessor = new OptionsMethodProcessor();
        injectionManager.register((Binding)((InstanceBinding)Bindings.service((Object)optionsMethodProcessor).to(ModelProcessor.class)).id((long)InjectionIds.SERVER_OPTIONS_METHOD_PROCESSOR.id()));
        List<ModelProcessor> modelProcessors = Stream.concat(componentBag.getClasses(CONTRACT_PROVIDER_MODEL_PROCESSOR_ONLY).stream().map(arg_0 -> ((InjectionManager)injectionManager).createAndInitialize(arg_0)), componentBag.getInstances(CONTRACT_PROVIDER_MODEL_PROCESSOR_ONLY).stream()).map(CAST_TO_MODEL_PROCESSOR).collect(Collectors.toList());
        modelProcessors.add(optionsMethodProcessor);
        List modelProcessorsFromBinders = ComponentBag.getFromBinders((InjectionManager)injectionManager, (ComponentBag)componentBag, CAST_TO_MODEL_PROCESSOR, BINDING_MODEL_PROCESSOR_ONLY);
        modelProcessors.addAll(modelProcessorsFromBinders);
        serverBag.setModelProcessors(modelProcessors);
    }
}

