/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.helper;

import java.util.AbstractMap;
import java.util.Map;

public final class ObdDecoder {
    private static final int MODE_CURRENT = 1;
    private static final int MODE_FREEZE_FRAME = 2;
    private static final int MODE_CODES = 3;

    private ObdDecoder() {
    }

    public static Map.Entry<String, Object> decode(int mode, String value) {
        return switch (mode) {
            case 1, 2 -> ObdDecoder.decodeData(Integer.parseInt(value.substring(0, 2), 16), Long.parseLong(value.substring(2), 16), true);
            case 3 -> ObdDecoder.decodeCodes(value);
            default -> null;
        };
    }

    private static Map.Entry<String, Object> createEntry(String key, Object value) {
        return new AbstractMap.SimpleEntry<String, Object>(key, value);
    }

    public static Map.Entry<String, Object> decodeCodes(String value) {
        StringBuilder codes = new StringBuilder();
        for (int i = 0; i < value.length() / 4; ++i) {
            int numValue = Integer.parseInt(value.substring(i * 4, (i + 1) * 4), 16);
            codes.append(' ').append(ObdDecoder.decodeCode(numValue));
        }
        if (!codes.isEmpty()) {
            return ObdDecoder.createEntry("dtcs", codes.toString().trim());
        }
        return null;
    }

    public static String decodeCode(int value) {
        char prefix = switch (value >> 14) {
            case 1 -> 'C';
            case 2 -> 'B';
            case 3 -> 'U';
            default -> 'P';
        };
        return String.format("%c%04X", Character.valueOf(prefix), value & 0x3FFF);
    }

    public static Map.Entry<String, Object> decodeData(int pid, long value, boolean convert) {
        return switch (pid) {
            case 4 -> ObdDecoder.createEntry("engineLoad", convert ? value * 100L / 255L : value);
            case 5 -> ObdDecoder.createEntry("coolantTemp", convert ? value - 40L : value);
            case 11 -> ObdDecoder.createEntry("mapIntake", value);
            case 12 -> ObdDecoder.createEntry("rpm", convert ? value / 4L : value);
            case 13 -> ObdDecoder.createEntry("obdSpeed", value);
            case 15 -> ObdDecoder.createEntry("intakeTemp", convert ? value - 40L : value);
            case 17 -> ObdDecoder.createEntry("throttle", convert ? value * 100L / 255L : value);
            case 33 -> ObdDecoder.createEntry("milDistance", value);
            case 47 -> ObdDecoder.createEntry("fuel", convert ? value * 100L / 255L : value);
            case 49 -> ObdDecoder.createEntry("clearedDistance", value);
            default -> null;
        };
    }
}

