/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.library.unit;

import javax.measure.Unit;
import javax.measure.quantity.Area;
import javax.measure.quantity.Length;
import javax.measure.quantity.Mass;
import javax.measure.quantity.Pressure;
import javax.measure.quantity.Speed;
import javax.measure.quantity.Temperature;
import javax.measure.quantity.Volume;
import javax.measure.spi.SystemOfUnits;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.library.unit.CustomUnits;
import tech.units.indriya.format.SimpleUnitFormat;
import tech.units.indriya.unit.Units;

@NonNullByDefault
public final class SIUnits
extends CustomUnits {
    public static final String MEASUREMENT_SYSTEM_NAME = "SI";
    private static final SIUnits INSTANCE = new SIUnits();
    public static final Unit<Temperature> CELSIUS = SIUnits.addUnit(Units.CELSIUS);
    public static final Unit<Speed> KILOMETRE_PER_HOUR = SIUnits.addUnit(Units.KILOMETRE_PER_HOUR);
    public static final Unit<Length> METRE = SIUnits.addUnit(Units.METRE);
    public static final Unit<Mass> KILOGRAM = SIUnits.addUnit(Units.KILOGRAM);
    public static final Unit<Mass> GRAM = SIUnits.addUnit(Units.GRAM);
    public static final Unit<Area> SQUARE_METRE = SIUnits.addUnit(Units.SQUARE_METRE);
    public static final Unit<Volume> CUBIC_METRE = SIUnits.addUnit(Units.CUBIC_METRE);
    public static final Unit<Pressure> PASCAL = SIUnits.addUnit(Units.PASCAL);

    static {
        SimpleUnitFormat.getInstance().label(CELSIUS, "\u00b0C");
    }

    private SIUnits() {
    }

    public static SystemOfUnits getInstance() {
        return INSTANCE;
    }

    private static <U extends Unit<?>> U addUnit(U unit) {
        SIUnits.INSTANCE.units.add(unit);
        return unit;
    }

    @Override
    public String getName() {
        return MEASUREMENT_SYSTEM_NAME;
    }
}

