/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.library.items;

import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.measure.Quantity;
import javax.measure.Unit;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.i18n.UnitProvider;
import org.openhab.core.items.GenericItem;
import org.openhab.core.items.ItemUtil;
import org.openhab.core.items.Metadata;
import org.openhab.core.items.MetadataAwareItem;
import org.openhab.core.library.types.DecimalType;
import org.openhab.core.library.types.QuantityType;
import org.openhab.core.library.unit.Units;
import org.openhab.core.types.Command;
import org.openhab.core.types.RefreshType;
import org.openhab.core.types.State;
import org.openhab.core.types.StateDescription;
import org.openhab.core.types.StateDescriptionFragmentBuilder;
import org.openhab.core.types.TimeSeries;
import org.openhab.core.types.UnDefType;
import org.openhab.core.types.util.UnitUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class NumberItem
extends GenericItem
implements MetadataAwareItem {
    public static final String UNIT_METADATA_NAMESPACE = "unit";
    private static final List<Class<? extends State>> ACCEPTED_DATA_TYPES = List.of(DecimalType.class, QuantityType.class, UnDefType.class);
    private static final List<Class<? extends Command>> ACCEPTED_COMMAND_TYPES = List.of(DecimalType.class, QuantityType.class, RefreshType.class);
    private final Logger logger = LoggerFactory.getLogger(NumberItem.class);
    private final @Nullable Class<? extends Quantity<?>> dimension;
    private Unit<?> unit = Units.ONE;
    private final @Nullable UnitProvider unitProvider;

    public NumberItem(String name) {
        this("Number", name, null);
    }

    public NumberItem(String type, String name, @Nullable UnitProvider unitProvider) {
        super(type, name);
        this.unitProvider = unitProvider;
        String itemTypeExtension = ItemUtil.getItemTypeExtension(this.getType());
        if (itemTypeExtension != null) {
            Class<Quantity<?>> dimension = UnitUtils.parseDimension(itemTypeExtension);
            this.dimension = dimension;
            if (dimension == null) {
                throw new IllegalArgumentException("The given dimension " + itemTypeExtension + " is unknown.");
            }
            if (unitProvider == null) {
                throw new IllegalArgumentException("A unit provider is required for items with a dimension.");
            }
            this.unit = unitProvider.getUnit(dimension);
            this.logger.trace("Item '{}' now has unit '{}'", (Object)name, this.unit);
        } else {
            this.dimension = null;
        }
    }

    @Override
    public List<Class<? extends State>> getAcceptedDataTypes() {
        return ACCEPTED_DATA_TYPES;
    }

    @Override
    public List<Class<? extends Command>> getAcceptedCommandTypes() {
        return ACCEPTED_COMMAND_TYPES;
    }

    public void send(DecimalType command) {
        this.internalSend(command);
    }

    public void send(QuantityType<?> command) {
        if (this.dimension == null) {
            DecimalType strippedCommand = new DecimalType(command);
            this.internalSend(strippedCommand);
        } else if (command.getUnit().isCompatible(this.unit) || command.getUnit().inverse().isCompatible(this.unit)) {
            this.internalSend(command);
        } else {
            this.logger.warn("Command '{}' to item '{}' was rejected because it is incompatible with the item unit '{}'", new Object[]{command, this.name, this.unit});
        }
    }

    @Override
    public @Nullable StateDescription getStateDescription(@Nullable Locale locale) {
        String pattern;
        StateDescription stateDescription = super.getStateDescription(locale);
        if (this.getDimension() == null && stateDescription != null && (pattern = stateDescription.getPattern()) != null && pattern.contains("%unit%")) {
            return StateDescriptionFragmentBuilder.create(stateDescription).withPattern(pattern.replaceAll("%unit%", "").trim()).build().toStateDescription();
        }
        return stateDescription;
    }

    public @Nullable Class<? extends Quantity<?>> getDimension() {
        return this.dimension;
    }

    private @Nullable State getInternalState(State state) {
        if (state instanceof QuantityType) {
            QuantityType<?> convertedState;
            QuantityType quantityType = (QuantityType)state;
            if (this.dimension == null) {
                return new DecimalType(quantityType);
            }
            Unit stateUnit = quantityType.getUnit();
            QuantityType<Object> quantityType2 = convertedState = stateUnit.isCompatible(this.unit) || stateUnit.inverse().isCompatible(this.unit) ? quantityType.toInvertibleUnit(this.unit) : null;
            if (convertedState != null) {
                return convertedState;
            }
            this.logger.warn("Failed to update item '{}' because '{}' could not be converted to the item unit '{}'", new Object[]{this.name, state, this.unit});
        } else if (state instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)state;
            if (this.dimension == null) {
                return decimalType;
            }
            return new QuantityType(decimalType.doubleValue(), this.unit);
        }
        return null;
    }

    @Override
    public void setState(State state) {
        if (state instanceof DecimalType || state instanceof QuantityType) {
            State internalState = this.getInternalState(state);
            if (internalState != null) {
                this.applyState(internalState);
            }
        } else if (state instanceof UnDefType) {
            this.applyState(state);
        } else {
            this.logSetTypeError(state);
        }
    }

    @Override
    public void setTimeSeries(TimeSeries timeSeries) {
        TimeSeries internalSeries = new TimeSeries(timeSeries.getPolicy());
        timeSeries.getStates().forEach(s -> internalSeries.add(s.timestamp(), Objects.requireNonNullElse(this.getInternalState(s.state()), UnDefType.NULL)));
        if (this.dimension != null && internalSeries.getStates().allMatch(s -> s.state() instanceof QuantityType)) {
            this.applyTimeSeries(internalSeries);
        } else if (internalSeries.getStates().allMatch(s -> s.state() instanceof DecimalType)) {
            this.applyTimeSeries(internalSeries);
        } else {
            this.logSetTypeError(timeSeries);
        }
    }

    public @Nullable String getUnitSymbol() {
        return this.dimension != null ? this.unit.toString() : null;
    }

    public @Nullable Unit<? extends Quantity<?>> getUnit() {
        return this.dimension != null ? this.unit : null;
    }

    @Override
    public void addedMetadata(Metadata metadata) {
        if (this.dimension != null && UNIT_METADATA_NAMESPACE.equals(metadata.getUID().getNamespace())) {
            Unit<?> unit = UnitUtils.parseUnit(metadata.getValue());
            if (unit == null || !unit.isCompatible(this.unit) && !unit.inverse().isCompatible(this.unit)) {
                this.logger.warn("Unit '{}' could not be parsed to a known unit. Keeping old unit '{}' for item '{}'.", new Object[]{metadata.getValue(), this.unit, this.name});
                return;
            }
            this.unit = unit;
            this.logger.trace("Item '{}' now has unit '{}'", (Object)this.name, unit);
        }
    }

    @Override
    public void updatedMetadata(Metadata oldMetadata, Metadata newMetadata) {
        this.addedMetadata(newMetadata);
    }

    @Override
    public void removedMetadata(Metadata metadata) {
        Class<? extends Quantity<?>> dimension = this.dimension;
        if (dimension != null && UNIT_METADATA_NAMESPACE.equals(metadata.getUID().getNamespace())) {
            this.unit = Objects.requireNonNull(this.unitProvider).getUnit(dimension);
            this.logger.trace("Item '{}' now has unit '{}'", (Object)this.name, this.unit);
        }
    }
}

